/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.msg.view;

import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.android.gmacs.R;
import com.android.gmacs.activity.GmacsMapActivity;
import com.android.gmacs.msg.view.IMMessageView;
import com.android.gmacs.view.GmacsDialog;
import com.common.gmacs.msg.IMMessage;
import com.common.gmacs.msg.data.IMLocationMsg;
import com.common.gmacs.utils.GmacsEnvi;

public class IMLocationMsgView
extends IMMessageView {
    public static final String ADDRESS = "address";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    private static final int sMapHeight = sMapWidth = GmacsEnvi.appContext.getResources().getDimensionPixelOffset(R.dimen.im_chat_msg_pic_msg_width);
    private static final int sMapWidth;
    private IMLocationMsg mLocationMsg;
    private RelativeLayout mRlLocation;
    private TextView mTvLocation;

    /*
     * Enabled aggressive block sorting
     */
    protected View initView(LayoutInflater layoutInflater) {
        this.mContentView = this.mLocationMsg.parentMsg.mIsSelfSendMsg ? layoutInflater.inflate(R.layout.gmacs_adapter_talk_item_content_right_map, null) : layoutInflater.inflate(R.layout.gmacs_adapter_talk_item_content_left_map, null);
        this.mContentView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(sMapWidth, sMapHeight));
        this.mRlLocation = (RelativeLayout)this.mContentView.findViewById(R.id.rl_location);
        this.mTvLocation = (TextView)this.mContentView.findViewById(R.id.tv_location);
        this.mRlLocation.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                view = new Intent(IMLocationMsgView.this.mTvLocation.getContext(), GmacsMapActivity.class);
                view.putExtra(IMLocationMsgView.LONGITUDE, ((IMLocationMsgView)IMLocationMsgView.this).mLocationMsg.mLongitude);
                view.putExtra(IMLocationMsgView.LATITUDE, ((IMLocationMsgView)IMLocationMsgView.this).mLocationMsg.mLatitude);
                view.putExtra(IMLocationMsgView.ADDRESS, ((IMLocationMsgView)IMLocationMsgView.this).mLocationMsg.mAddress);
                IMLocationMsgView.this.mTvLocation.getContext().startActivity((Intent)view);
            }
        });
        this.mContentView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                view = new GmacsDialog.Builder(IMLocationMsgView.this.getContentView().getContext(), 1);
                view.initDialog(new AdapterView.OnItemClickListener((GmacsDialog.Builder)view){
                    final /* synthetic */ GmacsDialog.Builder val$dialog;
                    {
                        this.val$dialog = builder;
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
                        switch (n2) {
                            default: {
                                break;
                            }
                            case 0: {
                                IMLocationMsgView.this.deleteIMMessageView();
                                this.val$dialog.dismiss();
                            }
                        }
                        this.val$dialog.dismiss();
                    }
                }).setListTexts((CharSequence[])new String[]{IMLocationMsgView.this.mChatActivity.getString(R.string.delete_message)}).create().show();
                return true;
            }
        });
        super.initView(layoutInflater);
        return this.mContentView;
    }

    public void setDataForView() {
        super.setDataForView();
        if (this.mLocationMsg != null) {
            this.mTvLocation.setText((CharSequence)this.mLocationMsg.mAddress);
        }
    }

    protected void setIMMessage(IMMessage iMMessage) {
        if (iMMessage instanceof IMLocationMsg) {
            this.mLocationMsg = (IMLocationMsg)iMMessage;
        }
    }
}

