/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.android.gmacs.R;

public class FastLetterIndexView
extends View {
    private boolean isShowIcon;
    private int mColorLetterNormal;
    private int mColorLetterPressed;
    private boolean mIsTouchDown;
    private float mLastIndexY;
    private String[] mLetters;
    private int mLettersLength;
    private final int mNoSearchHeight;
    private OnTouchLetterListener mOnTouchLetterListener;
    private Paint mPaint;
    private Rect mRectScrollerBg;
    private Rect mRectSearch;
    private NinePatchDrawable mScrollerBg;
    private Drawable mSearch = new ColorDrawable(0);
    private float mSearchY;
    private final float mSpaceFirstIndexPaddingTop;
    private final float mSpaceLastIndexPaddingBottom;
    private final float mSpaceScale;

    public FastLetterIndexView(Context context) {
        super(context);
        this.mSpaceScale = 0.33333334f;
        this.mSpaceFirstIndexPaddingTop = 4.0f;
        this.mSpaceLastIndexPaddingBottom = 4.0f;
        this.mNoSearchHeight = 0;
        this.init(context);
    }

    public FastLetterIndexView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mSpaceScale = 0.33333334f;
        this.mSpaceFirstIndexPaddingTop = 4.0f;
        this.mSpaceLastIndexPaddingBottom = 4.0f;
        this.mNoSearchHeight = 0;
        this.init(context);
    }

    public FastLetterIndexView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mSpaceScale = 0.33333334f;
        this.mSpaceFirstIndexPaddingTop = 4.0f;
        this.mSpaceLastIndexPaddingBottom = 4.0f;
        this.mNoSearchHeight = 0;
        this.init(context);
    }

    private void init(Context context) {
        this.setLetter(context, R.array.fast_letter_index_letters);
        this.mScrollerBg = (NinePatchDrawable)context.getResources().getDrawable(R.drawable.gmacs_ic_scroller_bg);
        this.mColorLetterNormal = context.getResources().getColor(R.color.gray_medium);
        this.mColorLetterPressed = context.getResources().getColor(R.color.gray_medium);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(this.mColorLetterNormal);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mRectScrollerBg = new Rect();
        this.mRectSearch = new Rect();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onDraw(Canvas canvas) {
        float f2;
        float f3;
        float f4;
        float f5;
        int n2 = 0;
        int n3 = 0;
        super.onDraw(canvas);
        if (this.isShowIcon) {
            if (this.mIsTouchDown) {
                this.mRectScrollerBg.set(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
                this.mScrollerBg.setBounds(this.mRectScrollerBg);
                this.mScrollerBg.draw(canvas);
                this.invalidate(this.mRectScrollerBg);
                this.mSearch.setState(PRESSED_ENABLED_STATE_SET);
                this.mPaint.setColor(this.mColorLetterPressed);
            } else {
                this.mSearch.setState(EMPTY_STATE_SET);
                this.mPaint.setColor(this.mColorLetterNormal);
            }
            if (this.isShowIcon) {
                n3 = this.mSearch.getIntrinsicHeight();
            }
            f5 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            f4 = (f5 - (float)n3 - 4.0f - 4.0f) / ((float)(this.mLettersLength - 1) + (float)(this.mLettersLength + 1) * 0.33333334f);
            f3 = f4 * 0.33333334f;
            f2 = f4;
            if (f4 > (float)(this.getWidth() - this.getPaddingRight() - this.getPaddingLeft())) {
                f2 = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
                f3 = (f5 - (float)n3 - 4.0f - 4.0f - (float)(this.mLettersLength - 1) * f2) / (float)(this.mLettersLength + 1);
            }
        } else {
            if (this.mIsTouchDown) {
                this.mRectScrollerBg.set(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
                this.mScrollerBg.setBounds(this.mRectScrollerBg);
                this.mScrollerBg.draw(canvas);
                this.invalidate(this.mRectScrollerBg);
                this.mPaint.setColor(this.mColorLetterPressed);
            } else {
                this.mPaint.setColor(this.mColorLetterNormal);
            }
            float f6 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            float f7 = (f6 - 4.0f - 4.0f) / ((float)this.mLettersLength + (float)(this.mLettersLength + 1) * 0.33333334f);
            float f8 = f7 * 0.33333334f;
            float f9 = f7;
            if (f7 > (float)(this.getWidth() - this.getPaddingRight() - this.getPaddingLeft())) {
                f9 = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
                f8 = (f6 - 4.0f - 4.0f - (float)this.mLettersLength * f9) / (float)(this.mLettersLength + 1);
            }
            f7 = this.getWidth() / 2;
            this.mPaint.setTextSize(f9);
            this.mSearchY = (float)this.getPaddingTop() + f8 + 4.0f + f9 + f8 / 2.0f;
            n3 = n2;
            while (true) {
                if (n3 >= this.mLettersLength) {
                    this.mRectScrollerBg.setEmpty();
                    this.mRectSearch.setEmpty();
                    return;
                }
                f6 = (float)this.getPaddingTop() + 4.0f + (f8 + f9) * (float)(n3 + 1);
                if (this.mLettersLength - 2 == n3) {
                    this.mLastIndexY = f8 / 2.0f + f6;
                }
                canvas.drawText(this.mLetters[n3], f7, f6, this.mPaint);
                ++n3;
            }
        }
        f5 = this.getWidth() / 2;
        this.mPaint.setTextSize(f2);
        this.mRectSearch.left = (this.getWidth() - this.mSearch.getIntrinsicWidth()) / 2;
        this.mRectSearch.top = (int)((float)this.getPaddingTop() + f3 + 4.0f);
        this.mRectSearch.right = (this.getWidth() + this.mSearch.getIntrinsicWidth()) / 2;
        this.mRectSearch.bottom = n3 + this.mRectSearch.top;
        this.mSearch.setBounds(this.mRectSearch);
        this.mSearch.draw(canvas);
        this.mSearchY = (float)this.mRectSearch.bottom + f3 / 2.0f;
        n3 = 1;
        while (true) {
            if (n3 >= this.mLettersLength) {
                this.mRectScrollerBg.setEmpty();
                this.mRectSearch.setEmpty();
                return;
            }
            f4 = 1 == n3 ? (float)this.mRectSearch.bottom + f3 + f2 : (float)this.mRectSearch.bottom + f3 + f2 + (float)(n3 - 1) * (f2 + f3);
            if (this.mLettersLength - 2 == n3) {
                this.mLastIndexY = f3 / 2.0f + f4;
            }
            canvas.drawText(this.mLetters[n3], f5, f4, this.mPaint);
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n2 = 0;
        int n3 = 0;
        switch (motionEvent.getAction()) {
            case 0: {
                this.mIsTouchDown = true;
                break;
            }
            case 1: {
                this.mIsTouchDown = false;
                break;
            }
            case 3: {
                this.mIsTouchDown = false;
            }
        }
        if (this.isShowIcon) {
            if (this.mOnTouchLetterListener != null) {
                float f2 = motionEvent.getY();
                if (!(f2 <= this.mSearchY)) {
                    if (f2 >= this.mLastIndexY) {
                        n3 = this.mLettersLength - 1;
                    } else {
                        float f3 = ((float)this.getHeight() - this.mSearchY - ((float)this.getHeight() - this.mLastIndexY)) / (float)(this.mLettersLength - 2);
                        n2 = (int)((f2 - this.mSearchY) / f3) + 1;
                        if (n2 <= 1) {
                            n3 = 1;
                        } else {
                            n3 = n2;
                            if (n2 >= this.mLettersLength - 1) {
                                n3 = this.mLettersLength - 2;
                            }
                        }
                    }
                }
                this.mOnTouchLetterListener.onTouchLetter(motionEvent, n3, this.mLetters[n3]);
            }
        } else if (this.mOnTouchLetterListener != null) {
            float f4 = motionEvent.getY();
            if (f4 <= this.mSearchY) {
                n3 = n2;
            } else if (f4 >= this.mLastIndexY) {
                n3 = this.mLettersLength - 1;
            } else {
                float f5 = ((float)this.getHeight() - this.mSearchY - ((float)this.getHeight() - this.mLastIndexY)) / (float)(this.mLettersLength - 2);
                n2 = (int)((f4 - this.mSearchY) / f5) + 1;
                if (n2 <= 1) {
                    n3 = 1;
                } else {
                    n3 = n2;
                    if (n2 >= this.mLettersLength - 1) {
                        n3 = this.mLettersLength - 2;
                    }
                }
            }
            this.mOnTouchLetterListener.onTouchLetter(motionEvent, n3, this.mLetters[n3]);
        }
        this.invalidate();
        return true;
    }

    public void setLetter(Context context, int n2) {
        this.mLetters = context.getResources().getStringArray(n2);
        this.mLettersLength = this.mLetters.length;
    }

    public void setOnTouchLetterListener(OnTouchLetterListener onTouchLetterListener) {
        this.mOnTouchLetterListener = onTouchLetterListener;
    }

    public static interface OnTouchLetterListener {
        public void onTouchLetter(MotionEvent var1, int var2, String var3);
    }
}

