/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view.emoji;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import com.android.gmacs.R;
import com.android.gmacs.activity.GmacsChatActivity;
import com.android.gmacs.view.emoji.EmojiLayoutBuilder;
import com.common.gmacs.utils.GmacsUtils;

public class FaceLinearLayout
extends LinearLayout {
    private RelativeLayout contentView;
    private EmojiLayoutBuilder emojiLayoutBuilder;
    private GmacsChatActivity gmacsChatActivity;
    private LinearLayout scrollView;

    public FaceLinearLayout(Context context) {
        super(context);
    }

    public FaceLinearLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public FaceLinearLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean faceViewShown() {
        if (this.getVisibility() != 0) return false;
        return true;
    }

    public void hidden() {
        this.setVisibility(8);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        HorizontalScrollView horizontalScrollView = (HorizontalScrollView)this.findViewById(R.id.face_indicator);
        this.scrollView = (RadioGroup)this.findViewById(R.id.scroll_bar);
        this.contentView = (RelativeLayout)this.findViewById(R.id.face_layout);
        this.emojiLayoutBuilder = new EmojiLayoutBuilder(null);
        horizontalScrollView = this.emojiLayoutBuilder.getEmojiLayout();
        this.contentView.removeAllViews();
        this.contentView.addView((View)horizontalScrollView, -1, -1);
        horizontalScrollView = new RadioButton(this.getContext());
        horizontalScrollView.setButtonDrawable(R.color.transparent);
        horizontalScrollView.setPadding(GmacsUtils.dipToPixel((float)10.0f), GmacsUtils.dipToPixel((float)3.0f), GmacsUtils.dipToPixel((float)10.0f), GmacsUtils.dipToPixel((float)3.0f));
        horizontalScrollView.setBackgroundResource(R.drawable.gmacs_bg_tab_bottom_normal);
        horizontalScrollView.setWidth(GmacsUtils.dipToPixel((float)62.0f));
        horizontalScrollView.setGravity(17);
        horizontalScrollView.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.smiley_001, 0, 0);
        this.scrollView.addView((View)horizontalScrollView);
        horizontalScrollView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FaceLinearLayout.this.contentView.removeAllViews();
                FaceLinearLayout.this.contentView.addView(FaceLinearLayout.this.emojiLayoutBuilder.getEmojiLayout(), -1, -2);
                FaceLinearLayout.this.emojiLayoutBuilder.getEmojiLayout().requestFocus();
            }
        });
        horizontalScrollView.setChecked(true);
    }

    public void setGmacsChatActivity(GmacsChatActivity gmacsChatActivity) {
        this.gmacsChatActivity = gmacsChatActivity;
    }

    public void setMessageEditView(EditText editText) {
        this.emojiLayoutBuilder.setMessageEditView(editText);
    }

    public void setOnlyStatic() {
        if (this.scrollView != null) {
            for (int i2 = 1; i2 < this.scrollView.getChildCount(); ++i2) {
                this.scrollView.getChildAt(i2).setVisibility(8);
            }
        }
    }

    public void show() {
        this.setVisibility(0);
    }
}

