/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view.photoview.gestures;

import android.annotation.TargetApi;
import android.content.Context;
import android.view.MotionEvent;
import com.android.gmacs.view.photoview.Compat;
import com.android.gmacs.view.photoview.gestures.CupcakeGestureDetector;

@TargetApi(value=5)
public class EclairGestureDetector
extends CupcakeGestureDetector {
    private static final int INVALID_POINTER_ID = -1;
    private int mActivePointerId = -1;
    private int mActivePointerIndex = 0;

    public EclairGestureDetector(Context context) {
        super(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    float getActiveX(MotionEvent motionEvent) {
        try {
            return motionEvent.getX(this.mActivePointerIndex);
        }
        catch (Exception exception) {
            return motionEvent.getX();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    float getActiveY(MotionEvent motionEvent) {
        try {
            return motionEvent.getY(this.mActivePointerIndex);
        }
        catch (Exception exception) {
            return motionEvent.getY();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n2;
        int n3 = 0;
        switch (motionEvent.getAction() & 0xFF) {
            case 0: {
                this.mActivePointerId = motionEvent.getPointerId(0);
                break;
            }
            case 1: 
            case 3: {
                this.mActivePointerId = -1;
                break;
            }
            case 6: {
                n2 = Compat.getPointerIndex(motionEvent.getAction());
                if (motionEvent.getPointerId(n2) != this.mActivePointerId) break;
                n2 = n2 == 0 ? 1 : 0;
                this.mActivePointerId = motionEvent.getPointerId(n2);
                this.mLastTouchX = motionEvent.getX(n2);
                this.mLastTouchY = motionEvent.getY(n2);
                break;
            }
        }
        n2 = n3;
        if (this.mActivePointerId != -1) {
            n2 = this.mActivePointerId;
        }
        this.mActivePointerIndex = motionEvent.findPointerIndex(n2);
        return super.onTouchEvent(motionEvent);
    }
}

