/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import android.text.TextUtils;
import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.util.ContentLengthInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

public class HttpUrlFetcher
implements DataFetcher<InputStream> {
    private static final HttpUrlConnectionFactory DEFAULT_CONNECTION_FACTORY = new DefaultHttpUrlConnectionFactory();
    private static final int MAXIMUM_REDIRECTS = 5;
    private static final String TAG = "HttpUrlFetcher";
    private final HttpUrlConnectionFactory connectionFactory;
    private final GlideUrl glideUrl;
    private volatile boolean isCancelled;
    private InputStream stream;
    private HttpURLConnection urlConnection;

    public HttpUrlFetcher(GlideUrl glideUrl) {
        this(glideUrl, DEFAULT_CONNECTION_FACTORY);
    }

    HttpUrlFetcher(GlideUrl glideUrl, HttpUrlConnectionFactory httpUrlConnectionFactory) {
        this.glideUrl = glideUrl;
        this.connectionFactory = httpUrlConnectionFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getStreamForSuccessfulRequest(HttpURLConnection httpURLConnection) throws IOException {
        if (TextUtils.isEmpty((CharSequence)httpURLConnection.getContentEncoding())) {
            int n2 = httpURLConnection.getContentLength();
            this.stream = ContentLengthInputStream.obtain(httpURLConnection.getInputStream(), n2);
            return this.stream;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("Got non empty content encoding: " + httpURLConnection.getContentEncoding()));
        }
        this.stream = httpURLConnection.getInputStream();
        return this.stream;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream loadDataWithRedirects(URL object, int n2, URL object2, Map<String, String> map) throws IOException {
        void var4_10;
        if (n2 >= 5) {
            throw new IOException("Too many (> 5) redirects!");
        }
        if (object2 != null) {
            try {
                if (((URL)object).toURI().equals(((URL)object2).toURI())) {
                    IOException iOException = new IOException("In re-direct loop");
                    throw iOException;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        this.urlConnection = this.connectionFactory.build((URL)object);
        for (Map.Entry entry : var4_10.entrySet()) {
            this.urlConnection.addRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
        this.urlConnection.setConnectTimeout(2500);
        this.urlConnection.setReadTimeout(2500);
        this.urlConnection.setUseCaches(false);
        this.urlConnection.setDoInput(true);
        this.urlConnection.connect();
        if (this.isCancelled) {
            return null;
        }
        int n3 = this.urlConnection.getResponseCode();
        if (n3 / 100 == 2) {
            return this.getStreamForSuccessfulRequest(this.urlConnection);
        }
        if (n3 / 100 == 3) {
            String string2 = this.urlConnection.getHeaderField("Location");
            if (!TextUtils.isEmpty((CharSequence)string2)) return this.loadDataWithRedirects(new URL((URL)object, string2), n2 + 1, (URL)object, (Map<String, String>)var4_10);
            throw new IOException("Received empty or null redirect url");
        }
        if (n3 != -1) throw new IOException("Request failed " + n3 + ": " + this.urlConnection.getResponseMessage());
        throw new IOException("Unable to retrieve response code from HttpUrlConnection.");
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cleanup() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.urlConnection != null) {
            this.urlConnection.disconnect();
        }
    }

    @Override
    public String getId() {
        return this.glideUrl.getCacheKey();
    }

    @Override
    public InputStream loadData(Priority priority) throws Exception {
        return this.loadDataWithRedirects(this.glideUrl.toURL(), 0, null, this.glideUrl.getHeaders());
    }

    private static class DefaultHttpUrlConnectionFactory
    implements HttpUrlConnectionFactory {
        private DefaultHttpUrlConnectionFactory() {
        }

        @Override
        public HttpURLConnection build(URL uRL) throws IOException {
            return (HttpURLConnection)uRL.openConnection();
        }
    }

    static interface HttpUrlConnectionFactory {
        public HttpURLConnection build(URL var1) throws IOException;
    }
}

