/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.data.ExifOrientationStream;
import com.bumptech.glide.load.resource.bitmap.ImageHeaderParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class MediaStoreThumbFetcher
implements DataFetcher<InputStream> {
    private static final ThumbnailStreamOpenerFactory DEFAULT_FACTORY = new ThumbnailStreamOpenerFactory();
    private static final int MINI_HEIGHT = 384;
    private static final int MINI_WIDTH = 512;
    private static final String TAG = "MediaStoreThumbFetcher";
    private final Context context;
    private final DataFetcher<InputStream> defaultFetcher;
    private final ThumbnailStreamOpenerFactory factory;
    private final int height;
    private InputStream inputStream;
    private final Uri mediaStoreUri;
    private final int width;

    public MediaStoreThumbFetcher(Context context, Uri uri, DataFetcher<InputStream> dataFetcher, int n2, int n3) {
        this(context, uri, dataFetcher, n2, n3, DEFAULT_FACTORY);
    }

    MediaStoreThumbFetcher(Context context, Uri uri, DataFetcher<InputStream> dataFetcher, int n2, int n3, ThumbnailStreamOpenerFactory thumbnailStreamOpenerFactory) {
        this.context = context;
        this.mediaStoreUri = uri;
        this.defaultFetcher = dataFetcher;
        this.width = n2;
        this.height = n3;
        this.factory = thumbnailStreamOpenerFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isMediaStoreUri(Uri uri) {
        if (uri == null) return false;
        if (!"content".equals(uri.getScheme())) return false;
        if (!"media".equals(uri.getAuthority())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isMediaStoreVideo(Uri uri) {
        if (!MediaStoreThumbFetcher.isMediaStoreUri(uri)) return false;
        if (!uri.getPathSegments().contains("video")) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream openThumbInputStream(ThumbnailStreamOpener object) {
        InputStream inputStream;
        block2: {
            InputStream inputStream2 = null;
            try {
                inputStream = ((ThumbnailStreamOpener)object).open(this.context, this.mediaStoreUri);
            }
            catch (FileNotFoundException fileNotFoundException) {
                inputStream = inputStream2;
                if (!Log.isLoggable((String)TAG, (int)3)) break block2;
                Log.d((String)TAG, (String)"Failed to find thumbnail file", (Throwable)fileNotFoundException);
                inputStream = inputStream2;
            }
        }
        int n2 = inputStream != null ? ((ThumbnailStreamOpener)object).getOrientation(this.context, this.mediaStoreUri) : -1;
        if (n2 == -1) return inputStream;
        return new ExifOrientationStream(inputStream, n2);
    }

    @Override
    public void cancel() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cleanup() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.defaultFetcher.cleanup();
    }

    @Override
    public String getId() {
        return this.mediaStoreUri.toString();
    }

    @Override
    public InputStream loadData(Priority priority) throws Exception {
        ThumbnailStreamOpener thumbnailStreamOpener = this.factory.build(this.mediaStoreUri, this.width, this.height);
        if (thumbnailStreamOpener != null) {
            this.inputStream = this.openThumbInputStream(thumbnailStreamOpener);
        }
        if (this.inputStream == null) {
            this.inputStream = this.defaultFetcher.loadData(priority);
        }
        return this.inputStream;
    }

    static class FileService {
        FileService() {
        }

        public boolean exists(File file) {
            return file.exists();
        }

        public File get(String string2) {
            return new File(string2);
        }

        public long length(File file) {
            return file.length();
        }
    }

    static class ImageThumbnailQuery
    implements ThumbnailQuery {
        private static final String[] PATH_PROJECTION = new String[]{"_data"};
        private static final String PATH_SELECTION = "kind = 1 AND image_id = ?";

        ImageThumbnailQuery() {
        }

        @Override
        public Cursor queryPath(Context context, Uri object) {
            object = object.getLastPathSegment();
            return context.getContentResolver().query(MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI, PATH_PROJECTION, PATH_SELECTION, new String[]{object}, null);
        }
    }

    static interface ThumbnailQuery {
        public Cursor queryPath(Context var1, Uri var2);
    }

    static class ThumbnailStreamOpener {
        private static final FileService DEFAULT_SERVICE = new FileService();
        private ThumbnailQuery query;
        private final FileService service;

        public ThumbnailStreamOpener(FileService fileService, ThumbnailQuery thumbnailQuery) {
            this.service = fileService;
            this.query = thumbnailQuery;
        }

        public ThumbnailStreamOpener(ThumbnailQuery thumbnailQuery) {
            this(DEFAULT_SERVICE, thumbnailQuery);
        }

        private Uri parseThumbUri(Cursor cursor) {
            Object var2_2 = null;
            Object object = cursor.getString(0);
            cursor = var2_2;
            if (!TextUtils.isEmpty((CharSequence)object)) {
                object = this.service.get((String)object);
                cursor = var2_2;
                if (this.service.exists((File)object)) {
                    cursor = var2_2;
                    if (this.service.length((File)object) > 0L) {
                        cursor = Uri.fromFile((File)object);
                    }
                }
            }
            return cursor;
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getOrientation(Context object, Uri uri) {
            int n2;
            int n3 = -1;
            Object object2 = null;
            Object object3 = null;
            object3 = object = object.getContentResolver().openInputStream(uri);
            object2 = object;
            object3 = object;
            object2 = object;
            Object object4 = new ImageHeaderParser((InputStream)object);
            object3 = object;
            object2 = object;
            n2 = n3 = (n2 = ((ImageHeaderParser)object4).getOrientation());
            if (object == null) return n2;
            try {
                ((InputStream)object).close();
                return n3;
            }
            catch (IOException iOException) {
                return n3;
            }
            catch (IOException iOException) {
                block17: {
                    object2 = object3;
                    if (!Log.isLoggable((String)MediaStoreThumbFetcher.TAG, (int)3)) break block17;
                    object2 = object3;
                    object2 = object3;
                    object4 = new StringBuilder();
                    object2 = object3;
                    Log.d((String)MediaStoreThumbFetcher.TAG, (String)((StringBuilder)object4).append("Failed to open uri: ").append(uri).toString(), (Throwable)iOException);
                }
                n2 = n3;
                if (object3 == null) return n2;
                try {
                    ((InputStream)object3).close();
                    return n3;
                }
                catch (IOException iOException2) {
                    return n3;
                }
                catch (Throwable throwable) {
                    if (object2 == null) throw throwable;
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (IOException iOException3) {
                        throw throwable;
                    }
                    throw throwable;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public InputStream open(Context context, Uri uri) throws FileNotFoundException {
            Cursor cursor;
            InputStream inputStream;
            block5: {
                block4: {
                    inputStream = null;
                    cursor = this.query.queryPath(context, uri);
                    if (cursor != null) {
                        try {
                            if (!cursor.moveToFirst()) break block4;
                            uri = this.parseThumbUri(cursor);
                            break block5;
                        }
                        catch (Throwable throwable) {
                            if (cursor == null) throw throwable;
                            cursor.close();
                            throw throwable;
                        }
                    }
                }
                uri = null;
            }
            if (cursor != null) {
                cursor.close();
            }
            if (uri == null) return inputStream;
            return context.getContentResolver().openInputStream(uri);
        }
    }

    static class ThumbnailStreamOpenerFactory {
        ThumbnailStreamOpenerFactory() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ThumbnailStreamOpener build(Uri object, int n2, int n3) {
            void var1_3;
            void var3_7;
            void var2_6;
            if (!MediaStoreThumbFetcher.isMediaStoreUri(object) || var2_6 > 512 || var3_7 > 384) {
                Object var1_2 = null;
                return var1_3;
            }
            if (MediaStoreThumbFetcher.isMediaStoreVideo(object)) {
                ThumbnailStreamOpener thumbnailStreamOpener = new ThumbnailStreamOpener(new VideoThumbnailQuery());
                return var1_3;
            }
            ThumbnailStreamOpener thumbnailStreamOpener = new ThumbnailStreamOpener(new ImageThumbnailQuery());
            return var1_3;
        }
    }

    static class VideoThumbnailQuery
    implements ThumbnailQuery {
        private static final String[] PATH_PROJECTION = new String[]{"_data"};
        private static final String PATH_SELECTION = "kind = 1 AND video_id = ?";

        VideoThumbnailQuery() {
        }

        @Override
        public Cursor queryPath(Context context, Uri object) {
            object = object.getLastPathSegment();
            return context.getContentResolver().query(MediaStore.Video.Thumbnails.EXTERNAL_CONTENT_URI, PATH_PROJECTION, PATH_SELECTION, new String[]{object}, null);
        }
    }
}

