/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.bitmap_recycle;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import com.bumptech.glide.load.engine.bitmap_recycle.AttributeStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.SizeConfigStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LruBitmapPool
implements BitmapPool {
    private static final Bitmap.Config DEFAULT_CONFIG = Bitmap.Config.ARGB_8888;
    private static final String TAG = "LruBitmapPool";
    private final Set<Bitmap.Config> allowedConfigs;
    private int currentSize;
    private int evictions;
    private int hits;
    private final int initialMaxSize;
    private int maxSize;
    private int misses;
    private int puts;
    private final LruPoolStrategy strategy;
    private final BitmapTracker tracker;

    public LruBitmapPool(int n2) {
        this(n2, LruBitmapPool.getDefaultStrategy(), LruBitmapPool.getDefaultAllowedConfigs());
    }

    LruBitmapPool(int n2, LruPoolStrategy lruPoolStrategy, Set<Bitmap.Config> set) {
        this.initialMaxSize = n2;
        this.maxSize = n2;
        this.strategy = lruPoolStrategy;
        this.allowedConfigs = set;
        this.tracker = new NullBitmapTracker();
    }

    public LruBitmapPool(int n2, Set<Bitmap.Config> set) {
        this(n2, LruBitmapPool.getDefaultStrategy(), set);
    }

    private void dump() {
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.dumpUnchecked();
        }
    }

    private void dumpUnchecked() {
        Log.v((String)TAG, (String)("Hits=" + this.hits + ", misses=" + this.misses + ", puts=" + this.puts + ", evictions=" + this.evictions + ", currentSize=" + this.currentSize + ", maxSize=" + this.maxSize + "\nStrategy=" + this.strategy));
    }

    private void evict() {
        this.trimToSize(this.maxSize);
    }

    private static Set<Bitmap.Config> getDefaultAllowedConfigs() {
        HashSet<Bitmap.Config> hashSet = new HashSet<Bitmap.Config>();
        hashSet.addAll(Arrays.asList(Bitmap.Config.values()));
        if (Build.VERSION.SDK_INT >= 19) {
            hashSet.add(null);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LruPoolStrategy getDefaultStrategy() {
        void var0_1;
        if (Build.VERSION.SDK_INT >= 19) {
            SizeConfigStrategy sizeConfigStrategy = new SizeConfigStrategy();
            return var0_1;
        }
        AttributeStrategy attributeStrategy = new AttributeStrategy();
        return var0_1;
    }

    private void trimToSize(int n2) {
        synchronized (this) {
            while (true) {
                Bitmap bitmap;
                block12: {
                    block11: {
                        if (this.currentSize <= n2) break block11;
                        bitmap = this.strategy.removeLast();
                        if (bitmap != null) break block12;
                        if (Log.isLoggable((String)TAG, (int)5)) {
                            Log.w((String)TAG, (String)"Size mismatch, resetting");
                            this.dumpUnchecked();
                        }
                        this.currentSize = 0;
                    }
                    return;
                }
                this.tracker.remove(bitmap);
                this.currentSize -= this.strategy.getSize(bitmap);
                bitmap.recycle();
                ++this.evictions;
                if (Log.isLoggable((String)TAG, (int)3)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Log.d((String)TAG, (String)stringBuilder.append("Evicting bitmap=").append(this.strategy.logBitmap(bitmap)).toString());
                }
                this.dump();
            }
        }
    }

    public void clearMemory() {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"clearMemory");
        }
        this.trimToSize(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap get(int n2, int n3, Bitmap.Config config) {
        synchronized (this) {
            config = this.getDirty(n2, n3, config);
            if (config != null) {
                config.eraseColor(0);
            }
            return config;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=12)
    public Bitmap getDirty(int n2, int n3, Bitmap.Config config) {
        synchronized (this) {
            Object object = this.strategy;
            Bitmap.Config config2 = config != null ? config : DEFAULT_CONFIG;
            if ((config2 = object.get(n2, n3, config2)) == null) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    object = new StringBuilder();
                    Log.d((String)TAG, (String)((StringBuilder)object).append("Missing bitmap=").append(this.strategy.logBitmap(n2, n3, config)).toString());
                }
                ++this.misses;
            } else {
                ++this.hits;
                this.currentSize -= this.strategy.getSize((Bitmap)config2);
                this.tracker.remove((Bitmap)config2);
                if (Build.VERSION.SDK_INT >= 12) {
                    config2.setHasAlpha(true);
                }
            }
            if (Log.isLoggable((String)TAG, (int)2)) {
                object = new StringBuilder();
                Log.v((String)TAG, (String)((StringBuilder)object).append("Get bitmap=").append(this.strategy.logBitmap(n2, n3, config)).toString());
            }
            this.dump();
            return config2;
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean put(Bitmap object) {
        synchronized (this) {
            if (object == null) {
                object = new NullPointerException("Bitmap must not be null");
                throw object;
            }
            if (!object.isMutable() || this.strategy.getSize((Bitmap)object) > this.maxSize || !this.allowedConfigs.contains(object.getConfig())) {
                if (!Log.isLoggable((String)TAG, (int)2)) return false;
                StringBuilder stringBuilder = new StringBuilder();
                Log.v((String)TAG, (String)stringBuilder.append("Reject bitmap from pool, bitmap: ").append(this.strategy.logBitmap((Bitmap)object)).append(", is mutable: ").append(object.isMutable()).append(", is allowed config: ").append(this.allowedConfigs.contains(object.getConfig())).toString());
                return false;
            }
            int n2 = this.strategy.getSize((Bitmap)object);
            this.strategy.put((Bitmap)object);
            this.tracker.add((Bitmap)object);
            ++this.puts;
            this.currentSize = n2 + this.currentSize;
            if (Log.isLoggable((String)TAG, (int)2)) {
                StringBuilder stringBuilder = new StringBuilder();
                Log.v((String)TAG, (String)stringBuilder.append("Put bitmap in pool=").append(this.strategy.logBitmap((Bitmap)object)).toString());
            }
            this.dump();
            this.evict();
            return true;
        }
    }

    public void setSizeMultiplier(float f2) {
        synchronized (this) {
            this.maxSize = Math.round((float)this.initialMaxSize * f2);
            this.evict();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"InlinedApi"})
    public void trimMemory(int n2) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("trimMemory, level=" + n2));
        }
        if (n2 >= 60) {
            this.clearMemory();
            return;
        }
        if (n2 < 40) return;
        this.trimToSize(this.maxSize / 2);
    }

    private static interface BitmapTracker {
        public void add(Bitmap var1);

        public void remove(Bitmap var1);
    }

    private static class NullBitmapTracker
    implements BitmapTracker {
        private NullBitmapTracker() {
        }

        @Override
        public void add(Bitmap bitmap) {
        }

        @Override
        public void remove(Bitmap bitmap) {
        }
    }

    private static class ThrowingBitmapTracker
    implements BitmapTracker {
        private final Set<Bitmap> bitmaps = Collections.synchronizedSet(new HashSet());

        private ThrowingBitmapTracker() {
        }

        @Override
        public void add(Bitmap bitmap) {
            if (this.bitmaps.contains(bitmap)) {
                throw new IllegalStateException("Can't add already added bitmap: " + bitmap + " [" + bitmap.getWidth() + "x" + bitmap.getHeight() + "]");
            }
            this.bitmaps.add(bitmap);
        }

        @Override
        public void remove(Bitmap bitmap) {
            if (!this.bitmaps.contains(bitmap)) {
                throw new IllegalStateException("Cannot remove bitmap not in tracker");
            }
            this.bitmaps.remove(bitmap);
        }
    }
}

