/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.cache;

import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.DiskLruCacheWrapper;
import java.io.File;

public class DiskLruCacheFactory
implements DiskCache.Factory {
    private final CacheDirectoryGetter cacheDirectoryGetter;
    private final int diskCacheSize;

    public DiskLruCacheFactory(CacheDirectoryGetter cacheDirectoryGetter, int n2) {
        this.diskCacheSize = n2;
        this.cacheDirectoryGetter = cacheDirectoryGetter;
    }

    public DiskLruCacheFactory(final String string2, int n2) {
        this(new CacheDirectoryGetter(){

            @Override
            public File getCacheDirectory() {
                return new File(string2);
            }
        }, n2);
    }

    public DiskLruCacheFactory(final String string2, final String string3, int n2) {
        this(new CacheDirectoryGetter(){

            @Override
            public File getCacheDirectory() {
                return new File(string2, string3);
            }
        }, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DiskCache build() {
        DiskCache diskCache = null;
        File file = this.cacheDirectoryGetter.getCacheDirectory();
        if (file == null) {
            return diskCache;
        }
        if (file.mkdirs()) return DiskLruCacheWrapper.get(file, this.diskCacheSize);
        DiskCache diskCache2 = diskCache;
        if (!file.exists()) return diskCache2;
        diskCache2 = diskCache;
        if (!file.isDirectory()) return diskCache2;
        return DiskLruCacheWrapper.get(file, this.diskCacheSize);
    }

    public static interface CacheDirectoryGetter {
        public File getCacheDirectory();
    }
}

