/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.prefill;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.load.engine.prefill.PreFillQueue;
import com.bumptech.glide.load.engine.prefill.PreFillType;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.util.Util;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

final class BitmapPreFillRunner
implements Runnable {
    static final int BACKOFF_RATIO = 4;
    private static final Clock DEFAULT_CLOCK = new Clock();
    static final long INITIAL_BACKOFF_MS = 40L;
    static final long MAX_BACKOFF_MS = TimeUnit.SECONDS.toMillis(1L);
    static final long MAX_DURATION_MS = 32L;
    private static final String TAG = "PreFillRunner";
    private final BitmapPool bitmapPool;
    private final Clock clock;
    private long currentDelay = 40L;
    private final Handler handler;
    private boolean isCancelled;
    private final MemoryCache memoryCache;
    private final Set<PreFillType> seenTypes = new HashSet<PreFillType>();
    private final PreFillQueue toPrefill;

    public BitmapPreFillRunner(BitmapPool bitmapPool, MemoryCache memoryCache, PreFillQueue preFillQueue) {
        this(bitmapPool, memoryCache, preFillQueue, DEFAULT_CLOCK, new Handler(Looper.getMainLooper()));
    }

    BitmapPreFillRunner(BitmapPool bitmapPool, MemoryCache memoryCache, PreFillQueue preFillQueue, Clock clock, Handler handler) {
        this.bitmapPool = bitmapPool;
        this.memoryCache = memoryCache;
        this.toPrefill = preFillQueue;
        this.clock = clock;
        this.handler = handler;
    }

    private void addToBitmapPool(PreFillType preFillType, Bitmap bitmap) {
        if (this.seenTypes.add(preFillType) && (preFillType = this.bitmapPool.get(preFillType.getWidth(), preFillType.getHeight(), preFillType.getConfig())) != null) {
            this.bitmapPool.put((Bitmap)preFillType);
        }
        this.bitmapPool.put(bitmap);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean allocate() {
        long l2 = this.clock.now();
        while (!this.toPrefill.isEmpty() && !this.isGcDetected(l2)) {
            PreFillType preFillType = this.toPrefill.remove();
            Bitmap bitmap = Bitmap.createBitmap((int)preFillType.getWidth(), (int)preFillType.getHeight(), (Bitmap.Config)preFillType.getConfig());
            if (this.getFreeMemoryCacheBytes() >= Util.getBitmapByteSize((Bitmap)bitmap)) {
                this.memoryCache.put(new UniqueKey(), BitmapResource.obtain(bitmap, this.bitmapPool));
            } else {
                this.addToBitmapPool(preFillType, bitmap);
            }
            if (!Log.isLoggable((String)TAG, (int)3)) continue;
            Log.d((String)TAG, (String)("allocated [" + preFillType.getWidth() + "x" + preFillType.getHeight() + "] " + preFillType.getConfig() + " size: " + Util.getBitmapByteSize((Bitmap)bitmap)));
        }
        if (this.isCancelled) return false;
        if (this.toPrefill.isEmpty()) return false;
        return true;
    }

    private int getFreeMemoryCacheBytes() {
        return this.memoryCache.getMaxSize() - this.memoryCache.getCurrentSize();
    }

    private long getNextDelay() {
        long l2 = this.currentDelay;
        this.currentDelay = Math.min(this.currentDelay * 4L, MAX_BACKOFF_MS);
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isGcDetected(long l2) {
        if (this.clock.now() - l2 < 32L) return false;
        return true;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    public void run() {
        if (this.allocate()) {
            this.handler.postDelayed((Runnable)this, this.getNextDelay());
        }
    }

    static class Clock {
        Clock() {
        }

        public long now() {
            return SystemClock.currentThreadTimeMillis();
        }
    }

    private static class UniqueKey
    implements Key {
        private UniqueKey() {
        }

        @Override
        public void updateDiskCacheKey(MessageDigest messageDigest) throws UnsupportedEncodingException {
        }
    }
}

