/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.ImageVideoWrapper;
import com.bumptech.glide.load.model.ModelLoader;
import java.io.InputStream;

public class ImageVideoModelLoader<A>
implements ModelLoader<A, ImageVideoWrapper> {
    private static final String TAG = "IVML";
    private final ModelLoader<A, ParcelFileDescriptor> fileDescriptorLoader;
    private final ModelLoader<A, InputStream> streamLoader;

    public ImageVideoModelLoader(ModelLoader<A, InputStream> modelLoader, ModelLoader<A, ParcelFileDescriptor> modelLoader2) {
        if (modelLoader == null && modelLoader2 == null) {
            throw new NullPointerException("At least one of streamLoader and fileDescriptorLoader must be non null");
        }
        this.streamLoader = modelLoader;
        this.fileDescriptorLoader = modelLoader2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public DataFetcher<ImageVideoWrapper> getResourceFetcher(A object, int n2, int n3) {
        void var1_3;
        void var3_6;
        void var2_5;
        ImageVideoFetcher imageVideoFetcher = null;
        DataFetcher<InputStream> dataFetcher = this.streamLoader != null ? this.streamLoader.getResourceFetcher(object, (int)var2_5, (int)var3_6) : null;
        if (this.fileDescriptorLoader != null) {
            DataFetcher<ParcelFileDescriptor> dataFetcher2 = this.fileDescriptorLoader.getResourceFetcher(object, (int)var2_5, (int)var3_6);
        } else {
            Object var1_4 = null;
        }
        if (dataFetcher != null) return new ImageVideoFetcher(dataFetcher, (DataFetcher<ParcelFileDescriptor>)var1_3);
        if (var1_3 == null) return imageVideoFetcher;
        return new ImageVideoFetcher(dataFetcher, (DataFetcher<ParcelFileDescriptor>)var1_3);
    }

    static class ImageVideoFetcher
    implements DataFetcher<ImageVideoWrapper> {
        private final DataFetcher<ParcelFileDescriptor> fileDescriptorFetcher;
        private final DataFetcher<InputStream> streamFetcher;

        public ImageVideoFetcher(DataFetcher<InputStream> dataFetcher, DataFetcher<ParcelFileDescriptor> dataFetcher2) {
            this.streamFetcher = dataFetcher;
            this.fileDescriptorFetcher = dataFetcher2;
        }

        @Override
        public void cancel() {
            if (this.streamFetcher != null) {
                this.streamFetcher.cancel();
            }
            if (this.fileDescriptorFetcher != null) {
                this.fileDescriptorFetcher.cancel();
            }
        }

        @Override
        public void cleanup() {
            if (this.streamFetcher != null) {
                this.streamFetcher.cleanup();
            }
            if (this.fileDescriptorFetcher != null) {
                this.fileDescriptorFetcher.cleanup();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getId() {
            if (this.streamFetcher == null) return this.fileDescriptorFetcher.getId();
            return this.streamFetcher.getId();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ImageVideoWrapper loadData(Priority priority) throws Exception {
            InputStream inputStream;
            ParcelFileDescriptor parcelFileDescriptor;
            block7: {
                block8: {
                    parcelFileDescriptor = null;
                    if (this.streamFetcher != null) {
                        try {
                            inputStream = this.streamFetcher.loadData(priority);
                            break block7;
                        }
                        catch (Exception exception) {
                            if (Log.isLoggable((String)ImageVideoModelLoader.TAG, (int)2)) {
                                Log.v((String)ImageVideoModelLoader.TAG, (String)"Exception fetching input stream, trying ParcelFileDescriptor", (Throwable)exception);
                            }
                            if (this.fileDescriptorFetcher != null) break block8;
                            throw exception;
                        }
                    }
                }
                inputStream = null;
            }
            ParcelFileDescriptor parcelFileDescriptor2 = parcelFileDescriptor;
            if (this.fileDescriptorFetcher == null) return new ImageVideoWrapper(inputStream, parcelFileDescriptor2);
            try {
                parcelFileDescriptor2 = this.fileDescriptorFetcher.loadData(priority);
                return new ImageVideoWrapper(inputStream, parcelFileDescriptor2);
            }
            catch (Exception exception) {
                if (Log.isLoggable((String)ImageVideoModelLoader.TAG, (int)2)) {
                    Log.v((String)ImageVideoModelLoader.TAG, (String)"Exception fetching ParcelFileDescriptor", (Throwable)exception);
                }
                parcelFileDescriptor2 = parcelFileDescriptor;
                if (inputStream != null) return new ImageVideoWrapper(inputStream, parcelFileDescriptor2);
                throw exception;
            }
        }
    }
}

