/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.util.Log;
import com.bumptech.glide.load.Encoder;
import com.bumptech.glide.util.ByteArrayPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamEncoder
implements Encoder<InputStream> {
    private static final String TAG = "StreamEncoder";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean encode(InputStream inputStream, OutputStream outputStream) {
        boolean bl = false;
        byte[] byArray = ByteArrayPool.get().getBytes();
        try {
            try {
                int n2;
                while ((n2 = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)"Failed to encode data onto the OutputStream", (Throwable)iOException);
                }
                ByteArrayPool.get().releaseBytes(byArray);
                return bl;
            }
            bl = true;
            ByteArrayPool.get().releaseBytes(byArray);
            return bl;
        }
        catch (Throwable throwable) {
            ByteArrayPool.get().releaseBytes(byArray);
            throw throwable;
        }
    }

    @Override
    public String getId() {
        return "";
    }
}

