/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ImageHeaderParser {
    private static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int EXIF_MAGIC_NUMBER = 65496;
    private static final int EXIF_SEGMENT_TYPE = 225;
    private static final int GIF_HEADER = 4671814;
    private static final int INTEL_TIFF_MAGIC_NUMBER = 18761;
    private static final String JPEG_EXIF_SEGMENT_PREAMBLE = "Exif\u0000\u0000";
    private static final byte[] JPEG_EXIF_SEGMENT_PREAMBLE_BYTES;
    private static final int MARKER_EOI = 217;
    private static final int MOTOROLA_TIFF_MAGIC_NUMBER = 19789;
    private static final int ORIENTATION_TAG_TYPE = 274;
    private static final int PNG_HEADER = -1991225785;
    private static final int SEGMENT_SOS = 218;
    private static final int SEGMENT_START_ID = 255;
    private static final String TAG = "ImageHeaderParser";
    private final StreamReader streamReader;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        byte[] byArray = new byte[]{};
        try {
            byte[] byArray2 = JPEG_EXIF_SEGMENT_PREAMBLE.getBytes("UTF-8");
            byArray = byArray2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        JPEG_EXIF_SEGMENT_PREAMBLE_BYTES = byArray;
    }

    public ImageHeaderParser(InputStream inputStream) {
        this.streamReader = new StreamReader(inputStream);
    }

    private static int calcTagOffset(int n2, int n3) {
        return n2 + 2 + n3 * 12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] getExifSegment() throws IOException {
        short s2;
        byte[] byArray;
        int n2;
        int n3;
        byte[] byArray2;
        block3: {
            long l2;
            byArray2 = null;
            do {
                if ((n2 = this.streamReader.getUInt8()) != 255) {
                    byArray = byArray2;
                    if (!Log.isLoggable((String)TAG, (int)3)) return byArray;
                    Log.d((String)TAG, (String)("Unknown segmentId=" + n2));
                    return byArray2;
                }
                s2 = this.streamReader.getUInt8();
                byArray = byArray2;
                if (s2 == 218) return byArray;
                if (s2 == 217) {
                    byArray = byArray2;
                    if (!Log.isLoggable((String)TAG, (int)3)) return byArray;
                    Log.d((String)TAG, (String)"Found MARKER_EOI in exif segment");
                    return byArray2;
                }
                n3 = this.streamReader.getUInt16() - 2;
                if (s2 == 225) break block3;
            } while ((l2 = this.streamReader.skip(n3)) == (long)n3);
            byArray = byArray2;
            if (!Log.isLoggable((String)TAG, (int)3)) return byArray;
            Log.d((String)TAG, (String)("Unable to skip enough data, type: " + s2 + ", wanted to skip: " + n3 + ", but actually skipped: " + l2));
            return byArray2;
        }
        byArray = new byte[n3];
        n2 = this.streamReader.read(byArray);
        if (n2 == n3) return byArray;
        byArray = byArray2;
        if (!Log.isLoggable((String)TAG, (int)3)) return byArray;
        Log.d((String)TAG, (String)("Unable to read segment data, type: " + s2 + ", length: " + n3 + ", actually read: " + n2));
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean handles(int n2) {
        if ((n2 & 0xFFD8) == 65496) return true;
        if (n2 == 19789) return true;
        if (n2 != 18761) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int parseExifSegment(RandomAccessReader randomAccessReader) {
        ByteOrder byteOrder;
        int n2 = JPEG_EXIF_SEGMENT_PREAMBLE.length();
        int n3 = randomAccessReader.getInt16(n2);
        if (n3 == 19789) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (n3 == 18761) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unknown endianness = " + n3));
            }
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        randomAccessReader.order(byteOrder);
        int n4 = n2 + randomAccessReader.getInt32(n2 + 4);
        n2 = randomAccessReader.getInt16(n4);
        n3 = 0;
        while (n3 < n2) {
            int n5 = ImageHeaderParser.calcTagOffset(n4, n3);
            short s2 = randomAccessReader.getInt16(n5);
            if (s2 == 274) {
                short s3 = randomAccessReader.getInt16(n5 + 2);
                if (s3 < 1 || s3 > 12) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.d((String)TAG, (String)("Got invalid format code=" + s3));
                    }
                } else {
                    int n6 = randomAccessReader.getInt32(n5 + 4);
                    if (n6 < 0) {
                        if (Log.isLoggable((String)TAG, (int)3)) {
                            Log.d((String)TAG, (String)"Negative tiff component count");
                        }
                    } else {
                        if (Log.isLoggable((String)TAG, (int)3)) {
                            Log.d((String)TAG, (String)("Got tagIndex=" + n3 + " tagType=" + s2 + " formatCode=" + s3 + " componentCount=" + n6));
                        }
                        if ((n6 += BYTES_PER_FORMAT[s3]) > 4) {
                            if (Log.isLoggable((String)TAG, (int)3)) {
                                Log.d((String)TAG, (String)("Got byte count > 4, not orientation, continuing, formatCode=" + s3));
                            }
                        } else if ((n5 += 8) < 0 || n5 > randomAccessReader.length()) {
                            if (Log.isLoggable((String)TAG, (int)3)) {
                                Log.d((String)TAG, (String)("Illegal tagValueOffset=" + n5 + " tagType=" + s2));
                            }
                        } else {
                            if (n6 >= 0 && n5 + n6 <= randomAccessReader.length()) {
                                return randomAccessReader.getInt16(n5);
                            }
                            if (Log.isLoggable((String)TAG, (int)3)) {
                                Log.d((String)TAG, (String)("Illegal number of bytes for TI tag data tagType=" + s2));
                            }
                        }
                    }
                }
            }
            ++n3;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getOrientation() throws IOException {
        int n2 = 0;
        if (!ImageHeaderParser.handles(this.streamReader.getUInt16())) {
            return -1;
        }
        byte[] byArray = this.getExifSegment();
        if (byArray == null) return -1;
        if (byArray.length <= JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length) return -1;
        int n3 = 1;
        if (n3 != 0) {
            for (int i2 = 0; i2 < JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length; ++i2) {
                if (byArray[i2] == JPEG_EXIF_SEGMENT_PREAMBLE_BYTES[i2]) continue;
                n3 = n2;
                break;
            }
        }
        if (n3 == 0) return -1;
        return ImageHeaderParser.parseExifSegment(new RandomAccessReader(byArray));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageType getType() throws IOException {
        int n2 = this.streamReader.getUInt16();
        if (n2 == 65496) {
            return ImageType.JPEG;
        }
        if ((n2 = n2 << 16 & 0xFFFF0000 | this.streamReader.getUInt16() & 0xFFFF) == -1991225785) {
            this.streamReader.skip(21L);
            if (this.streamReader.getByte() < 3) return ImageType.PNG;
            return ImageType.PNG_A;
        }
        if (n2 >> 8 != 4671814) return ImageType.UNKNOWN;
        return ImageType.GIF;
    }

    public boolean hasAlpha() throws IOException {
        return this.getType().hasAlpha();
    }

    public static enum ImageType {
        GIF(true),
        JPEG(false),
        PNG_A(true),
        PNG(false),
        UNKNOWN(false);

        private final boolean hasAlpha;

        private ImageType(boolean bl) {
            this.hasAlpha = bl;
        }

        public boolean hasAlpha() {
            return this.hasAlpha;
        }
    }

    private static class RandomAccessReader {
        private final ByteBuffer data;

        public RandomAccessReader(byte[] byArray) {
            this.data = ByteBuffer.wrap(byArray);
            this.data.order(ByteOrder.BIG_ENDIAN);
        }

        public short getInt16(int n2) {
            return this.data.getShort(n2);
        }

        public int getInt32(int n2) {
            return this.data.getInt(n2);
        }

        public int length() {
            return this.data.array().length;
        }

        public void order(ByteOrder byteOrder) {
            this.data.order(byteOrder);
        }
    }

    private static class StreamReader {
        private final InputStream is;

        public StreamReader(InputStream inputStream) {
            this.is = inputStream;
        }

        public int getByte() throws IOException {
            return this.is.read();
        }

        public int getUInt16() throws IOException {
            return this.is.read() << 8 & 0xFF00 | this.is.read() & 0xFF;
        }

        public short getUInt8() throws IOException {
            return (short)(this.is.read() & 0xFF);
        }

        public int read(byte[] byArray) throws IOException {
            int n2;
            int n3;
            for (n2 = byArray.length; n2 > 0 && (n3 = this.is.read(byArray, byArray.length - n2, n2)) != -1; n2 -= n3) {
            }
            return byArray.length - n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long skip(long l2) throws IOException {
            if (l2 < 0L) {
                return 0L;
            }
            long l3 = l2;
            while (true) {
                block8: {
                    block7: {
                        if (l3 <= 0L) break block7;
                        long l4 = this.is.skip(l3);
                        if (l4 > 0L) {
                            l3 -= l4;
                            continue;
                        }
                        if (this.is.read() != -1) break block8;
                    }
                    l2 -= l3;
                    return l2;
                }
                --l3;
            }
        }
    }
}

