/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.util.Log;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RecyclableBufferedInputStream
extends FilterInputStream {
    private static final String TAG = "BufferedIs";
    private volatile byte[] buf;
    private int count;
    private int marklimit;
    private int markpos = -1;
    private int pos;

    public RecyclableBufferedInputStream(InputStream inputStream, byte[] byArray) {
        super(inputStream);
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("buffer is null or empty");
        }
        this.buf = byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int fillbuf(InputStream inputStream, byte[] byArray) throws IOException {
        byte[] byArray2;
        int n2;
        int n3;
        if (this.markpos == -1 || this.pos - this.markpos >= this.marklimit) {
            int n4;
            n3 = n4 = inputStream.read(byArray);
            if (n4 <= 0) return n3;
            this.markpos = -1;
            this.pos = 0;
            this.count = n4;
            return n4;
        }
        if (this.markpos == 0 && this.marklimit > byArray.length && this.count == byArray.length) {
            n3 = n2 = byArray.length * 2;
            if (n2 > this.marklimit) {
                n3 = this.marklimit;
            }
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("allocate buffer of length: " + n3));
            }
            byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.buf = byArray2;
        } else {
            byArray2 = byArray;
            if (this.markpos > 0) {
                System.arraycopy(byArray, this.markpos, byArray, 0, byArray.length - this.markpos);
                byArray2 = byArray;
            }
        }
        this.pos -= this.markpos;
        this.markpos = 0;
        this.count = 0;
        n2 = inputStream.read(byArray2, this.pos, byArray2.length - this.pos);
        n3 = n2 <= 0 ? this.pos : this.pos + n2;
        this.count = n3;
        return n2;
    }

    private static IOException streamClosed() throws IOException {
        throw new IOException("BufferedInputStream is closed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int available() throws IOException {
        synchronized (this) {
            InputStream inputStream = this.in;
            if (this.buf != null && inputStream != null) {
                int n2 = this.count;
                int n3 = this.pos;
                int n4 = inputStream.available();
                return n4 + (n2 - n3);
            }
            throw RecyclableBufferedInputStream.streamClosed();
        }
    }

    @Override
    public void close() throws IOException {
        this.buf = null;
        InputStream inputStream = this.in;
        this.in = null;
        if (inputStream != null) {
            inputStream.close();
        }
    }

    public void fixMarkLimit() {
        synchronized (this) {
            this.marklimit = this.buf.length;
            return;
        }
    }

    @Override
    public void mark(int n2) {
        synchronized (this) {
            this.marklimit = Math.max(this.marklimit, n2);
            this.markpos = this.pos;
            return;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        Object object = -1;
        synchronized (this) {
            int n2;
            byte[] byArray = this.buf;
            Object object2 = this.in;
            if (byArray == null || object2 == null) {
                throw RecyclableBufferedInputStream.streamClosed();
            }
            if (this.pos < this.count || (n2 = this.fillbuf((InputStream)object2, byArray)) != -1) {
                object2 = byArray;
                if (byArray != this.buf) {
                    byArray = this.buf;
                    object2 = byArray;
                    if (byArray == null) {
                        throw RecyclableBufferedInputStream.streamClosed();
                    }
                }
                if (this.count - this.pos > 0) {
                    object = this.pos;
                    this.pos = object + 1;
                    object = object2[object];
                    object &= 0xFF;
                }
            }
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = -1;
        synchronized (this) {
            int n5;
            byte[] byArray2 = this.buf;
            if (byArray2 == null) {
                throw RecyclableBufferedInputStream.streamClosed();
            }
            if (n3 == 0) {
                return 0;
            }
            InputStream inputStream = this.in;
            if (inputStream == null) {
                throw RecyclableBufferedInputStream.streamClosed();
            }
            if (this.pos < this.count) {
                n5 = this.count - this.pos >= n3 ? n3 : this.count - this.pos;
                System.arraycopy(byArray2, this.pos, byArray, n2, n5);
                this.pos += n5;
                if (n5 == n3) return n5;
                if (inputStream.available() == 0) {
                    return n5;
                }
                n2 += n5;
                n5 = n3 - n5;
            } else {
                n5 = n3;
            }
            while (true) {
                byte[] byArray3;
                int n6;
                int n7;
                if (this.markpos == -1 && n5 >= byArray2.length) {
                    n6 = n7 = inputStream.read(byArray, n2, n5);
                    byArray3 = byArray2;
                    if (n7 == -1) {
                        n2 = n4;
                        if (n5 == n3) return n2;
                        return n3 - n5;
                    }
                } else {
                    if (this.fillbuf(inputStream, byArray2) == -1) {
                        n2 = n4;
                        if (n5 == n3) return n2;
                        return n3 - n5;
                    }
                    byArray3 = byArray2;
                    if (byArray2 != this.buf) {
                        byArray3 = byArray2 = this.buf;
                        if (byArray2 == null) {
                            throw RecyclableBufferedInputStream.streamClosed();
                        }
                    }
                    n6 = this.count - this.pos >= n5 ? n5 : this.count - this.pos;
                    System.arraycopy(byArray3, this.pos, byArray, n2, n6);
                    this.pos += n6;
                }
                if ((n5 -= n6) == 0) {
                    return n3;
                }
                n7 = inputStream.available();
                if (n7 == 0) {
                    return n3 - n5;
                }
                n2 += n6;
                byArray2 = byArray3;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void reset() throws IOException {
        synchronized (this) {
            if (this.buf == null) {
                IOException iOException = new IOException("Stream is closed");
                throw iOException;
            }
            if (-1 == this.markpos) {
                InvalidMarkException invalidMarkException = new InvalidMarkException("Mark has been invalidated");
                throw invalidMarkException;
            }
            this.pos = this.markpos;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long skip(long l2) throws IOException {
        synchronized (this) {
            byte[] byArray = this.buf;
            InputStream inputStream = this.in;
            if (byArray == null) {
                throw RecyclableBufferedInputStream.streamClosed();
            }
            if (l2 < 1L) {
                return 0L;
            }
            if (inputStream == null) {
                throw RecyclableBufferedInputStream.streamClosed();
            }
            if ((long)(this.count - this.pos) >= l2) {
                this.pos = (int)((long)this.pos + l2);
            } else {
                long l3 = this.count - this.pos;
                this.pos = this.count;
                if (this.markpos != -1 && l2 <= (long)this.marklimit) {
                    if (this.fillbuf(inputStream, byArray) == -1) {
                        return l3;
                    }
                    if ((long)(this.count - this.pos) >= l2 - l3) {
                        this.pos = (int)(l2 - l3 + (long)this.pos);
                    } else {
                        l2 = l3 + (long)this.count - (long)this.pos;
                        this.pos = this.count;
                    }
                } else {
                    l2 = inputStream.skip(l2 - l3);
                    return l3 + l2;
                }
            }
            return l2;
        }
    }

    public static class InvalidMarkException
    extends RuntimeException {
        private static final long serialVersionUID = -4338378848813561757L;

        public InvalidMarkException(String string2) {
            super(string2);
        }
    }
}

