/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.gif;

import android.graphics.Bitmap;
import android.util.Log;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.gifdecoder.GifHeader;
import com.bumptech.glide.gifdecoder.GifHeaderParser;
import com.bumptech.glide.gifencoder.AnimatedGifEncoder;
import com.bumptech.glide.load.ResourceEncoder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.UnitTransformation;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.gif.GifBitmapProvider;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.util.LogTime;
import java.io.IOException;
import java.io.OutputStream;

public class GifResourceEncoder
implements ResourceEncoder<GifDrawable> {
    private static final Factory FACTORY = new Factory();
    private static final String TAG = "GifEncoder";
    private final BitmapPool bitmapPool;
    private final Factory factory;
    private final GifDecoder.BitmapProvider provider;

    public GifResourceEncoder(BitmapPool bitmapPool) {
        this(bitmapPool, FACTORY);
    }

    GifResourceEncoder(BitmapPool bitmapPool, Factory factory) {
        this.bitmapPool = bitmapPool;
        this.provider = new GifBitmapProvider(bitmapPool);
        this.factory = factory;
    }

    private GifDecoder decodeHeaders(byte[] byArray) {
        Object object = this.factory.buildParser();
        ((GifHeaderParser)object).setData(byArray);
        object = ((GifHeaderParser)object).parseHeader();
        GifDecoder gifDecoder = this.factory.buildDecoder(this.provider);
        gifDecoder.setData((GifHeader)object, byArray);
        gifDecoder.advance();
        return gifDecoder;
    }

    private Resource<Bitmap> getTransformedFrame(Bitmap object, Transformation<Bitmap> object2, GifDrawable gifDrawable) {
        if (!(object = this.factory.buildFrameResource((Bitmap)object, this.bitmapPool)).equals(object2 = object2.transform((Resource<Bitmap>)object, gifDrawable.getIntrinsicWidth(), gifDrawable.getIntrinsicHeight()))) {
            object.recycle();
        }
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeDataDirect(byte[] byArray, OutputStream outputStream) {
        boolean bl = true;
        try {
            outputStream.write(byArray);
            return bl;
        }
        catch (IOException iOException) {
            if (!Log.isLoggable((String)TAG, (int)3)) return false;
            Log.d((String)TAG, (String)"Failed to write data to output stream in GifResourceEncoder", (Throwable)iOException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean encode(Resource<GifDrawable> object, OutputStream resource) {
        boolean bl = false;
        long l2 = LogTime.getLogTime();
        GifDrawable gifDrawable = (GifDrawable)object.get();
        Transformation<Bitmap> transformation = gifDrawable.getFrameTransformation();
        if (transformation instanceof UnitTransformation) {
            return this.writeDataDirect(gifDrawable.getData(), (OutputStream)((Object)resource));
        }
        GifDecoder gifDecoder = this.decodeHeaders(gifDrawable.getData());
        object = this.factory.buildEncoder();
        boolean bl2 = bl;
        if (!((AnimatedGifEncoder)object).start((OutputStream)((Object)resource))) return bl2;
        for (int i2 = 0; i2 < gifDecoder.getFrameCount(); ++i2) {
            block6: {
                resource = this.getTransformedFrame(gifDecoder.getNextFrame(), transformation, gifDrawable);
                bl2 = ((AnimatedGifEncoder)object).addFrame(resource.get());
                if (bl2) break block6;
                resource.recycle();
                return bl;
            }
            try {
                ((AnimatedGifEncoder)object).setDelay(gifDecoder.getDelay(gifDecoder.getCurrentFrameIndex()));
                gifDecoder.advance();
                continue;
            }
            finally {
                resource.recycle();
            }
        }
        bl2 = bl = ((AnimatedGifEncoder)object).finish();
        if (!Log.isLoggable((String)TAG, (int)2)) return bl2;
        Log.v((String)TAG, (String)("Encoded gif with " + gifDecoder.getFrameCount() + " frames and " + gifDrawable.getData().length + " bytes in " + LogTime.getElapsedMillis(l2) + " ms"));
        return bl;
    }

    @Override
    public String getId() {
        return "";
    }

    static class Factory {
        Factory() {
        }

        public GifDecoder buildDecoder(GifDecoder.BitmapProvider bitmapProvider) {
            return new GifDecoder(bitmapProvider);
        }

        public AnimatedGifEncoder buildEncoder() {
            return new AnimatedGifEncoder();
        }

        public Resource<Bitmap> buildFrameResource(Bitmap bitmap, BitmapPool bitmapPool) {
            return new BitmapResource(bitmap, bitmapPool);
        }

        public GifHeaderParser buildParser() {
            return new GifHeaderParser();
        }
    }
}

