/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import android.text.TextUtils;
import android.util.Log;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ContentLengthInputStream
extends FilterInputStream {
    private static final String TAG = "ContentLengthStream";
    private static final int UNKNOWN = -1;
    private final long contentLength;
    private int readSoFar;

    ContentLengthInputStream(InputStream inputStream, long l2) {
        super(inputStream);
        this.contentLength = l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int checkReadSoFarOrThrow(int n2) throws IOException {
        if (n2 >= 0) {
            this.readSoFar += n2;
            return n2;
        } else {
            if (this.contentLength - (long)this.readSoFar <= 0L) return n2;
            throw new IOException("Failed to read all expected data, expected: " + this.contentLength + ", but read: " + this.readSoFar);
        }
    }

    public static InputStream obtain(InputStream inputStream, long l2) {
        return new ContentLengthInputStream(inputStream, l2);
    }

    public static InputStream obtain(InputStream inputStream, String string2) {
        return ContentLengthInputStream.obtain(inputStream, ContentLengthInputStream.parseContentLength(string2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int parseContentLength(String string2) {
        int n2;
        int n3 = n2 = -1;
        if (TextUtils.isEmpty((CharSequence)string2)) return n3;
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n3 = n2;
            if (!Log.isLoggable((String)TAG, (int)3)) return n3;
            Log.d((String)TAG, (String)("failed to parse content length header: " + string2), (Throwable)numberFormatException);
            return n2;
        }
    }

    @Override
    public int available() throws IOException {
        synchronized (this) {
            long l2 = Math.max(this.contentLength - (long)this.readSoFar, (long)this.in.available());
            int n2 = (int)l2;
            return n2;
        }
    }

    @Override
    public int read() throws IOException {
        synchronized (this) {
            int n2 = this.checkReadSoFarOrThrow(super.read());
            return n2;
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        synchronized (this) {
            n2 = this.checkReadSoFarOrThrow(super.read(byArray, n2, n3));
            return n2;
        }
    }
}

