/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader;

import com.common.gmacs.downloader.HTTPSTrustManager;
import com.common.gmacs.downloader.HttpStack;
import com.common.gmacs.downloader.Request;
import com.common.gmacs.downloader.URLHttpResponse;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HurlStack
implements HttpStack {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private final SSLSocketFactory mSslSocketFactory;
    private final UrlRewriter mUrlRewriter;

    public HurlStack() {
        this(null);
    }

    public HurlStack(UrlRewriter urlRewriter) {
        this(urlRewriter, null);
    }

    public HurlStack(UrlRewriter urlRewriter, SSLSocketFactory sSLSocketFactory) {
        this.mUrlRewriter = urlRewriter;
        this.mSslSocketFactory = sSLSocketFactory;
    }

    private static void addBodyIfExists(HttpURLConnection object, Request<?> request) {
        byte[] byArray = request.getBody();
        if (byArray != null) {
            ((URLConnection)object).setDoOutput(true);
            ((URLConnection)object).addRequestProperty(HEADER_CONTENT_TYPE, request.getBodyContentType());
            object = new DataOutputStream(((URLConnection)object).getOutputStream());
            ((FilterOutputStream)object).write(byArray);
            ((FilterOutputStream)object).close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HttpURLConnection openConnection(URL uRL, Request<?> request) {
        HttpURLConnection httpURLConnection;
        block4: {
            block3: {
                httpURLConnection = this.createConnection(uRL);
                int n2 = request.getTimeoutMs();
                httpURLConnection.setConnectTimeout(n2);
                httpURLConnection.setReadTimeout(n2);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setDoInput(true);
                if (!"https".equals(uRL.getProtocol())) break block3;
                if (this.mSslSocketFactory == null) break block4;
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.mSslSocketFactory);
            }
            return httpURLConnection;
        }
        HTTPSTrustManager.allowAllSSL();
        return httpURLConnection;
    }

    private URLHttpResponse responseFromConnection(HttpURLConnection entry2) {
        int n2;
        Object object;
        URLHttpResponse uRLHttpResponse = new URLHttpResponse();
        try {
            object = ((URLConnection)((Object)entry2)).getInputStream();
        }
        catch (IOException iOException) {
            object = ((HttpURLConnection)((Object)entry2)).getErrorStream();
        }
        while ((n2 = ((HttpURLConnection)((Object)entry2)).getResponseCode()) == -1) {
            throw new IOException("Could not retrieve response code from HttpUrlConnection.");
        }
        uRLHttpResponse.setResponseCode(n2);
        uRLHttpResponse.setResponseMessage(((HttpURLConnection)((Object)entry2)).getResponseMessage());
        uRLHttpResponse.setContentStream((InputStream)object);
        uRLHttpResponse.setContentLength(((URLConnection)((Object)entry2)).getContentLength());
        uRLHttpResponse.setContentEncoding(((URLConnection)((Object)entry2)).getContentEncoding());
        uRLHttpResponse.setContentType(((URLConnection)((Object)entry2)).getContentType());
        object = new HashMap();
        for (Map.Entry<String, List<String>> entry2 : ((URLConnection)((Object)entry2)).getHeaderFields().entrySet()) {
            if (entry2.getKey() == null) continue;
            ((HashMap)object).put(entry2.getKey(), ((List)entry2.getValue()).get(0));
        }
        uRLHttpResponse.setHeaders((HashMap<String, String>)object);
        return uRLHttpResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void setConnectionParametersForRequest(HttpURLConnection object, Request<?> request) {
        switch (request.getMethod()) {
            default: {
                throw new IllegalStateException("Unknown method type.");
            }
            case -1: {
                byte[] byArray = request.getPostBody();
                if (byArray != null) {
                    ((URLConnection)object).setDoOutput(true);
                    ((HttpURLConnection)object).setRequestMethod("POST");
                    ((URLConnection)object).addRequestProperty(HEADER_CONTENT_TYPE, request.getPostBodyContentType());
                    object = new DataOutputStream(((URLConnection)object).getOutputStream());
                    ((FilterOutputStream)object).write(byArray);
                    ((FilterOutputStream)object).close();
                }
                return;
            }
            case 0: {
                ((HttpURLConnection)object).setRequestMethod("GET");
                return;
            }
            case 3: {
                ((HttpURLConnection)object).setRequestMethod("DELETE");
                return;
            }
            case 1: {
                ((HttpURLConnection)object).setRequestMethod("POST");
                HurlStack.addBodyIfExists((HttpURLConnection)object, request);
                return;
            }
            case 2: {
                ((HttpURLConnection)object).setRequestMethod("PUT");
                HurlStack.addBodyIfExists((HttpURLConnection)object, request);
                return;
            }
            case 4: {
                ((HttpURLConnection)object).setRequestMethod("HEAD");
                return;
            }
            case 5: {
                ((HttpURLConnection)object).setRequestMethod("OPTIONS");
                return;
            }
            case 6: {
                ((HttpURLConnection)object).setRequestMethod("TRACE");
                return;
            }
            case 7: 
        }
        ((HttpURLConnection)object).setRequestMethod("PATCH");
        HurlStack.addBodyIfExists((HttpURLConnection)object, request);
    }

    protected HttpURLConnection createConnection(URL uRL) {
        return (HttpURLConnection)uRL.openConnection();
    }

    @Override
    public URLHttpResponse performRequest(Request<?> request, Map<String, String> object) {
        String string22 = request.getUrl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(request.getHeaders());
        hashMap.putAll((Map<String, String>)object);
        if (this.mUrlRewriter != null) {
            Object object2;
            object = object2 = this.mUrlRewriter.rewriteUrl(string22);
            if (object2 == null) {
                throw new IOException("URL blocked by rewriter: " + string22);
            }
        } else {
            object = string22;
        }
        object = this.openConnection(new URL((String)object), request);
        for (String string22 : hashMap.keySet()) {
            ((URLConnection)object).addRequestProperty(string22, (String)hashMap.get(string22));
        }
        HurlStack.setConnectionParametersForRequest((HttpURLConnection)object, request);
        return this.responseFromConnection((HttpURLConnection)object);
    }

    public static interface UrlRewriter {
        public String rewriteUrl(String var1);
    }
}

