/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.msg.data;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import com.common.gmacs.R;
import com.common.gmacs.msg.GifManager;
import com.common.gmacs.msg.IMMessage;
import com.common.gmacs.parse.gif.IGifParser;
import com.common.gmacs.utils.GmacsEnvi;
import org.json.JSONException;
import org.json.JSONObject;

public class IMGifMsg
extends IMMessage {
    public String extra;
    public String gifId;
    private SpannableStringBuilder style;

    public IMGifMsg() {
        super("gif");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPlainText() {
        IGifParser iGifParser = GifManager.getInstance().getGifParser();
        if (iGifParser == null) return null;
        return iGifParser.getGifNameById(this.gifId);
    }

    public SpannableStringBuilder getPlainTextSpannableStringBuilder(Context context) {
        if (this.style == null) {
            this.style = new SpannableStringBuilder((CharSequence)this.getPlainText());
            context = new ForegroundColorSpan(GmacsEnvi.appContext.getResources().getColor(R.color.gray_808080));
            this.style.setSpan((Object)context, 0, this.style.length(), 34);
        }
        return this.style;
    }

    public boolean isShowSenderName() {
        return true;
    }

    public void parse(JSONObject jSONObject) {
        this.gifId = jSONObject.optString("local_id");
        this.extra = jSONObject.optString("extra");
        if (this.style == null) {
            this.style = new SpannableStringBuilder((CharSequence)this.getPlainText());
            jSONObject = new ForegroundColorSpan(GmacsEnvi.appContext.getResources().getColor(R.color.gray_808080));
            this.style.setSpan((Object)jSONObject, 0, this.style.length(), 34);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putInfoToJson(JSONObject jSONObject) {
        try {
            jSONObject.put("local_id", (Object)this.gifId);
            jSONObject.put("extra", (Object)this.extra);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }
}

