/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.provider;

import android.content.Context;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import com.common.gmacs.utils.GLog;

public class UserInfoDB
extends SQLiteOpenHelper {
    public static final String COLUMN_LEVEL = "level";
    public static final String COLUMN_NICK_NAME = "nick_name";
    public static final String COLUMN_REMARK = "remark";
    public static final String COLUMN_USER_AVATAR = "avatar";
    public static final String COLUMN_USER_GENDER = "gender";
    public static final String COLUMN_USER_ID = "user_id";
    public static final String COLUMN_USER_NAME = "user_name";
    public static final String COLUMN_USER_SOURCE = "user_source";
    public static final String COLUMN_USER_TYPE = "user_type";
    public static final Uri CONTENT_URI = Uri.parse((String)"content://com.common.gmacs/user_info");
    public static String DB_NAME = "gmacs_info.db";
    public static final String DB_TABLE = "user_info";
    private static final int DB_VERSION = 2;
    public static final String _ID = "_id";
    private final String TAG = UserInfoDB.class.getSimpleName();

    public UserInfoDB(Context context) {
        super(context, DB_NAME, null, 2);
        GLog.d((String)this.TAG, (String)DB_NAME);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createDownloadsTable(SQLiteDatabase sQLiteDatabase) {
        try {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS user_info");
            sQLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS user_info( _id INTEGER PRIMARY KEY,user_id TEXT,user_source INTEGER DEFAULT -1,user_name TEXT,avatar TEXT,user_type INTEGER DEFAULT -1,gender INTEGER DEFAULT 0,nick_name TEXT,level INTEGER DEFAULT 0,remark TEXT);");
            return;
        }
        catch (SQLException sQLException) {
            GLog.e((String)"couldn't create table in gmacs_info database", (Throwable)sQLException);
            return;
        }
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        this.createDownloadsTable(sQLiteDatabase);
    }

    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
        this.createDownloadsTable(sQLiteDatabase);
    }
}

