/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.Utf8;
import java.nio.ByteBuffer;

public final class IsoTypeWriter {
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !IsoTypeWriter.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
    }

    public static void writeFixedPoint0230(ByteBuffer byteBuffer, double d2) {
        int n2 = (int)(1.073741824E9 * d2);
        byteBuffer.put((byte)((0xFF000000 & n2) >> 24));
        byteBuffer.put((byte)((0xFF0000 & n2) >> 16));
        byteBuffer.put((byte)((0xFF00 & n2) >> 8));
        byteBuffer.put((byte)(n2 & 0xFF));
    }

    public static void writeFixedPoint1616(ByteBuffer byteBuffer, double d2) {
        int n2 = (int)(65536.0 * d2);
        byteBuffer.put((byte)((0xFF000000 & n2) >> 24));
        byteBuffer.put((byte)((0xFF0000 & n2) >> 16));
        byteBuffer.put((byte)((0xFF00 & n2) >> 8));
        byteBuffer.put((byte)(n2 & 0xFF));
    }

    public static void writeFixedPoint88(ByteBuffer byteBuffer, double d2) {
        short s2 = (short)(256.0 * d2);
        byteBuffer.put((byte)((0xFF00 & s2) >> 8));
        byteBuffer.put((byte)(s2 & 0xFF));
    }

    public static void writeIso639(ByteBuffer byteBuffer, String string2) {
        int n2 = 0;
        if (string2.getBytes().length != 3) {
            throw new IllegalArgumentException("\"" + string2 + "\" language string isn't exactly 3 characters long!");
        }
        int n3 = 0;
        while (true) {
            if (n2 >= 3) {
                IsoTypeWriter.writeUInt16(byteBuffer, n3);
                return;
            }
            n3 += string2.getBytes()[n2] - 96 << (2 - n2) * 5;
            ++n2;
        }
    }

    public static void writePascalUtfString(ByteBuffer byteBuffer, String object) {
        object = Utf8.convert((String)object);
        if (!$assertionsDisabled && ((Object)object).length >= 255) {
            throw new AssertionError();
        }
        IsoTypeWriter.writeUInt8(byteBuffer, ((Object)object).length);
        byteBuffer.put((byte[])object);
    }

    public static void writeUInt16(ByteBuffer byteBuffer, int n2) {
        n2 = 0xFFFF & n2;
        IsoTypeWriter.writeUInt8(byteBuffer, n2 >> 8);
        IsoTypeWriter.writeUInt8(byteBuffer, n2 & 0xFF);
    }

    public static void writeUInt16BE(ByteBuffer byteBuffer, int n2) {
        n2 = 0xFFFF & n2;
        IsoTypeWriter.writeUInt8(byteBuffer, n2 & 0xFF);
        IsoTypeWriter.writeUInt8(byteBuffer, n2 >> 8);
    }

    public static void writeUInt24(ByteBuffer byteBuffer, int n2) {
        n2 = 0xFFFFFF & n2;
        IsoTypeWriter.writeUInt16(byteBuffer, n2 >> 8);
        IsoTypeWriter.writeUInt8(byteBuffer, n2);
    }

    public static void writeUInt32(ByteBuffer byteBuffer, long l2) {
        byteBuffer.putInt((int)l2);
    }

    public static void writeUInt32BE(ByteBuffer byteBuffer, long l2) {
        if (!($assertionsDisabled || l2 >= 0L && l2 <= 0x100000000L)) {
            throw new AssertionError((Object)("The given long is not in the range of uint32 (" + l2 + ")"));
        }
        IsoTypeWriter.writeUInt16BE(byteBuffer, (int)l2 & 0xFFFF);
        IsoTypeWriter.writeUInt16BE(byteBuffer, (int)(l2 >> 16 & 0xFFFFL));
    }

    public static void writeUInt64(ByteBuffer byteBuffer, long l2) {
        byteBuffer.putLong(l2);
    }

    public static void writeUInt8(ByteBuffer byteBuffer, int n2) {
        byteBuffer.put((byte)(n2 & 0xFF));
    }

    public static void writeUtf8String(ByteBuffer byteBuffer, String string2) {
        byteBuffer.put(Utf8.convert(string2));
        IsoTypeWriter.writeUInt8(byteBuffer, 0);
    }

    public static void writeZeroTermUtf8String(ByteBuffer byteBuffer, String string2) {
        byteBuffer.put(Utf8.convert(string2));
        IsoTypeWriter.writeUInt8(byteBuffer, 0);
    }
}

