/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class SubtitleSampleEntry
extends AbstractSampleEntry {
    public static final String TYPE1 = "stpp";
    private String imageMimeType = "";
    private String namespace = "";
    private String schemaLocation = "";

    public SubtitleSampleEntry() {
        super(TYPE1);
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.namespace.length() + 8 + this.schemaLocation.length() + this.imageMimeType.length() + 3);
        byteBuffer.position(6);
        IsoTypeWriter.writeUInt16(byteBuffer, this.dataReferenceIndex);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.namespace);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.schemaLocation);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.imageMimeType);
        writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
        this.writeContainer(writableByteChannel);
    }

    public String getImageMimeType() {
        return this.imageMimeType;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getSize() {
        int n2;
        long l2 = this.getContainerSize();
        long l3 = this.namespace.length() + 8 + this.schemaLocation.length() + this.imageMimeType.length() + 3;
        if (this.largeBox || l2 + l3 + 8L >= 0x100000000L) {
            n2 = 16;
            return (long)n2 + (l2 + l3);
        }
        n2 = 8;
        return (long)n2 + (l2 + l3);
    }

    @Override
    public void parse(DataSource dataSource, ByteBuffer byteBuffer, long l2, BoxParser boxParser) throws IOException {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(8);
        dataSource.read((ByteBuffer)byteBuffer2.rewind());
        byteBuffer2.position(6);
        this.dataReferenceIndex = IsoTypeReader.readUInt16(byteBuffer2);
        long l3 = dataSource.position();
        byteBuffer2 = ByteBuffer.allocate(1024);
        dataSource.read((ByteBuffer)byteBuffer2.rewind());
        this.namespace = IsoTypeReader.readString((ByteBuffer)byteBuffer2.rewind());
        dataSource.position((long)this.namespace.length() + l3 + 1L);
        dataSource.read((ByteBuffer)byteBuffer2.rewind());
        this.schemaLocation = IsoTypeReader.readString((ByteBuffer)byteBuffer2.rewind());
        dataSource.position((long)this.namespace.length() + l3 + (long)this.schemaLocation.length() + 2L);
        dataSource.read((ByteBuffer)byteBuffer2.rewind());
        this.imageMimeType = IsoTypeReader.readString((ByteBuffer)byteBuffer2.rewind());
        dataSource.position((long)this.namespace.length() + l3 + (long)this.schemaLocation.length() + (long)this.imageMimeType.length() + 3L);
        this.parseContainer(dataSource, l2 - (long)(byteBuffer.remaining() + this.namespace.length() + this.schemaLocation.length() + this.imageMimeType.length() + 3), boxParser);
    }

    public void setImageMimeType(String string2) {
        this.imageMimeType = string2;
    }

    public void setNamespace(String string2) {
        this.namespace = string2;
    }

    public void setSchemaLocation(String string2) {
        this.schemaLocation = string2;
    }
}

