/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;

public class TextSampleEntry
extends AbstractSampleEntry {
    public static final String TYPE1 = "tx3g";
    public static final String TYPE_ENCRYPTED = "enct";
    private int[] backgroundColorRgba = new int[4];
    private BoxRecord boxRecord = new BoxRecord();
    private long displayFlags;
    private int horizontalJustification;
    private StyleRecord styleRecord = new StyleRecord();
    private int verticalJustification;

    public TextSampleEntry() {
        super(TYPE1);
    }

    public TextSampleEntry(String string2) {
        super(string2);
    }

    public int[] getBackgroundColorRgba() {
        return this.backgroundColorRgba;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        ByteBuffer byteBuffer = ByteBuffer.allocate(38);
        byteBuffer.position(6);
        IsoTypeWriter.writeUInt16(byteBuffer, this.dataReferenceIndex);
        IsoTypeWriter.writeUInt32(byteBuffer, this.displayFlags);
        IsoTypeWriter.writeUInt8(byteBuffer, this.horizontalJustification);
        IsoTypeWriter.writeUInt8(byteBuffer, this.verticalJustification);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[0]);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[1]);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[2]);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[3]);
        this.boxRecord.getContent(byteBuffer);
        this.styleRecord.getContent(byteBuffer);
        writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
        this.writeContainer(writableByteChannel);
    }

    public BoxRecord getBoxRecord() {
        return this.boxRecord;
    }

    public int getHorizontalJustification() {
        return this.horizontalJustification;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getSize() {
        int n2;
        long l2 = this.getContainerSize();
        if (this.largeBox || l2 + 38L >= 0x100000000L) {
            n2 = 16;
            return (long)n2 + (l2 + 38L);
        }
        n2 = 8;
        return (long)n2 + (l2 + 38L);
    }

    public StyleRecord getStyleRecord() {
        return this.styleRecord;
    }

    public int getVerticalJustification() {
        return this.verticalJustification;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isContinuousKaraoke() {
        if ((this.displayFlags & 0x800L) != 2048L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFillTextRegion() {
        if ((this.displayFlags & 0x40000L) != 262144L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isScrollDirection() {
        if ((this.displayFlags & 0x180L) != 384L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isScrollIn() {
        if ((this.displayFlags & 0x20L) != 32L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isScrollOut() {
        if ((this.displayFlags & 0x40L) != 64L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWriteTextVertically() {
        if ((this.displayFlags & 0x20000L) != 131072L) return false;
        return true;
    }

    @Override
    public void parse(DataSource dataSource, ByteBuffer byteBuffer, long l2, BoxParser boxParser) throws IOException {
        byteBuffer = ByteBuffer.allocate(38);
        dataSource.read(byteBuffer);
        byteBuffer.position(6);
        this.dataReferenceIndex = IsoTypeReader.readUInt16(byteBuffer);
        this.displayFlags = IsoTypeReader.readUInt32(byteBuffer);
        this.horizontalJustification = IsoTypeReader.readUInt8(byteBuffer);
        this.verticalJustification = IsoTypeReader.readUInt8(byteBuffer);
        this.backgroundColorRgba = new int[4];
        this.backgroundColorRgba[0] = IsoTypeReader.readUInt8(byteBuffer);
        this.backgroundColorRgba[1] = IsoTypeReader.readUInt8(byteBuffer);
        this.backgroundColorRgba[2] = IsoTypeReader.readUInt8(byteBuffer);
        this.backgroundColorRgba[3] = IsoTypeReader.readUInt8(byteBuffer);
        this.boxRecord = new BoxRecord();
        this.boxRecord.parse(byteBuffer);
        this.styleRecord = new StyleRecord();
        this.styleRecord.parse(byteBuffer);
        this.parseContainer(dataSource, l2 - 38L, boxParser);
    }

    public void setBackgroundColorRgba(int[] nArray) {
        this.backgroundColorRgba = nArray;
    }

    public void setBoxRecord(BoxRecord boxRecord) {
        this.boxRecord = boxRecord;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContinuousKaraoke(boolean bl) {
        if (bl) {
            this.displayFlags |= 0x800L;
            return;
        }
        this.displayFlags &= 0xFFFFFFFFFFFFF7FFL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFillTextRegion(boolean bl) {
        if (bl) {
            this.displayFlags |= 0x40000L;
            return;
        }
        this.displayFlags &= 0xFFFFFFFFFFFBFFFFL;
    }

    public void setHorizontalJustification(int n2) {
        this.horizontalJustification = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setScrollDirection(boolean bl) {
        if (bl) {
            this.displayFlags |= 0x180L;
            return;
        }
        this.displayFlags &= 0xFFFFFFFFFFFFFE7FL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setScrollIn(boolean bl) {
        if (bl) {
            this.displayFlags |= 0x20L;
            return;
        }
        this.displayFlags &= 0xFFFFFFFFFFFFFFDFL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setScrollOut(boolean bl) {
        if (bl) {
            this.displayFlags |= 0x40L;
            return;
        }
        this.displayFlags &= 0xFFFFFFFFFFFFFFBFL;
    }

    public void setStyleRecord(StyleRecord styleRecord) {
        this.styleRecord = styleRecord;
    }

    public void setVerticalJustification(int n2) {
        this.verticalJustification = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setWriteTextVertically(boolean bl) {
        if (bl) {
            this.displayFlags |= 0x20000L;
            return;
        }
        this.displayFlags &= 0xFFFFFFFFFFFDFFFFL;
    }

    @Override
    public String toString() {
        return "TextSampleEntry";
    }

    public static class BoxRecord {
        int bottom;
        int left;
        int right;
        int top;

        public BoxRecord() {
        }

        public BoxRecord(int n2, int n3, int n4, int n5) {
            this.top = n2;
            this.left = n3;
            this.bottom = n4;
            this.right = n5;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return bl;
            }
            if (object == null) return false;
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (BoxRecord)object;
            if (this.bottom != ((BoxRecord)object).bottom) {
                return false;
            }
            if (this.left != ((BoxRecord)object).left) {
                return false;
            }
            if (this.right != ((BoxRecord)object).right) {
                return false;
            }
            if (this.top == ((BoxRecord)object).top) return bl;
            return false;
        }

        public void getContent(ByteBuffer byteBuffer) {
            IsoTypeWriter.writeUInt16(byteBuffer, this.top);
            IsoTypeWriter.writeUInt16(byteBuffer, this.left);
            IsoTypeWriter.writeUInt16(byteBuffer, this.bottom);
            IsoTypeWriter.writeUInt16(byteBuffer, this.right);
        }

        public int getSize() {
            return 8;
        }

        public int hashCode() {
            return ((this.top * 31 + this.left) * 31 + this.bottom) * 31 + this.right;
        }

        public void parse(ByteBuffer byteBuffer) {
            this.top = IsoTypeReader.readUInt16(byteBuffer);
            this.left = IsoTypeReader.readUInt16(byteBuffer);
            this.bottom = IsoTypeReader.readUInt16(byteBuffer);
            this.right = IsoTypeReader.readUInt16(byteBuffer);
        }
    }

    public static class StyleRecord {
        int endChar;
        int faceStyleFlags;
        int fontId;
        int fontSize;
        int startChar;
        int[] textColor = new int[]{255, 255, 255, 255};

        public StyleRecord() {
        }

        public StyleRecord(int n2, int n3, int n4, int n5, int n6, int[] nArray) {
            this.startChar = n2;
            this.endChar = n3;
            this.fontId = n4;
            this.faceStyleFlags = n5;
            this.fontSize = n6;
            this.textColor = nArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return bl;
            }
            if (object == null) return false;
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (StyleRecord)object;
            if (this.endChar != ((StyleRecord)object).endChar) {
                return false;
            }
            if (this.faceStyleFlags != ((StyleRecord)object).faceStyleFlags) {
                return false;
            }
            if (this.fontId != ((StyleRecord)object).fontId) {
                return false;
            }
            if (this.fontSize != ((StyleRecord)object).fontSize) {
                return false;
            }
            if (this.startChar != ((StyleRecord)object).startChar) {
                return false;
            }
            if (Arrays.equals(this.textColor, ((StyleRecord)object).textColor)) return bl;
            return false;
        }

        public void getContent(ByteBuffer byteBuffer) {
            IsoTypeWriter.writeUInt16(byteBuffer, this.startChar);
            IsoTypeWriter.writeUInt16(byteBuffer, this.endChar);
            IsoTypeWriter.writeUInt16(byteBuffer, this.fontId);
            IsoTypeWriter.writeUInt8(byteBuffer, this.faceStyleFlags);
            IsoTypeWriter.writeUInt8(byteBuffer, this.fontSize);
            IsoTypeWriter.writeUInt8(byteBuffer, this.textColor[0]);
            IsoTypeWriter.writeUInt8(byteBuffer, this.textColor[1]);
            IsoTypeWriter.writeUInt8(byteBuffer, this.textColor[2]);
            IsoTypeWriter.writeUInt8(byteBuffer, this.textColor[3]);
        }

        public int getSize() {
            return 12;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int hashCode() {
            int n2;
            int n3 = this.startChar;
            int n4 = this.endChar;
            int n5 = this.fontId;
            int n6 = this.faceStyleFlags;
            int n7 = this.fontSize;
            if (this.textColor != null) {
                n2 = Arrays.hashCode(this.textColor);
                return n2 + ((((n3 * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31;
            }
            n2 = 0;
            return n2 + ((((n3 * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31;
        }

        public void parse(ByteBuffer byteBuffer) {
            this.startChar = IsoTypeReader.readUInt16(byteBuffer);
            this.endChar = IsoTypeReader.readUInt16(byteBuffer);
            this.fontId = IsoTypeReader.readUInt16(byteBuffer);
            this.faceStyleFlags = IsoTypeReader.readUInt8(byteBuffer);
            this.fontSize = IsoTypeReader.readUInt8(byteBuffer);
            this.textColor = new int[4];
            this.textColor[0] = IsoTypeReader.readUInt8(byteBuffer);
            this.textColor[1] = IsoTypeReader.readUInt8(byteBuffer);
            this.textColor[2] = IsoTypeReader.readUInt8(byteBuffer);
            this.textColor[3] = IsoTypeReader.readUInt8(byteBuffer);
        }
    }
}

