/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.gui;

import com.coremedia.iso.boxes.h264.AvcConfigurationBox;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.coremedia.iso.gui.IsoSampleNALUnitReader;
import com.coremedia.iso.gui.SampleListModel;
import com.googlecode.mp4parser.BasicContainer;
import java.awt.Component;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class SampleListRenderer
extends DefaultListCellRenderer {
    private boolean bruteforceAvc = true;
    private long failedTrackId;

    private ArrayList<NalWrapper> getNals(SampleListModel.Entry object, int n2) throws IOException {
        object = new IsoSampleNALUnitReader(((SampleListModel.Entry)object).sample, n2);
        ArrayList<NalWrapper> arrayList = new ArrayList<NalWrapper>();
        ByteBuffer byteBuffer;
        while ((byteBuffer = ((IsoSampleNALUnitReader)object).nextNALUnit()) != null) {
            arrayList.add(new NalWrapper(byteBuffer));
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
        Object object2 = (SampleListModel.Entry)object;
        String string2 = "Sample " + (n2 + 1) + "@" + object2 + " - " + ((SampleListModel.Entry)object2).sample.remaining() + "bytes";
        Object object3 = ((SampleListModel.Entry)object2).se;
        if (object3 != null && object3 instanceof VisualSampleEntry && !((BasicContainer)object3).getBoxes(AvcConfigurationBox.class).isEmpty()) {
            try {
                object = this.getNals((SampleListModel.Entry)object2, ((BasicContainer)object3).getBoxes(AvcConfigurationBox.class).get(0).getLengthSizeMinusOne() + 1);
                object2 = new StringBuilder();
                object = ((StringBuilder)object2).append((Object)string2).append(" ").append(object).toString();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                object = string2;
            }
        } else if (((SampleListModel.Entry)object2).avcD != null) {
            try {
                object = this.getNals((SampleListModel.Entry)object2, ((SampleListModel.Entry)object2).avcD.lengthSizeMinusOne + 1);
                object2 = new StringBuilder();
                object = ((StringBuilder)object2).append((Object)string2).append(" ").append(object).toString();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                object = string2;
            }
        } else {
            object = string2;
            if (this.bruteforceAvc) {
                object = string2;
                if (object3 == null) {
                    object = string2;
                    if (((SampleListModel.Entry)object2).trackId != this.failedTrackId) {
                        try {
                            System.out.println("No AVC SampleEntry found, trying to parse sample as AVC with default NAL length of 4bytes.");
                            object3 = this.getNals((SampleListModel.Entry)object2, 4);
                            object = new StringBuilder();
                            object = ((StringBuilder)object).append((Object)string2).append(" ").append(object3).toString();
                        }
                        catch (Exception exception) {
                            this.failedTrackId = ((SampleListModel.Entry)object2).trackId;
                            System.err.println("Didn't work. Won't try again with trackId " + this.failedTrackId);
                            object = string2;
                        }
                    }
                }
            }
        }
        super.getListCellRendererComponent((JList<?>)jList, object, n2, bl, bl2);
        return this;
    }

    public class NalWrapper {
        ByteBuffer data;
        private int nal_ref_idc;
        private int nal_unit_type;

        public NalWrapper(ByteBuffer byteBuffer) {
            this.data = byteBuffer;
            byte by = byteBuffer.get();
            this.nal_ref_idc = by >> 5 & 3;
            this.nal_unit_type = by & 0x1F;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            switch (this.nal_unit_type) {
                case 1: {
                    stringBuilder.append("NonIDR");
                    break;
                }
                case 2: {
                    stringBuilder.append("Part.A");
                    break;
                }
                case 3: {
                    stringBuilder.append("Part.B");
                    break;
                }
                case 4: {
                    stringBuilder.append("Part.C");
                    break;
                }
                case 5: {
                    stringBuilder.append("IDR");
                    break;
                }
                case 6: {
                    stringBuilder.append("SEI");
                    break;
                }
                case 7: {
                    stringBuilder.append("SPS");
                    break;
                }
                case 8: {
                    stringBuilder.append("PPS");
                    break;
                }
                case 9: {
                    stringBuilder.append("AUD");
                    break;
                }
                case 10: {
                    stringBuilder.append("EndOfSeq");
                    break;
                }
                case 11: {
                    stringBuilder.append("EndOfStr");
                    break;
                }
            }
            stringBuilder.append("{").append("type:").append(this.nal_unit_type).append(",idc:").append(this.nal_ref_idc).append(",size:").append(this.data.limit());
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }
}

