/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.$Gson$Preconditions;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public final class $Gson$Types {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private $Gson$Types() {
    }

    public static GenericArrayType arrayOf(Type type) {
        return new GenericArrayTypeImpl(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type canonicalize(Type type) {
        Type type2;
        if (type instanceof Class) {
            type2 = type = (Class)type;
            if (!((Class)type).isArray()) return type2;
            return new GenericArrayTypeImpl($Gson$Types.canonicalize(((Class)type).getComponentType()));
        }
        if (type instanceof ParameterizedType) {
            type = (ParameterizedType)type;
            return new ParameterizedTypeImpl(type.getOwnerType(), type.getRawType(), type.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            return new GenericArrayTypeImpl(((GenericArrayType)type).getGenericComponentType());
        }
        type2 = type;
        if (!(type instanceof WildcardType)) return type2;
        type = (WildcardType)type;
        return new WildcardTypeImpl(type.getUpperBounds(), type.getLowerBounds());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void checkNotPrimitive(Type type) {
        boolean bl = !(type instanceof Class) || !((Class)type).isPrimitive();
        $Gson$Preconditions.checkArgument(bl);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Class<?> declaringClassOf(TypeVariable<?> type) {
        void var0_3;
        Object d2 = type.getGenericDeclaration();
        if (!(d2 instanceof Class)) return var0_3;
        Class clazz = (Class)d2;
        return var0_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean equal(Object object, Object object2) {
        if (object == object2) return true;
        if (object == null) return false;
        if (!object.equals(object2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(Type type, Type type2) {
        boolean bl;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = false;
        if (type == type2) {
            return true;
        }
        if (type instanceof Class) {
            return type.equals(type2);
        }
        if (type instanceof ParameterizedType) {
            bl = bl5;
            if (!(type2 instanceof ParameterizedType)) return bl;
            type = (ParameterizedType)type;
            type2 = (ParameterizedType)type2;
            if (!$Gson$Types.equal(type.getOwnerType(), type2.getOwnerType())) return false;
            if (!type.getRawType().equals(type2.getRawType())) return false;
            if (!Arrays.equals(type.getActualTypeArguments(), type2.getActualTypeArguments())) return false;
            return bl4;
        }
        if (type instanceof GenericArrayType) {
            bl = bl5;
            if (!(type2 instanceof GenericArrayType)) return bl;
            type = (GenericArrayType)type;
            type2 = (GenericArrayType)type2;
            return $Gson$Types.equals(type.getGenericComponentType(), type2.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            bl = bl5;
            if (!(type2 instanceof WildcardType)) return bl;
            type = (WildcardType)type;
            type2 = (WildcardType)type2;
            if (!Arrays.equals(type.getUpperBounds(), type2.getUpperBounds())) return false;
            if (!Arrays.equals(type.getLowerBounds(), type2.getLowerBounds())) return false;
            return bl2;
        }
        bl = bl5;
        if (!(type instanceof TypeVariable)) return bl;
        bl = bl5;
        if (!(type2 instanceof TypeVariable)) return bl;
        type = (TypeVariable)type;
        type2 = (TypeVariable)type2;
        if (type.getGenericDeclaration() != type2.getGenericDeclaration()) return false;
        if (!type.getName().equals(type2.getName())) return false;
        return bl3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type getArrayComponentType(Type type) {
        if (!(type instanceof GenericArrayType)) return ((Class)type).getComponentType();
        return ((GenericArrayType)type).getGenericComponentType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type getCollectionElementType(Type object, Class<?> type) {
        Type type2 = $Gson$Types.getSupertype((Type)object, type, Collection.class);
        object = type2;
        if (type2 instanceof WildcardType) {
            object = ((WildcardType)type2).getUpperBounds()[0];
        }
        if (!(object instanceof ParameterizedType)) return Object.class;
        return ((ParameterizedType)object).getActualTypeArguments()[0];
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Type getGenericSupertype(Type object, Class<?> object2, Class<?> clazz) {
        void var0_1;
        Class clazz2;
        void var2_12;
        if (var2_12 == clazz2) {
            return var0_1;
        }
        if (var2_12.isInterface()) {
            Class<?>[] classArray = clazz2.getInterfaces();
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (classArray[i2] == var2_12) {
                    Type type = clazz2.getGenericInterfaces()[i2];
                    return var0_1;
                }
                if (!var2_12.isAssignableFrom(classArray[i2])) continue;
                Type type = $Gson$Types.getGenericSupertype(clazz2.getGenericInterfaces()[i2], classArray[i2], var2_12);
                return var0_1;
            }
        }
        if (!clazz2.isInterface()) {
            while (clazz2 != Object.class) {
                Class clazz3 = clazz2.getSuperclass();
                if (clazz3 == var2_12) {
                    Type type = clazz2.getGenericSuperclass();
                    return var0_1;
                }
                if (var2_12.isAssignableFrom(clazz3)) {
                    Type type = $Gson$Types.getGenericSupertype(clazz2.getGenericSuperclass(), clazz3, var2_12);
                    return var0_1;
                }
                clazz2 = clazz3;
            }
        }
        void var0_10 = var2_12;
        return var0_1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type[] getMapKeyAndValueTypes(Type typeArray, Class<?> clazz) {
        if (typeArray == Properties.class) {
            typeArray = new Type[]{String.class, String.class};
            return typeArray;
        }
        if ((typeArray = $Gson$Types.getSupertype((Type)typeArray, clazz, Map.class)) instanceof ParameterizedType) {
            return ((ParameterizedType)typeArray).getActualTypeArguments();
        }
        typeArray = new Type[]{Object.class, Object.class};
        return typeArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?> getRawType(Type clazz) {
        String string2;
        if (clazz instanceof Class) {
            return clazz;
        }
        if (clazz instanceof ParameterizedType) {
            clazz = ((ParameterizedType)((Object)clazz)).getRawType();
            $Gson$Preconditions.checkArgument(clazz instanceof Class);
            return clazz;
        }
        if (clazz instanceof GenericArrayType) {
            return Array.newInstance($Gson$Types.getRawType(((GenericArrayType)((Object)clazz)).getGenericComponentType()), 0).getClass();
        }
        if (clazz instanceof TypeVariable) {
            return Object.class;
        }
        if (clazz instanceof WildcardType) {
            return $Gson$Types.getRawType(((WildcardType)((Object)clazz)).getUpperBounds()[0]);
        }
        if (clazz == null) {
            string2 = "null";
            throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + clazz + "> is of type " + string2);
        }
        string2 = clazz.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + clazz + "> is of type " + string2);
    }

    static Type getSupertype(Type type, Class<?> clazz, Class<?> clazz2) {
        $Gson$Preconditions.checkArgument(clazz2.isAssignableFrom(clazz));
        return $Gson$Types.resolve(type, clazz, $Gson$Types.getGenericSupertype(type, clazz, clazz2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int hashCodeOrZero(Object object) {
        if (object == null) return 0;
        return object.hashCode();
    }

    private static int indexOf(Object[] objectArray, Object object) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!object.equals(objectArray[i2])) continue;
            return i2;
        }
        throw new NoSuchElementException();
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type type, Type type2, Type ... typeArray) {
        return new ParameterizedTypeImpl(type, type2, typeArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Type resolve(Type type, Class<?> clazz, Type object) {
        void var2_5;
        Object object2 = object;
        while (object2 instanceof TypeVariable) {
            Type type2 = $Gson$Types.resolveTypeVariable(type, clazz, object2 = (TypeVariable)object2);
            if (type2 == object2) {
                return var2_5;
            }
            object2 = type2;
        }
        if (object2 instanceof Class && ((Class)object2).isArray()) {
            Class clazz2 = (Class)object2;
            if ((object2 = clazz2.getComponentType()) == (type = $Gson$Types.resolve(type, clazz, (Type)object2))) return var2_5;
            GenericArrayType genericArrayType = $Gson$Types.arrayOf(type);
            return var2_5;
        }
        if (object2 instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)object2;
            if ((object2 = genericArrayType.getGenericComponentType()) == (type = $Gson$Types.resolve(type, clazz, (Type)object2))) return var2_5;
            GenericArrayType genericArrayType2 = $Gson$Types.arrayOf(type);
            return var2_5;
        }
        if (object2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)object2;
            Type type3 = parameterizedType.getOwnerType();
            Type type4 = $Gson$Types.resolve(type, clazz, type3);
            boolean bl = type4 != type3;
            object2 = parameterizedType.getActualTypeArguments();
            int n2 = ((Object)object2).length;
            int n3 = 0;
            while (true) {
                void var2_16;
                if (n3 >= n2) {
                    ParameterizedType parameterizedType2 = parameterizedType;
                    if (!bl) return var2_5;
                    ParameterizedType parameterizedType3 = $Gson$Types.newParameterizedTypeWithOwner(type4, parameterizedType.getRawType(), (Type[])object2);
                    return var2_5;
                }
                Type type5 = $Gson$Types.resolve(type, clazz, (Type)object2[n3]);
                Object object3 = object2;
                boolean bl2 = bl;
                if (type5 != object2[n3]) {
                    Object object4 = object2;
                    bl2 = bl;
                    if (!bl) {
                        Type[] typeArray = (Type[])object2.clone();
                        bl2 = true;
                    }
                    var2_15[n3] = type5;
                }
                ++n3;
                object2 = var2_16;
                bl = bl2;
            }
        }
        Object object5 = object2;
        if (!(object2 instanceof WildcardType)) return var2_5;
        object2 = (WildcardType)object2;
        Type[] typeArray = object2.getLowerBounds();
        Type[] typeArray2 = object2.getUpperBounds();
        if (typeArray.length == 1) {
            type = $Gson$Types.resolve(type, clazz, typeArray[0]);
            Object object6 = object2;
            if (type == typeArray[0]) return var2_5;
            WildcardType wildcardType = $Gson$Types.supertypeOf(type);
            return var2_5;
        }
        Object object7 = object2;
        if (typeArray2.length != 1) return var2_5;
        type = $Gson$Types.resolve(type, clazz, typeArray2[0]);
        Object object8 = object2;
        if (type == typeArray2[0]) return var2_5;
        WildcardType wildcardType = $Gson$Types.subtypeOf(type);
        return var2_5;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static Type resolveTypeVariable(Type type, Class<?> type2, TypeVariable<?> typeVariable) {
        void var1_5;
        void var0_2;
        void var2_7;
        Class<?> clazz = $Gson$Types.declaringClassOf(var2_7);
        if (clazz == null) {
            void var0_1 = var2_7;
            return var0_2;
        }
        Type type3 = $Gson$Types.getGenericSupertype(type, var1_5, clazz);
        void var0_3 = var2_7;
        if (!(type3 instanceof ParameterizedType)) return var0_2;
        int n2 = $Gson$Types.indexOf(clazz.getTypeParameters(), var2_7);
        Type type4 = ((ParameterizedType)type3).getActualTypeArguments()[n2];
        return var0_2;
    }

    public static WildcardType subtypeOf(Type type) {
        Type[] typeArray = EMPTY_TYPE_ARRAY;
        return new WildcardTypeImpl(new Type[]{type}, typeArray);
    }

    public static WildcardType supertypeOf(Type type) {
        return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{type});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String typeToString(Type object) {
        if (!(object instanceof Class)) return object.toString();
        return ((Class)object).getName();
    }

    private static final class GenericArrayTypeImpl
    implements Serializable,
    GenericArrayType {
        private static final long serialVersionUID = 0L;
        private final Type componentType;

        public GenericArrayTypeImpl(Type type) {
            this.componentType = $Gson$Types.canonicalize(type);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof GenericArrayType)) return false;
            if (!$Gson$Types.equals(this, (GenericArrayType)object)) return false;
            return true;
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return $Gson$Types.typeToString(this.componentType) + "[]";
        }
    }

    private static final class ParameterizedTypeImpl
    implements Serializable,
    ParameterizedType {
        private static final long serialVersionUID = 0L;
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;

        /*
         * Enabled aggressive block sorting
         */
        public ParameterizedTypeImpl(Type type, Type type2, Type ... typeArray) {
            boolean bl = true;
            int n2 = 0;
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                boolean bl2 = type != null || clazz.getEnclosingClass() == null;
                $Gson$Preconditions.checkArgument(bl2);
                bl2 = bl;
                if (type != null) {
                    bl2 = clazz.getEnclosingClass() != null ? bl : false;
                }
                $Gson$Preconditions.checkArgument(bl2);
            }
            type = type == null ? null : $Gson$Types.canonicalize(type);
            this.ownerType = type;
            this.rawType = $Gson$Types.canonicalize(type2);
            this.typeArguments = (Type[])typeArray.clone();
            while (n2 < this.typeArguments.length) {
                $Gson$Preconditions.checkNotNull(this.typeArguments[n2]);
                $Gson$Types.checkNotPrimitive(this.typeArguments[n2]);
                this.typeArguments[n2] = $Gson$Types.canonicalize(this.typeArguments[n2]);
                ++n2;
            }
            return;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof ParameterizedType)) return false;
            if (!$Gson$Types.equals(this, (ParameterizedType)object)) return false;
            return true;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ $Gson$Types.hashCodeOrZero(this.ownerType);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            CharSequence charSequence = new StringBuilder((this.typeArguments.length + 1) * 30);
            ((StringBuilder)charSequence).append($Gson$Types.typeToString(this.rawType));
            if (this.typeArguments.length == 0) {
                return ((StringBuilder)charSequence).toString();
            }
            ((StringBuilder)charSequence).append("<").append($Gson$Types.typeToString(this.typeArguments[0]));
            int n2 = 1;
            while (n2 < this.typeArguments.length) {
                ((StringBuilder)charSequence).append(", ").append($Gson$Types.typeToString(this.typeArguments[n2]));
                ++n2;
            }
            return ((StringBuilder)charSequence).append(">").toString();
        }
    }

    private static final class WildcardTypeImpl
    implements Serializable,
    WildcardType {
        private static final long serialVersionUID = 0L;
        private final Type lowerBound;
        private final Type upperBound;

        /*
         * Enabled aggressive block sorting
         */
        public WildcardTypeImpl(Type[] typeArray, Type[] typeArray2) {
            boolean bl = true;
            boolean bl2 = typeArray2.length <= 1;
            $Gson$Preconditions.checkArgument(bl2);
            bl2 = typeArray.length == 1;
            $Gson$Preconditions.checkArgument(bl2);
            if (typeArray2.length != 1) {
                $Gson$Preconditions.checkNotNull(typeArray[0]);
                $Gson$Types.checkNotPrimitive(typeArray[0]);
                this.lowerBound = null;
                this.upperBound = $Gson$Types.canonicalize(typeArray[0]);
                return;
            }
            $Gson$Preconditions.checkNotNull(typeArray2[0]);
            $Gson$Types.checkNotPrimitive(typeArray2[0]);
            bl2 = typeArray[0] == Object.class ? bl : false;
            $Gson$Preconditions.checkArgument(bl2);
            this.lowerBound = $Gson$Types.canonicalize(typeArray2[0]);
            this.upperBound = Object.class;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof WildcardType)) return false;
            if (!$Gson$Types.equals(this, (WildcardType)object)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Type[] getLowerBounds() {
            if (this.lowerBound == null) return EMPTY_TYPE_ARRAY;
            Type[] typeArray = new Type[]{this.lowerBound};
            return typeArray;
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int hashCode() {
            int n2;
            if (this.lowerBound != null) {
                n2 = this.lowerBound.hashCode() + 31;
                return n2 ^ this.upperBound.hashCode() + 31;
            }
            n2 = 1;
            return n2 ^ this.upperBound.hashCode() + 31;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            if (this.lowerBound != null) {
                return "? super " + $Gson$Types.typeToString(this.lowerBound);
            }
            if (this.upperBound != Object.class) return "? extends " + $Gson$Types.typeToString(this.upperBound);
            return "?";
        }
    }
}

