/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.InstanceCreator;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.UnsafeAllocator;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ConstructorConstructor {
    private final Map<Type, InstanceCreator<?>> instanceCreators;

    public ConstructorConstructor() {
        this(Collections.emptyMap());
    }

    public ConstructorConstructor(Map<Type, InstanceCreator<?>> map) {
        this.instanceCreators = map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> ObjectConstructor<T> newDefaultConstructor(Class<? super T> objectConstructor) {
        try {
            final Constructor constructor = ((Class)((Object)objectConstructor)).getDeclaredConstructor(new Class[0]);
            if (constructor.isAccessible()) return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    Object t2;
                    try {
                        t2 = constructor.newInstance(null);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new RuntimeException("Failed to invoke " + constructor + " with no args", instantiationException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new RuntimeException("Failed to invoke " + constructor + " with no args", invocationTargetException.getTargetException());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                    return t2;
                }
            };
            constructor.setAccessible(true);
            return new /* invalid duplicate definition of identical inner class */;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> ObjectConstructor<T> newDefaultImplementationConstructor(Class<? super T> object) {
        if (Collection.class.isAssignableFrom((Class<?>)object)) {
            if (SortedSet.class.isAssignableFrom((Class<?>)object)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new TreeSet();
                    }
                };
            }
            if (Set.class.isAssignableFrom((Class<?>)object)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (!Queue.class.isAssignableFrom((Class<?>)object)) return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new ArrayList();
                }
            };
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new LinkedList();
                }
            };
        }
        if (!Map.class.isAssignableFrom((Class<?>)object)) return null;
        return new ObjectConstructor<T>(){

            @Override
            public T construct() {
                return new LinkedHashMap();
            }
        };
    }

    private <T> ObjectConstructor<T> newUnsafeAllocator(final Type type, final Class<? super T> clazz) {
        return new ObjectConstructor<T>(){
            private final UnsafeAllocator unsafeAllocator = UnsafeAllocator.create();

            @Override
            public T construct() {
                Object t2;
                try {
                    t2 = this.unsafeAllocator.newInstance(clazz);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to invoke no-args constructor for " + type + ". " + "Register an InstanceCreator with Gson for this type may fix this problem.", exception);
                }
                return t2;
            }
        };
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public <T> ObjectConstructor<T> get(TypeToken<T> object) {
        ObjectConstructor<T> objectConstructor;
        void var1_4;
        final Type type = object.getType();
        Class clazz = object.getRawType();
        final InstanceCreator<?> instanceCreator = this.instanceCreators.get(type);
        if (instanceCreator != null) {
            ObjectConstructor objectConstructor2 = new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return instanceCreator.createInstance(type);
                }
            };
            return var1_4;
        }
        ObjectConstructor<T> objectConstructor3 = objectConstructor = this.newDefaultConstructor(clazz);
        if (objectConstructor != null) return var1_4;
        ObjectConstructor<T> objectConstructor4 = objectConstructor = this.newDefaultImplementationConstructor(clazz);
        if (objectConstructor != null) return var1_4;
        ObjectConstructor<T> objectConstructor5 = this.newUnsafeAllocator(type, clazz);
        return var1_4;
    }

    public String toString() {
        return this.instanceCreators.toString();
    }
}

