/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.Since;
import com.google.gson.annotations.Until;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Excluder
implements TypeAdapterFactory,
Cloneable {
    public static final Excluder DEFAULT = new Excluder();
    private static final double IGNORE_VERSIONS = -1.0;
    private List<ExclusionStrategy> deserializationStrategies;
    private int modifiers = 136;
    private boolean requireExpose;
    private List<ExclusionStrategy> serializationStrategies = Collections.emptyList();
    private boolean serializeInnerClasses = true;
    private double version = -1.0;

    public Excluder() {
        this.deserializationStrategies = Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAnonymousOrLocal(Class<?> clazz) {
        if (Enum.class.isAssignableFrom(clazz)) return false;
        if (clazz.isAnonymousClass()) return true;
        if (!clazz.isLocalClass()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInnerClass(Class<?> clazz) {
        if (!clazz.isMemberClass()) return false;
        if (this.isStatic(clazz)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStatic(Class<?> clazz) {
        if ((clazz.getModifiers() & 8) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidSince(Since since) {
        if (since == null) return true;
        if (!(since.value() > this.version)) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidUntil(Until until) {
        if (until == null) return true;
        if (!(until.value() <= this.version)) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidVersion(Since since, Until until) {
        if (!this.isValidSince(since)) return false;
        if (!this.isValidUntil(until)) return false;
        return true;
    }

    protected Excluder clone() {
        try {
            Excluder excluder = (Excluder)super.clone();
            return excluder;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
        void var1_3;
        void var2_5;
        Class clazz = var2_5.getRawType();
        final boolean bl = this.excludeClass(clazz, true);
        final boolean bl2 = this.excludeClass(clazz, false);
        if (!bl && !bl2) {
            return var1_3;
        }
        TypeAdapter typeAdapter = new TypeAdapter<T>((Gson)object, (TypeToken)var2_5){
            private TypeAdapter<T> delegate;
            final /* synthetic */ Gson val$gson;
            final /* synthetic */ TypeToken val$type;
            {
                this.val$gson = gson;
                this.val$type = typeToken;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private TypeAdapter<T> delegate() {
                TypeAdapter typeAdapter = this.delegate;
                if (typeAdapter != null) {
                    return typeAdapter;
                }
                this.delegate = typeAdapter = this.val$gson.getDelegateAdapter((TypeAdapterFactory)Excluder.this, this.val$type);
                return typeAdapter;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public T read(JsonReader jsonReader) throws IOException {
                void var1_3;
                if (bl2) {
                    jsonReader.skipValue();
                    return var1_3;
                }
                Object t2 = this.delegate().read(jsonReader);
                return var1_3;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void write(JsonWriter jsonWriter, T t2) throws IOException {
                if (bl) {
                    jsonWriter.nullValue();
                    return;
                }
                this.delegate().write(jsonWriter, t2);
            }
        };
        return var1_3;
    }

    public Excluder disableInnerClassSerialization() {
        Excluder excluder = this.clone();
        excluder.serializeInnerClasses = false;
        return excluder;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean excludeClass(Class<?> clazz, boolean bl) {
        if (this.version != -1.0 && !this.isValidVersion(clazz.getAnnotation(Since.class), clazz.getAnnotation(Until.class))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(clazz)) {
            return true;
        }
        if (this.isAnonymousOrLocal(clazz)) {
            return true;
        }
        List<ExclusionStrategy> list = bl ? this.serializationStrategies : this.deserializationStrategies;
        list = list.iterator();
        do {
            if (list.hasNext()) continue;
            return false;
        } while (!((ExclusionStrategy)list.next()).shouldSkipClass(clazz));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean excludeField(Field object, boolean bl) {
        Object object2;
        if ((this.modifiers & ((Field)object).getModifiers()) != 0) {
            return true;
        }
        if (this.version != -1.0 && !this.isValidVersion(((Field)object).getAnnotation(Since.class), ((Field)object).getAnnotation(Until.class))) {
            return true;
        }
        if (((Field)object).isSynthetic()) {
            return true;
        }
        if (this.requireExpose) {
            object2 = ((Field)object).getAnnotation(Expose.class);
            if (object2 == null) return true;
            if (bl ? !object2.serialize() : !object2.deserialize()) {
                return true;
            }
        }
        if (!this.serializeInnerClasses && this.isInnerClass(((Field)object).getType())) {
            return true;
        }
        if (this.isAnonymousOrLocal(((Field)object).getType())) {
            return true;
        }
        object2 = bl ? this.serializationStrategies : this.deserializationStrategies;
        if (object2.isEmpty()) return false;
        object = new FieldAttributes((Field)object);
        object2 = object2.iterator();
        do {
            if (!object2.hasNext()) return false;
        } while (!((ExclusionStrategy)object2.next()).shouldSkipField((FieldAttributes)object));
        return true;
    }

    public Excluder excludeFieldsWithoutExposeAnnotation() {
        Excluder excluder = this.clone();
        excluder.requireExpose = true;
        return excluder;
    }

    public Excluder withExclusionStrategy(ExclusionStrategy exclusionStrategy, boolean bl, boolean bl2) {
        Excluder excluder = this.clone();
        if (bl) {
            excluder.serializationStrategies = new ArrayList<ExclusionStrategy>(this.serializationStrategies);
            excluder.serializationStrategies.add(exclusionStrategy);
        }
        if (bl2) {
            excluder.deserializationStrategies = new ArrayList<ExclusionStrategy>(this.deserializationStrategies);
            excluder.deserializationStrategies.add(exclusionStrategy);
        }
        return excluder;
    }

    public Excluder withModifiers(int ... nArray) {
        Excluder excluder = this.clone();
        excluder.modifiers = 0;
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            excluder.modifiers = nArray[i2] | excluder.modifiers;
        }
        return excluder;
    }

    public Excluder withVersion(double d2) {
        Excluder excluder = this.clone();
        excluder.version = d2;
        return excluder;
    }
}

