/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

public final class StringMap<V>
extends AbstractMap<String, V> {
    private static final Map.Entry[] EMPTY_TABLE = new LinkedEntry[2];
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int seed = new Random().nextInt();
    private Set<Map.Entry<String, V>> entrySet;
    private LinkedEntry<V> header;
    private Set<String> keySet;
    private int size;
    private LinkedEntry<V>[] table = (LinkedEntry[])EMPTY_TABLE;
    private int threshold = -1;
    private Collection<V> values;

    public StringMap() {
        this.header = new LinkedEntry();
    }

    private void addNewEntry(String linkedEntryArray, V object, int n2, int n3) {
        LinkedEntry<V> linkedEntry = this.header;
        LinkedEntry linkedEntry2 = linkedEntry.prv;
        object = new LinkedEntry<V>((String)linkedEntryArray, object, n2, this.table[n3], linkedEntry, linkedEntry2);
        linkedEntryArray = this.table;
        linkedEntry.prv = object;
        linkedEntry2.nxt = object;
        linkedEntryArray[n3] = object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private LinkedEntry<V>[] doubleCapacity() {
        block10: {
            block11: {
                var1_1 = this.table;
                var2_2 = var1_1.length;
                if (var2_2 == 0x40000000) {
                    var3_3 /* !! */  = var1_1;
lbl5:
                    // 3 sources

                    return var3_3 /* !! */ ;
                }
                var4_4 = this.makeTable(var2_2 * 2);
                if (this.size != 0) break block11;
                var3_3 /* !! */  = var4_4;
                ** GOTO lbl5
            }
            block1: for (var5_5 = 0; var5_5 < var2_2; ++var5_5) {
                var6_6 /* !! */  = var1_1[var5_5];
                if (var6_6 /* !! */  == null) lbl-1000:
                // 3 sources

                {
                    continue block1;
                }
                var7_7 = var6_6 /* !! */ .hash & var2_2;
                var4_4[var5_5 | var7_7] = var6_6 /* !! */ ;
                var3_3 /* !! */  = var6_6 /* !! */ .next;
                var8_8 = null;
                block3: while (var3_3 /* !! */  != null) {
                    var9_9 = var3_3 /* !! */ .hash & var2_2;
                    if (var9_9 != var7_7) {
                        if (var8_8 == null) {
                            var4_4[var5_5 | var9_9] = var3_3 /* !! */ ;
lbl26:
                            // 2 sources

                            while (true) {
                                var7_7 = var9_9;
lbl28:
                                // 2 sources

                                while (true) {
                                    var10_10 = var3_3 /* !! */ .next;
                                    var8_8 = var6_6 /* !! */ ;
                                    var6_6 /* !! */  = var3_3 /* !! */ ;
                                    var3_3 /* !! */  = var10_10;
                                    continue block3;
                                    break;
                                }
                                break;
                            }
                        }
                        var8_8.next = var3_3 /* !! */ ;
                        ** continue;
                    }
                    break block10;
                }
                if (var8_8 == null) ** GOTO lbl-1000
                var8_8.next = null;
                ** continue;
            }
            var3_3 /* !! */  = var4_4;
            ** while (true)
        }
        var6_6 /* !! */  = var8_8;
        ** while (true)
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private LinkedEntry<V> getEntry(String string2) {
        void var3_4;
        Object var2_2 = null;
        if (string2 == null) {
            Object var3_3 = var2_2;
            return var3_4;
        }
        int n2 = StringMap.hash(string2);
        LinkedEntry<V>[] linkedEntryArray = this.table;
        LinkedEntry<V> linkedEntry = linkedEntryArray[linkedEntryArray.length - 1 & n2];
        while (true) {
            void var5_11;
            Object var3_6 = var2_2;
            if (var5_11 == null) return var3_4;
            String string3 = var5_11.key;
            if (string3 == string2 || var5_11.hash == n2 && string2.equals(string3)) {
                void var3_7 = var5_11;
                return var3_4;
            }
            LinkedEntry linkedEntry2 = var5_11.next;
        }
    }

    private static int hash(String string2) {
        int n2;
        int n3 = seed;
        for (n2 = 0; n2 < string2.length(); ++n2) {
            n3 += string2.charAt(n2);
            n3 = n3 + n3 << 10;
            n3 ^= n3 >>> 6;
        }
        n2 = n3 >>> 20 ^ n3 >>> 12 ^ n3;
        return n2 >>> 4 ^ (n2 >>> 7 ^ n2);
    }

    private LinkedEntry<V>[] makeTable(int n2) {
        LinkedEntry[] linkedEntryArray = new LinkedEntry[n2];
        this.table = linkedEntryArray;
        this.threshold = (n2 >> 1) + (n2 >> 2);
        return linkedEntryArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean removeMapping(Object object, Object object2) {
        if (object == null) return false;
        if (!(object instanceof String)) {
            return false;
        }
        int n2 = StringMap.hash((String)object);
        LinkedEntry<V>[] linkedEntryArray = this.table;
        int n3 = n2 & linkedEntryArray.length - 1;
        LinkedEntry<V> linkedEntry = linkedEntryArray[n3];
        LinkedEntry<V> linkedEntry2 = null;
        while (linkedEntry != null) {
            if (linkedEntry.hash == n2 && object.equals(linkedEntry.key)) {
                if (object2 == null ? linkedEntry.value != null : !object2.equals(linkedEntry.value)) {
                    return false;
                }
                if (linkedEntry2 == null) {
                    linkedEntryArray[n3] = linkedEntry.next;
                } else {
                    linkedEntry2.next = linkedEntry.next;
                }
                --this.size;
                this.unlink(linkedEntry);
                return true;
            }
            LinkedEntry linkedEntry3 = linkedEntry.next;
            linkedEntry2 = linkedEntry;
            linkedEntry = linkedEntry3;
        }
        return false;
    }

    private void unlink(LinkedEntry<V> linkedEntry) {
        linkedEntry.prv.nxt = linkedEntry.nxt;
        linkedEntry.nxt.prv = linkedEntry.prv;
        linkedEntry.prv = null;
        linkedEntry.nxt = null;
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            Arrays.fill(this.table, null);
            this.size = 0;
        }
        LinkedEntry<V> linkedEntry = this.header;
        LinkedEntry linkedEntry2 = linkedEntry.nxt;
        while (linkedEntry2 != linkedEntry) {
            LinkedEntry linkedEntry3 = linkedEntry2.nxt;
            linkedEntry2.prv = null;
            linkedEntry2.nxt = null;
            linkedEntry2 = linkedEntry3;
        }
        linkedEntry.prv = linkedEntry;
        linkedEntry.nxt = linkedEntry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean containsKey(Object object) {
        if (!(object instanceof String)) return false;
        if (this.getEntry((String)object) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet != null) {
            return entrySet;
        }
        this.entrySet = entrySet = new EntrySet();
        return entrySet;
    }

    @Override
    public V get(Object linkedEntry) {
        V v2;
        V v3 = v2 = null;
        if (linkedEntry instanceof String) {
            linkedEntry = this.getEntry((String)((Object)linkedEntry));
            v3 = v2;
            if (linkedEntry != null) {
                v3 = linkedEntry.value;
            }
        }
        return v3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<String> keySet() {
        KeySet keySet = this.keySet;
        if (keySet != null) {
            return keySet;
        }
        this.keySet = keySet = new KeySet();
        return keySet;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public V put(String string2, V v2) {
        void var1_3;
        void var2_5;
        void var4_9;
        if (string2 == null) {
            throw new NullPointerException("key == null");
        }
        int n2 = StringMap.hash(string2);
        LinkedEntry<V>[] linkedEntryArray = this.table;
        int n3 = linkedEntryArray.length - 1 & n2;
        LinkedEntry<V> linkedEntry = linkedEntryArray[n3];
        while (var4_9 != null) {
            if (var4_9.hash == n2 && string2.equals(var4_9.key)) {
                Object v3 = var4_9.value;
                var4_9.value = var2_5;
                return var1_3;
            }
            LinkedEntry linkedEntry2 = var4_9.next;
        }
        int n4 = this.size;
        this.size = n4 + 1;
        if (n4 > this.threshold) {
            n3 = this.doubleCapacity().length - 1 & n2;
        }
        this.addNewEntry(string2, var2_5, n2, n3);
        return var1_3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public V remove(Object object) {
        if (object == null || !(object instanceof String)) {
            object = null;
            return (V)object;
        }
        int n2 = StringMap.hash((String)object);
        LinkedEntry<V>[] linkedEntryArray = this.table;
        int n3 = n2 & linkedEntryArray.length - 1;
        LinkedEntry<V> linkedEntry = linkedEntryArray[n3];
        LinkedEntry<V> linkedEntry2 = null;
        while (true) {
            if (linkedEntry == null) {
                object = null;
                return (V)object;
            }
            if (linkedEntry.hash == n2 && object.equals(linkedEntry.key)) {
                if (linkedEntry2 == null) {
                    linkedEntryArray[n3] = linkedEntry.next;
                } else {
                    linkedEntry2.next = linkedEntry.next;
                }
                --this.size;
                this.unlink(linkedEntry);
                object = linkedEntry.value;
                return (V)object;
            }
            LinkedEntry linkedEntry3 = linkedEntry.next;
            linkedEntry2 = linkedEntry;
            linkedEntry = linkedEntry3;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Collection<V> values() {
        Values values = this.values;
        if (values != null) {
            return values;
        }
        this.values = values = new Values();
        return values;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            StringMap.this.clear();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            boolean bl = false;
            if (!(object instanceof Map.Entry)) {
                return bl;
            }
            object = (Map.Entry)object;
            Object v2 = StringMap.this.get(object.getKey());
            boolean bl2 = bl;
            if (v2 == null) return bl2;
            bl2 = bl;
            if (!v2.equals(object.getValue())) return bl2;
            return true;
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new LinkedHashIterator<Map.Entry<String, V>>(){

                @Override
                public final Map.Entry<String, V> next() {
                    return this.nextEntry();
                }
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            object = (Map.Entry)object;
            return StringMap.this.removeMapping(object.getKey(), object.getValue());
        }

        @Override
        public int size() {
            return StringMap.this.size;
        }
    }

    private final class KeySet
    extends AbstractSet<String> {
        private KeySet() {
        }

        @Override
        public void clear() {
            StringMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return StringMap.this.containsKey(object);
        }

        @Override
        public Iterator<String> iterator() {
            return new LinkedHashIterator<String>(){

                @Override
                public final String next() {
                    return this.nextEntry().key;
                }
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean remove(Object object) {
            int n2 = StringMap.this.size;
            StringMap.this.remove(object);
            if (StringMap.this.size == n2) return false;
            return true;
        }

        @Override
        public int size() {
            return StringMap.this.size;
        }
    }

    static class LinkedEntry<V>
    implements Map.Entry<String, V> {
        final int hash;
        final String key;
        LinkedEntry<V> next;
        LinkedEntry<V> nxt;
        LinkedEntry<V> prv;
        V value;

        LinkedEntry() {
            this(null, null, 0, null, null, null);
            this.prv = this;
            this.nxt = this;
        }

        LinkedEntry(String string2, V v2, int n2, LinkedEntry<V> linkedEntry, LinkedEntry<V> linkedEntry2, LinkedEntry<V> linkedEntry3) {
            this.key = string2;
            this.value = v2;
            this.hash = n2;
            this.next = linkedEntry;
            this.nxt = linkedEntry2;
            this.prv = linkedEntry3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean equals(Object object) {
            boolean bl = false;
            if (!(object instanceof Map.Entry)) {
                return bl;
            }
            object = (Map.Entry)object;
            Object v2 = object.getValue();
            boolean bl2 = bl;
            if (!this.key.equals(object.getKey())) return bl2;
            if (this.value == null) {
                bl2 = bl;
                if (v2 != null) return bl2;
                return true;
            }
            bl2 = bl;
            if (!this.value.equals(v2)) return bl2;
            return true;
        }

        @Override
        public final String getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public final int hashCode() {
            int n2 = 0;
            int n3 = this.key == null ? 0 : this.key.hashCode();
            if (this.value == null) {
                return n3 ^ n2;
            }
            n2 = this.value.hashCode();
            return n3 ^ n2;
        }

        @Override
        public final V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        LinkedEntry<V> lastReturned;
        LinkedEntry<V> next;

        private LinkedHashIterator() {
            this.next = ((StringMap)StringMap.this).header.nxt;
            this.lastReturned = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean hasNext() {
            if (this.next == StringMap.this.header) return false;
            return true;
        }

        final LinkedEntry<V> nextEntry() {
            LinkedEntry linkedEntry = this.next;
            if (linkedEntry == StringMap.this.header) {
                throw new NoSuchElementException();
            }
            this.next = linkedEntry.nxt;
            this.lastReturned = linkedEntry;
            return linkedEntry;
        }

        @Override
        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            StringMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public void clear() {
            StringMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return StringMap.this.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return new LinkedHashIterator<V>(){

                @Override
                public final V next() {
                    return this.nextEntry().value;
                }
            };
        }

        @Override
        public int size() {
            return StringMap.this.size;
        }
    }
}

