/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class SqlDateTypeAdapter
extends TypeAdapter<java.sql.Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
            void var1_3;
            void var2_5;
            if (var2_5.getRawType() != java.sql.Date.class) return var1_3;
            SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
            return var1_3;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public java.sql.Date read(JsonReader object) throws IOException {
        synchronized (this) {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            try {
                return new java.sql.Date(this.format.parse(((JsonReader)object).nextString()).getTime());
            }
            catch (ParseException parseException) {
                object = new JsonSyntaxException(parseException);
                throw object;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(JsonWriter jsonWriter, java.sql.Date object) throws IOException {
        synchronized (this) {
            String string2;
            string2 = string2 == null ? null : this.format.format((Date)((Object)string2));
            jsonWriter.value(string2);
            return;
        }
    }
}

