/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.FullBox;
import com.googlecode.mp4parser.AbstractContainerBox;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.logging.Logger;

public abstract class FullContainerBox
extends AbstractContainerBox
implements FullBox {
    private static Logger LOG = Logger.getLogger(FullContainerBox.class.getName());
    private int flags;
    private int version;

    public FullContainerBox(String string2) {
        super(string2);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected ByteBuffer getHeader() {
        Object object;
        if (this.largeBox || this.getSize() >= 0x100000000L) {
            object = new byte[20];
            object[3] = (byte)1;
            object[4] = this.type.getBytes()[0];
            object[5] = this.type.getBytes()[1];
            object[6] = this.type.getBytes()[2];
            object[7] = this.type.getBytes()[3];
            object = ByteBuffer.wrap((byte[])object);
            ((ByteBuffer)object).position(8);
            IsoTypeWriter.writeUInt64((ByteBuffer)object, this.getSize());
            this.writeVersionAndFlags((ByteBuffer)object);
        } else {
            object = new byte[12];
            object[4] = this.type.getBytes()[0];
            object[5] = this.type.getBytes()[1];
            object[6] = this.type.getBytes()[2];
            object[7] = this.type.getBytes()[3];
            object = ByteBuffer.wrap((byte[])object);
            IsoTypeWriter.writeUInt32((ByteBuffer)object, this.getSize());
            ((ByteBuffer)object).position(8);
            this.writeVersionAndFlags((ByteBuffer)object);
        }
        ((ByteBuffer)object).rewind();
        return object;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void parse(DataSource dataSource, ByteBuffer byteBuffer, long l2, BoxParser boxParser) throws IOException {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
        dataSource.read(byteBuffer2);
        this.parseVersionAndFlags((ByteBuffer)byteBuffer2.rewind());
        super.parse(dataSource, byteBuffer, l2, boxParser);
    }

    protected final long parseVersionAndFlags(ByteBuffer byteBuffer) {
        this.version = IsoTypeReader.readUInt8(byteBuffer);
        this.flags = IsoTypeReader.readUInt24(byteBuffer);
        return 4L;
    }

    @Override
    public void setFlags(int n2) {
        this.flags = n2;
    }

    @Override
    public void setVersion(int n2) {
        this.version = n2;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[childBoxes]";
    }

    protected final void writeVersionAndFlags(ByteBuffer byteBuffer) {
        IsoTypeWriter.writeUInt8(byteBuffer, this.version);
        IsoTypeWriter.writeUInt24(byteBuffer, this.flags);
    }
}

