/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.adaptivestreaming;

import com.coremedia.iso.Hex;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.coremedia.iso.boxes.h264.AvcConfigurationBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.Version;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.adaptivestreaming.AbstractManifestWriter;
import com.googlecode.mp4parser.authoring.adaptivestreaming.AudioQuality;
import com.googlecode.mp4parser.authoring.adaptivestreaming.VideoQuality;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.boxes.DTSSpecificBox;
import com.googlecode.mp4parser.boxes.EC3SpecificBox;
import com.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FlatManifestWriterImpl
extends AbstractManifestWriter {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Logger LOG;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !FlatManifestWriterImpl.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
        LOG = Logger.getLogger(FlatManifestWriterImpl.class.getName());
    }

    protected FlatManifestWriterImpl(FragmentIntersectionFinder fragmentIntersectionFinder) {
        super(fragmentIntersectionFinder);
    }

    /*
     * Enabled aggressive block sorting
     */
    private AudioQuality getAacAudioQuality(Track track, AudioSampleEntry audioSampleEntry) {
        AudioQuality audioQuality = new AudioQuality();
        AudioSpecificConfig audioSpecificConfig = audioSampleEntry.getBoxes(ESDescriptorBox.class).get(0).getEsDescriptor().getDecoderConfigDescriptor().getAudioSpecificInfo();
        audioQuality.fourCC = audioSpecificConfig.getSbrPresentFlag() == 1 ? "AACH" : (audioSpecificConfig.getPsPresentFlag() == 1 ? "AACP" : "AACL");
        audioQuality.bitrate = this.getBitrate(track);
        audioQuality.audioTag = 255;
        audioQuality.samplingRate = audioSampleEntry.getSampleRate();
        audioQuality.channels = audioSampleEntry.getChannelCount();
        audioQuality.bitPerSample = audioSampleEntry.getSampleSize();
        audioQuality.packetSize = 4;
        audioQuality.codecPrivateData = this.getAudioCodecPrivateData(audioSpecificConfig);
        return audioQuality;
    }

    private String getAudioCodecPrivateData(AudioSpecificConfig audioSpecificConfig) {
        return Hex.encodeHex(audioSpecificConfig.getConfigBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AudioQuality getAudioQuality(Track object, AudioSampleEntry audioSampleEntry) {
        if (this.getFormat(audioSampleEntry).equals("mp4a")) {
            return this.getAacAudioQuality((Track)object, audioSampleEntry);
        }
        if (this.getFormat(audioSampleEntry).equals("ec-3")) {
            return this.getEc3AudioQuality((Track)object, audioSampleEntry);
        }
        if (!this.getFormat(audioSampleEntry).startsWith("dts")) throw new InternalError("I don't know what to do with audio of type " + this.getFormat(audioSampleEntry));
        return this.getDtsAudioQuality((Track)object, audioSampleEntry);
    }

    /*
     * Exception decompiling
     */
    private byte[] getAvcCodecPrivateData(AvcConfigurationBox var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [6 : 117->133)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    private AudioQuality getDtsAudioQuality(Track track, AudioSampleEntry audioSampleEntry) {
        int n2;
        DTSSpecificBox dTSSpecificBox = audioSampleEntry.getBoxes(DTSSpecificBox.class).get(0);
        if (dTSSpecificBox == null) {
            throw new RuntimeException("DTS track misses DTSSpecificBox!");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(22);
        switch (dTSSpecificBox.getFrameDuration()) {
            default: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 512;
                break;
            }
            case 1: {
                n2 = 1024;
                break;
            }
            case 2: {
                n2 = 2048;
                break;
            }
            case 3: {
                n2 = 4096;
            }
        }
        byteBuffer.put((byte)(n2 & 0xFF));
        byteBuffer.put((byte)(n2 >>> 8));
        n2 = this.getNumChannelsAndMask(dTSSpecificBox)[1];
        byteBuffer.put((byte)(n2 & 0xFF));
        byteBuffer.put((byte)(n2 >>> 8));
        byteBuffer.put((byte)(n2 >>> 16));
        byteBuffer.put((byte)(n2 >>> 24));
        byteBuffer.put(new byte[]{-82, -28, -65, 94, 97, 94, 65, -121, -110, -4, -92, -127, 38, -103, 2, 17});
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(8);
        byteBuffer2.put((byte)dTSSpecificBox.getStreamConstruction());
        n2 = dTSSpecificBox.getChannelLayout();
        byteBuffer2.put((byte)(n2 & 0xFF));
        byteBuffer2.put((byte)(n2 >>> 8));
        byteBuffer2.put((byte)(n2 >>> 16));
        byteBuffer2.put((byte)(n2 >>> 24));
        byteBuffer2.put((byte)((byte)(dTSSpecificBox.getMultiAssetFlag() << 1) | dTSSpecificBox.getLBRDurationMod()));
        byteBuffer2.put(new byte[2]);
        AudioQuality audioQuality = new AudioQuality();
        audioQuality.fourCC = this.getFormat(audioSampleEntry);
        audioQuality.bitrate = dTSSpecificBox.getAvgBitRate();
        audioQuality.audioTag = 65534;
        audioQuality.samplingRate = dTSSpecificBox.getDTSSamplingFrequency();
        audioQuality.channels = this.getNumChannelsAndMask(dTSSpecificBox)[0];
        audioQuality.bitPerSample = 16;
        audioQuality.packetSize = (int)track.getSamples().get(0).remaining();
        audioQuality.codecPrivateData = String.valueOf(Hex.encodeHex(byteBuffer.array())) + Hex.encodeHex(byteBuffer2.array());
        return audioQuality;
    }

    /*
     * Enabled aggressive block sorting
     */
    private AudioQuality getEc3AudioQuality(Track track, AudioSampleEntry audioSampleEntry) {
        EC3SpecificBox eC3SpecificBox = audioSampleEntry.getBoxes(EC3SpecificBox.class).get(0);
        if (eC3SpecificBox == null) {
            throw new RuntimeException("EC-3 track misses EC3SpecificBox!");
        }
        Object object = eC3SpecificBox.getEntries().iterator();
        short s2 = 0;
        short s3 = 0;
        int n2 = 0;
        int n3 = 0;
        short s4 = s3;
        short s5 = s2;
        while (true) {
            int n4;
            Object object2;
            if (!object.hasNext()) {
                object = ByteBuffer.allocate(22);
                object2 = new byte[2];
                object2[1] = (byte)6;
                ((ByteBuffer)object).put((byte[])object2);
                ((ByteBuffer)object).put((byte)s4);
                ((ByteBuffer)object).put((byte)s5);
                ((ByteBuffer)object).put(new byte[2]);
                ((ByteBuffer)object).put(new byte[]{-81, -121, -5, -89, 2, 45, -5, 66, -92, -44, 5, -51, -109, -124, 59, -35});
                object2 = ByteBuffer.allocate((int)eC3SpecificBox.getContentSize());
                eC3SpecificBox.getContent((ByteBuffer)object2);
                AudioQuality audioQuality = new AudioQuality();
                audioQuality.fourCC = "EC-3";
                audioQuality.bitrate = this.getBitrate(track);
                audioQuality.audioTag = 65534;
                audioQuality.samplingRate = audioSampleEntry.getSampleRate();
                audioQuality.channels = n3 + n2;
                audioQuality.bitPerSample = 16;
                audioQuality.packetSize = (int)track.getSamples().get(0).remaining();
                audioQuality.codecPrivateData = String.valueOf(Hex.encodeHex(((ByteBuffer)object).array())) + Hex.encodeHex(((ByteBuffer)object2).array());
                return audioQuality;
            }
            object2 = object.next();
            switch (((EC3SpecificBox.Entry)object2).acmod) {
                default: {
                    n4 = n3;
                    s2 = s4;
                    s3 = s5;
                    break;
                }
                case 0: {
                    s2 = (short)(n3 + 2);
                    throw new RuntimeException("Smooth Streaming doesn't support DDP 1+1 mode");
                }
                case 1: {
                    DependentSubstreamMask dependentSubstreamMask;
                    n4 = (short)(n3 + 1);
                    if (((EC3SpecificBox.Entry)object2).num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask((byte)s4, (byte)s5, (EC3SpecificBox.Entry)object2).process();
                        s2 = (byte)(s4 | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        s3 = (byte)(s5 | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    s2 = (byte)(s4 | 0x20);
                    s3 = s5;
                    break;
                }
                case 2: {
                    DependentSubstreamMask dependentSubstreamMask;
                    n4 = (short)(n3 + 2);
                    if (((EC3SpecificBox.Entry)object2).num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask((byte)s4, (byte)s5, (EC3SpecificBox.Entry)object2).process();
                        s2 = (byte)(s4 | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        s3 = (byte)(s5 | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    s2 = (byte)(s4 | 0xC0);
                    s3 = s5;
                    break;
                }
                case 3: {
                    DependentSubstreamMask dependentSubstreamMask;
                    n4 = (short)(n3 + 3);
                    if (((EC3SpecificBox.Entry)object2).num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask((byte)s4, (byte)s5, (EC3SpecificBox.Entry)object2).process();
                        s2 = (byte)(s4 | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        s3 = (byte)(s5 | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    s2 = (byte)(s4 | 0xE0);
                    s3 = s5;
                    break;
                }
                case 4: {
                    DependentSubstreamMask dependentSubstreamMask;
                    n4 = (short)(n3 + 3);
                    if (((EC3SpecificBox.Entry)object2).num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask((byte)s4, (byte)s5, (EC3SpecificBox.Entry)object2).process();
                        s2 = (byte)(s4 | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        s3 = (byte)(s5 | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    s2 = (byte)(s4 | 0xC0);
                    s3 = (byte)(s5 | 0x80);
                    break;
                }
                case 5: {
                    DependentSubstreamMask dependentSubstreamMask;
                    n4 = (short)(n3 + 4);
                    if (((EC3SpecificBox.Entry)object2).num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask((byte)s4, (byte)s5, (EC3SpecificBox.Entry)object2).process();
                        s2 = (byte)(s4 | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        s3 = (byte)(s5 | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    s2 = (byte)(s4 | 0xE0);
                    s3 = (byte)(s5 | 0x80);
                    break;
                }
                case 6: {
                    DependentSubstreamMask dependentSubstreamMask;
                    n4 = (short)(n3 + 4);
                    if (((EC3SpecificBox.Entry)object2).num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask((byte)s4, (byte)s5, (EC3SpecificBox.Entry)object2).process();
                        s2 = (byte)(s4 | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        s3 = (byte)(s5 | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    s2 = (byte)(s4 | 0xCC);
                    s3 = s5;
                    break;
                }
                case 7: {
                    DependentSubstreamMask dependentSubstreamMask;
                    n4 = (short)(n3 + 5);
                    if (((EC3SpecificBox.Entry)object2).num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask((byte)s4, (byte)s5, (EC3SpecificBox.Entry)object2).process();
                        s2 = (byte)(s4 | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        s3 = (byte)(s5 | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    s2 = (byte)(s4 | 0xEC);
                    s3 = s5;
                }
            }
            s5 = s3;
            s4 = s2;
            n3 = n4;
            if (((EC3SpecificBox.Entry)object2).lfeon != 1) continue;
            n2 = (short)(n2 + 1);
            s2 = (byte)(s2 | 0x10);
            s5 = s3;
            s4 = s2;
            n3 = n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int[] getNumChannelsAndMask(DTSSpecificBox dTSSpecificBox) {
        int n2;
        int n3;
        int n4 = dTSSpecificBox.getChannelLayout();
        if ((n4 & 1) == 1) {
            n3 = 4;
            n2 = 1;
        } else {
            n3 = 0;
            n2 = 0;
        }
        int n5 = n3;
        int n6 = n2;
        if ((n4 & 2) == 2) {
            n6 = n2 + 2;
            n5 = n3 | 1 | 2;
        }
        n2 = n5;
        n3 = n6;
        if ((n4 & 4) == 4) {
            n3 = n6 + 2;
            n2 = n5 | 0x10 | 0x20;
        }
        n6 = n2;
        n5 = n3;
        if ((n4 & 8) == 8) {
            n5 = n3 + 1;
            n6 = n2 | 8;
        }
        n2 = n6;
        n3 = n5;
        if ((n4 & 0x10) == 16) {
            n3 = n5 + 1;
            n2 = n6 | 0x100;
        }
        n5 = n2;
        n6 = n3;
        if ((n4 & 0x20) == 32) {
            n6 = n3 + 2;
            n5 = n2 | 0x1000 | 0x4000;
        }
        int n7 = n5;
        n3 = n6;
        if ((n4 & 0x40) == 64) {
            n3 = n6 + 2;
            n7 = n5 | 0x10 | 0x20;
        }
        n6 = n7;
        n2 = n3;
        if ((n4 & 0x80) == 128) {
            n2 = n3 + 1;
            n6 = n7 | 0x2000;
        }
        n5 = n6;
        n3 = n2;
        if ((n4 & 0x100) == 256) {
            n3 = n2 + 1;
            n5 = n6 | 0x800;
        }
        n2 = n5;
        n6 = n3;
        if ((n4 & 0x200) == 512) {
            n6 = n3 + 2;
            n2 = n5 | 0x40 | 0x80;
        }
        n5 = n2;
        n3 = n6;
        if ((n4 & 0x400) == 1024) {
            n3 = n6 + 2;
            n5 = n2 | 0x200 | 0x400;
        }
        n2 = n5;
        n6 = n3;
        if ((n4 & 0x800) == 2048) {
            n6 = n3 + 2;
            n2 = n5 | 0x10 | 0x20;
        }
        n3 = n2;
        n5 = n6;
        if ((n4 & 0x1000) == 4096) {
            n5 = n6 + 1;
            n3 = n2 | 8;
        }
        n2 = n3;
        n6 = n5;
        if ((n4 & 0x2000) == 8192) {
            n6 = n5 + 2;
            n2 = n3 | 0x10 | 0x20;
        }
        n3 = n2;
        n5 = n6;
        if ((n4 & 0x4000) == 16384) {
            n5 = n6 + 1;
            n3 = n2 | 0x10000;
        }
        if ((n4 & 0x8000) == 32768) {
            n6 = n5 + 2;
            n5 = n3 | 0x8000 | 0x20000;
        } else {
            n6 = n5;
            n5 = n3;
        }
        n3 = n6;
        if ((n4 & 0x10000) == 65536) {
            n3 = n6 + 1;
        }
        n6 = n3;
        if ((n4 & 0x20000) == 131072) {
            n6 = n3 + 2;
        }
        return new int[]{n6, n5};
    }

    private VideoQuality getVideoQuality(Track track, VisualSampleEntry visualSampleEntry) {
        if ("avc1".equals(this.getFormat(visualSampleEntry))) {
            AvcConfigurationBox avcConfigurationBox = visualSampleEntry.getBoxes(AvcConfigurationBox.class).get(0);
            VideoQuality videoQuality = new VideoQuality();
            videoQuality.bitrate = this.getBitrate(track);
            videoQuality.codecPrivateData = Hex.encodeHex(this.getAvcCodecPrivateData(avcConfigurationBox));
            videoQuality.fourCC = "AVC1";
            videoQuality.width = visualSampleEntry.getWidth();
            videoQuality.height = visualSampleEntry.getHeight();
            videoQuality.nalLength = avcConfigurationBox.getLengthSizeMinusOne() + 1;
            return videoQuality;
        }
        throw new InternalError("I don't know how to handle video of type " + this.getFormat(visualSampleEntry));
    }

    protected Document customizeManifest(Document document) {
        return document;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String getManifest(Movie var1_1) throws IOException {
        block16: {
            block15: {
                block14: {
                    block13: {
                        var2_5 = 0;
                        var3_6 = new LinkedList<VideoQuality>();
                        var4_7 = new LinkedList<AudioQuality>();
                        var5_8 = var1_1.getTracks().iterator();
                        var6_9 = -1L;
                        var8_10 = -1L;
                        block5: while (true) {
                            block17: {
                                block20: {
                                    block19: {
                                        block18: {
                                            if (var5_8.hasNext()) break block18;
                                            var1_1 = DocumentBuilderFactory.newInstance();
                                            var1_1 = var1_1.newDocumentBuilder();
                                            var1_1 = var1_1.newDocument();
                                            var10_11 = var1_1.createElement("SmoothStreamingMedia");
                                            var1_1.appendChild((Node)var10_11);
                                            var10_11.setAttribute("MajorVersion", "2");
                                            var10_11.setAttribute("MinorVersion", "1");
                                            var10_11.setAttribute("Duration", "0");
                                            var10_11.appendChild(var1_1.createComment(Version.VERSION));
                                            var5_8 = var1_1.createElement("StreamIndex");
                                            var5_8.setAttribute("Type", "video");
                                            var5_8.setAttribute("TimeScale", Long.toString(var8_10));
                                            var5_8.setAttribute("Chunks", Integer.toString(this.videoFragmentsDurations.length));
                                            var5_8.setAttribute("Url", "video/{bitrate}/{start time}");
                                            var5_8.setAttribute("QualityLevels", Integer.toString(var3_6.size()));
                                            var10_11.appendChild((Node)var5_8);
                                            var11_13 = 0;
lbl30:
                                            // 2 sources

                                            while (true) {
                                                if (var11_13 < var3_6.size()) break block13;
                                                var11_13 = 0;
lbl33:
                                                // 2 sources

                                                while (true) {
                                                    if (var11_13 < this.videoFragmentsDurations.length) break block14;
                                                    if (this.audioFragmentsDurations == null) ** GOTO lbl50
                                                    var3_6 = var1_1.createElement("StreamIndex");
                                                    var3_6.setAttribute("Type", "audio");
                                                    var3_6.setAttribute("TimeScale", Long.toString(var6_9));
                                                    var3_6.setAttribute("Chunks", Integer.toString(this.audioFragmentsDurations.length));
                                                    var3_6.setAttribute("Url", "audio/{bitrate}/{start time}");
                                                    var3_6.setAttribute("QualityLevels", Integer.toString(var4_7.size()));
                                                    var10_11.appendChild((Node)var3_6);
                                                    var11_13 = 0;
lbl45:
                                                    // 2 sources

                                                    while (true) {
                                                        if (var11_13 < var4_7.size()) break block15;
                                                        var11_13 = var2_5;
lbl48:
                                                        // 2 sources

                                                        while (true) {
                                                            if (var11_13 < this.audioFragmentsDurations.length) break block16;
lbl50:
                                                            // 2 sources

                                                            var1_1.setXmlStandalone(true);
                                                            var1_1 = new DOMSource(this.customizeManifest((Document)var1_1));
                                                            var4_7 = new StringWriter();
                                                            var3_6 = new StreamResult((Writer)var4_7);
                                                            var10_11 = TransformerFactory.newInstance();
                                                            var10_11 = var10_11.newTransformer();
                                                            var10_11.setOutputProperty("indent", "yes");
                                                            var10_11.transform((Source)var1_1, (Result)var3_6);
                                                            return var4_7.getBuffer().toString();
                                                            break;
                                                        }
                                                        break;
                                                    }
                                                    break;
                                                }
                                                break;
                                            }
                                        }
                                        var10_11 = var5_8.next();
                                        var12_12 = var8_10;
                                        if (!(var10_11.getMediaHeaderBox() instanceof VideoMediaHeaderBox)) break block19;
                                        this.videoFragmentsDurations = this.checkFragmentsAlign(this.videoFragmentsDurations, this.calculateFragmentDurations((Track)var10_11, (Movie)var1_1));
                                        var3_6.add(this.getVideoQuality((Track)var10_11, (VisualSampleEntry)var10_11.getSampleDescriptionBox().getSampleEntry()));
                                        if (var8_10 != -1L) break block20;
                                        var12_12 = var10_11.getTrackMetaData().getTimescale();
                                    }
lbl70:
                                    // 3 sources

                                    while (true) {
                                        var8_10 = var12_12;
                                        if (!(var10_11.getMediaHeaderBox() instanceof SoundMediaHeaderBox)) continue block5;
                                        this.audioFragmentsDurations = this.checkFragmentsAlign(this.audioFragmentsDurations, this.calculateFragmentDurations((Track)var10_11, (Movie)var1_1));
                                        var4_7.add(this.getAudioQuality((Track)var10_11, (AudioSampleEntry)var10_11.getSampleDescriptionBox().getSampleEntry()));
                                        if (var6_9 == -1L) {
                                            var6_9 = var10_11.getTrackMetaData().getTimescale();
                                            var8_10 = var12_12;
                                            continue block5;
                                        }
                                        break block17;
                                        break;
                                    }
                                }
                                var12_12 = var8_10;
                                if (FlatManifestWriterImpl.$assertionsDisabled) ** GOTO lbl70
                                var12_12 = var8_10;
                                if (var8_10 != var10_11.getTrackMetaData().getTimescale()) ** break;
                                ** continue;
                                throw new AssertionError();
                            }
                            var8_10 = var12_12;
                            if (FlatManifestWriterImpl.$assertionsDisabled) continue;
                            var8_10 = var12_12;
                            if (var6_9 != var10_11.getTrackMetaData().getTimescale()) break;
                        }
                        throw new AssertionError();
                        catch (ParserConfigurationException var1_2) {
                            throw new IOException(var1_2);
                        }
                    }
                    var14_14 = (VideoQuality)var3_6.get(var11_13);
                    var15_15 = var1_1.createElement("QualityLevel");
                    var15_15.setAttribute("Index", Integer.toString(var11_13));
                    var15_15.setAttribute("Bitrate", Long.toString(var14_14.bitrate));
                    var15_15.setAttribute("FourCC", var14_14.fourCC);
                    var15_15.setAttribute("MaxWidth", Long.toString(var14_14.width));
                    var15_15.setAttribute("MaxHeight", Long.toString(var14_14.height));
                    var15_15.setAttribute("CodecPrivateData", var14_14.codecPrivateData);
                    var15_15.setAttribute("NALUnitLengthField", Integer.toString(var14_14.nalLength));
                    var5_8.appendChild(var15_15);
                    ++var11_13;
                    ** while (true)
                }
                var3_6 = var1_1.createElement("c");
                var3_6.setAttribute("n", Integer.toString(var11_13));
                var3_6.setAttribute("d", Long.toString(this.videoFragmentsDurations[var11_13]));
                var5_8.appendChild((Node)var3_6);
                ++var11_13;
                ** while (true)
            }
            var10_11 = (AudioQuality)var4_7.get(var11_13);
            var5_8 = var1_1.createElement("QualityLevel");
            var5_8.setAttribute("Index", Integer.toString(var11_13));
            var5_8.setAttribute("FourCC", var10_11.fourCC);
            var5_8.setAttribute("Bitrate", Long.toString(var10_11.bitrate));
            var5_8.setAttribute("AudioTag", Integer.toString(var10_11.audioTag));
            var5_8.setAttribute("SamplingRate", Long.toString(var10_11.samplingRate));
            var5_8.setAttribute("Channels", Integer.toString(var10_11.channels));
            var5_8.setAttribute("BitsPerSample", Integer.toString(var10_11.bitPerSample));
            var5_8.setAttribute("PacketSize", Integer.toString(var10_11.packetSize));
            var5_8.setAttribute("CodecPrivateData", var10_11.codecPrivateData);
            var3_6.appendChild((Node)var5_8);
            ++var11_13;
            ** while (true)
        }
        var4_7 = var1_1.createElement("c");
        var4_7.setAttribute("n", Integer.toString(var11_13));
        var4_7.setAttribute("d", Long.toString(this.audioFragmentsDurations[var11_13]));
        var3_6.appendChild((Node)var4_7);
        ++var11_13;
        ** while (true)
        catch (TransformerConfigurationException var1_3) {
            throw new IOException(var1_3);
        }
        catch (TransformerException var1_4) {
            throw new IOException(var1_4);
        }
    }

    private class DependentSubstreamMask {
        private byte dWChannelMaskFirstByte;
        private byte dWChannelMaskSecondByte;
        private EC3SpecificBox.Entry entry;

        public DependentSubstreamMask(byte by, byte by2, EC3SpecificBox.Entry entry) {
            this.dWChannelMaskFirstByte = by;
            this.dWChannelMaskSecondByte = by2;
            this.entry = entry;
        }

        public byte getdWChannelMaskFirstByte() {
            return this.dWChannelMaskFirstByte;
        }

        public byte getdWChannelMaskSecondByte() {
            return this.dWChannelMaskSecondByte;
        }

        /*
         * Enabled aggressive block sorting
         */
        public DependentSubstreamMask process() {
            switch (this.entry.chan_loc) {
                case 0: {
                    this.dWChannelMaskFirstByte = (byte)(this.dWChannelMaskFirstByte | 3);
                    return this;
                }
                case 1: {
                    this.dWChannelMaskFirstByte = (byte)(this.dWChannelMaskFirstByte | 0xC);
                    return this;
                }
                case 2: {
                    this.dWChannelMaskSecondByte = (byte)(this.dWChannelMaskSecondByte | 0x80);
                    return this;
                }
                case 3: {
                    this.dWChannelMaskSecondByte = (byte)(this.dWChannelMaskSecondByte | 8);
                    return this;
                }
                case 6: {
                    this.dWChannelMaskSecondByte = (byte)(this.dWChannelMaskSecondByte | 5);
                    return this;
                }
                case 7: {
                    this.dWChannelMaskSecondByte = (byte)(this.dWChannelMaskSecondByte | 2);
                    return this;
                }
            }
            return this;
        }
    }
}

