/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.adaptivestreaming;

import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.adaptivestreaming.FlatManifestWriterImpl;
import com.googlecode.mp4parser.authoring.adaptivestreaming.ManifestWriter;
import com.googlecode.mp4parser.authoring.adaptivestreaming.PackageWriter;
import com.googlecode.mp4parser.authoring.builder.DefaultMp4Builder;
import com.googlecode.mp4parser.authoring.builder.FragmentedMp4Builder;
import com.googlecode.mp4parser.authoring.builder.SyncSampleIntersectFinderImpl;
import com.googlecode.mp4parser.authoring.tracks.ChangeTimeScaleTrack;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.logging.Logger;

public class FlatPackageWriterImpl
implements PackageWriter {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static Logger LOG;
    private boolean debugOutput;
    private FragmentedMp4Builder ismvBuilder = new FragmentedMp4Builder();
    ManifestWriter manifestWriter;
    private File outputDirectory;
    long timeScale = 10000000L;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !FlatPackageWriterImpl.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
        LOG = Logger.getLogger(FlatPackageWriterImpl.class.getName());
    }

    public FlatPackageWriterImpl() {
        SyncSampleIntersectFinderImpl syncSampleIntersectFinderImpl = new SyncSampleIntersectFinderImpl();
        this.ismvBuilder.setIntersectionFinder(syncSampleIntersectFinderImpl);
        this.manifestWriter = new FlatManifestWriterImpl(syncSampleIntersectFinderImpl);
    }

    public FlatPackageWriterImpl(int n2) {
        SyncSampleIntersectFinderImpl syncSampleIntersectFinderImpl = new SyncSampleIntersectFinderImpl(n2);
        this.ismvBuilder.setIntersectionFinder(syncSampleIntersectFinderImpl);
        this.manifestWriter = new FlatManifestWriterImpl(syncSampleIntersectFinderImpl);
    }

    private Movie removeUnknownTracks(Movie object) {
        Movie movie = new Movie();
        Iterator<Track> iterator = ((Movie)object).getTracks().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if ("vide".equals(object.getHandler()) || "soun".equals(object.getHandler())) {
                movie.addTrack((Track)object);
                continue;
            }
            LOG.fine("Removed track " + object);
        }
        return movie;
    }

    public Movie correctTimescale(Movie movie) {
        Movie movie2 = new Movie();
        Iterator<Track> iterator = movie.getTracks().iterator();
        while (iterator.hasNext()) {
            Track track = iterator.next();
            movie2.addTrack(new ChangeTimeScaleTrack(track, this.timeScale, this.ismvBuilder.getFragmentIntersectionFinder().sampleNumbers(track, movie)));
        }
        return movie2;
    }

    public void setDebugOutput(boolean bl) {
        this.debugOutput = bl;
    }

    public void setIsmvBuilder(FragmentedMp4Builder fragmentedMp4Builder) {
        this.ismvBuilder = fragmentedMp4Builder;
        this.manifestWriter = new FlatManifestWriterImpl(fragmentedMp4Builder.getFragmentIntersectionFinder());
    }

    public void setManifestWriter(ManifestWriter manifestWriter) {
        this.manifestWriter = manifestWriter;
    }

    public void setOutputDirectory(File file) {
        if (!$assertionsDisabled && !file.isDirectory()) {
            throw new AssertionError();
        }
        this.outputDirectory = file;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(Movie var1_1) throws IOException {
        if (this.debugOutput) {
            this.outputDirectory.mkdirs();
            var2_2 = new DefaultMp4Builder().build((Movie)var1_1);
            var3_3 = new FileOutputStream(new File(this.outputDirectory, "debug_1_muxed.mp4"));
            var2_2.writeContainer(var3_3.getChannel());
            var3_3.close();
        }
        var3_3 = this.correctTimescale(this.removeUnknownTracks((Movie)var1_1));
        if (this.debugOutput) {
            var2_2 = new DefaultMp4Builder().build((Movie)var3_3);
            var1_1 = new FileOutputStream(new File(this.outputDirectory, "debug_2_timescale.mp4"));
            var2_2.writeContainer(var1_1.getChannel());
            var1_1.close();
        }
        var2_2 = this.ismvBuilder.build((Movie)var3_3);
        if (this.debugOutput) {
            var1_1 = new FileOutputStream(new File(this.outputDirectory, "debug_3_fragmented.mp4"));
            var2_2.writeContainer(var1_1.getChannel());
            var1_1.close();
        }
        var4_4 = var3_3.getTracks().iterator();
        block0: while (true) {
            if (!var4_4.hasNext()) {
                var1_1 = new FileWriter(new File(this.outputDirectory, "Manifest"));
                var1_1.write(this.manifestWriter.getManifest((Movie)var3_3));
                var1_1.close();
                return;
            }
            var5_5 = var4_4.next();
            var6_6 = Long.toString(this.manifestWriter.getBitrate((Track)var5_5));
            var7_7 = var5_5.getTrackMetaData().getTrackId();
            var9_8 = var2_2.getBoxes().iterator();
            if (var5_5.getMediaHeaderBox() instanceof SoundMediaHeaderBox) {
                var1_1 = new File(this.outputDirectory, "audio");
lbl32:
                // 2 sources

                while (true) {
                    var1_1 = new File((File)var1_1, (String)var6_6);
                    var1_1.mkdirs();
                    FlatPackageWriterImpl.LOG.finer("Created : " + var1_1.getCanonicalPath());
                    var6_6 = this.manifestWriter.calculateFragmentDurations((Track)var5_5, (Movie)var3_3);
                    var10_9 = 0L;
                    var12_10 = 0;
lbl40:
                    // 3 sources

                    while (true) {
                        if (!var9_8.hasNext()) continue block0;
                        var5_5 = var9_8.next();
                        if (!(var5_5 instanceof MovieFragmentBox)) continue;
                        if (!FlatPackageWriterImpl.$assertionsDisabled && ((MovieFragmentBox)var5_5).getTrackCount() != 1) {
                            throw new AssertionError();
                        }
                        break block0;
                        break;
                    }
                    break;
                }
            }
            if (var5_5.getMediaHeaderBox() instanceof VideoMediaHeaderBox) {
                var1_1 = new File(this.outputDirectory, "video");
                ** continue;
            }
            System.err.println("Skipping Track with handler " + var5_5.getHandler() + " and " + var5_5.getMediaHeaderBox().getClass().getSimpleName());
        }
        if (((MovieFragmentBox)var5_5).getTrackNumbers()[0] != var7_7) ** GOTO lbl40
        var13_11 = new FileOutputStream(new File((File)var1_1, Long.toString(var10_9)));
        var10_9 += var6_6[var12_10];
        var13_11 = var13_11.getChannel();
        var14_12 = var9_8.next();
        if (!FlatPackageWriterImpl.$assertionsDisabled && !var14_12.getType().equals("mdat")) {
            throw new AssertionError();
        }
        var5_5.getBox((WritableByteChannel)var13_11);
        var14_12.getBox((WritableByteChannel)var13_11);
        var13_11.truncate(var13_11.position());
        var13_11.close();
        ++var12_10;
        ** while (true)
    }
}

