/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.AbstractContainerBox;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.mp4.AbstractDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AppendTrack
extends AbstractTrack {
    private static Logger LOG = Logger.getLogger(AppendTrack.class);
    SampleDescriptionBox stsd;
    Track[] tracks;

    /*
     * Enabled aggressive block sorting
     */
    public AppendTrack(Track ... trackArray) throws IOException {
        this.tracks = trackArray;
        int n2 = trackArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Track track = trackArray[n3];
            if (this.stsd == null) {
                this.stsd = new SampleDescriptionBox();
                this.stsd.addBox(track.getSampleDescriptionBox().getBoxes(SampleEntry.class).get(0));
            } else {
                this.stsd = this.mergeStsds(this.stsd, track.getSampleDescriptionBox());
            }
            ++n3;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AudioSampleEntry mergeAudioSampleEntries(AudioSampleEntry iterator, AudioSampleEntry box) {
        AudioSampleEntry audioSampleEntry = new AudioSampleEntry(((AbstractContainerBox)box).getType());
        if (((AudioSampleEntry)iterator).getBytesPerFrame() != ((AudioSampleEntry)box).getBytesPerFrame()) return null;
        LOG.logError("BytesPerFrame differ");
        audioSampleEntry.setBytesPerFrame(((AudioSampleEntry)iterator).getBytesPerFrame());
        if (((AudioSampleEntry)iterator).getBytesPerPacket() != ((AudioSampleEntry)box).getBytesPerPacket()) return null;
        audioSampleEntry.setBytesPerPacket(((AudioSampleEntry)iterator).getBytesPerPacket());
        if (((AudioSampleEntry)iterator).getBytesPerSample() != ((AudioSampleEntry)box).getBytesPerSample()) return null;
        LOG.logError("BytesPerSample differ");
        audioSampleEntry.setBytesPerSample(((AudioSampleEntry)iterator).getBytesPerSample());
        if (((AudioSampleEntry)iterator).getChannelCount() != ((AudioSampleEntry)box).getChannelCount()) return null;
        LOG.logError("ChannelCount differ");
        audioSampleEntry.setChannelCount(((AudioSampleEntry)iterator).getChannelCount());
        if (((AudioSampleEntry)iterator).getPacketSize() != ((AudioSampleEntry)box).getPacketSize()) return null;
        audioSampleEntry.setPacketSize(((AudioSampleEntry)iterator).getPacketSize());
        if (((AudioSampleEntry)iterator).getCompressionId() != ((AudioSampleEntry)box).getCompressionId()) return null;
        audioSampleEntry.setCompressionId(((AudioSampleEntry)iterator).getCompressionId());
        if (((AudioSampleEntry)iterator).getSampleRate() != ((AudioSampleEntry)box).getSampleRate()) return null;
        audioSampleEntry.setSampleRate(((AudioSampleEntry)iterator).getSampleRate());
        if (((AudioSampleEntry)iterator).getSampleSize() != ((AudioSampleEntry)box).getSampleSize()) return null;
        audioSampleEntry.setSampleSize(((AudioSampleEntry)iterator).getSampleSize());
        if (((AudioSampleEntry)iterator).getSamplesPerPacket() != ((AudioSampleEntry)box).getSamplesPerPacket()) return null;
        audioSampleEntry.setSamplesPerPacket(((AudioSampleEntry)iterator).getSamplesPerPacket());
        if (((AudioSampleEntry)iterator).getSoundVersion() != ((AudioSampleEntry)box).getSoundVersion()) return null;
        audioSampleEntry.setSoundVersion(((AudioSampleEntry)iterator).getSoundVersion());
        if (!Arrays.equals(((AudioSampleEntry)iterator).getSoundVersion2Data(), ((AudioSampleEntry)box).getSoundVersion2Data())) return null;
        audioSampleEntry.setSoundVersion2Data(((AudioSampleEntry)iterator).getSoundVersion2Data());
        if (((BasicContainer)iterator).getBoxes().size() != ((BasicContainer)((Object)box)).getBoxes().size()) return audioSampleEntry;
        iterator = ((BasicContainer)iterator).getBoxes().iterator();
        Iterator<Box> iterator2 = ((BasicContainer)((Object)box)).getBoxes().iterator();
        while (iterator.hasNext()) {
            box = iterator.next();
            Object object = iterator2.next();
            Object object2 = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                box.getBox(Channels.newChannel((OutputStream)object2));
                object.getBox(Channels.newChannel(byteArrayOutputStream));
            }
            catch (IOException iOException) {
                LOG.logWarn(iOException.getMessage());
                return null;
            }
            if (Arrays.equals(((ByteArrayOutputStream)object2).toByteArray(), byteArrayOutputStream.toByteArray())) {
                audioSampleEntry.addBox(box);
                continue;
            }
            if (!"esds".equals(box.getType()) || !"esds".equals(object.getType())) continue;
            object2 = (ESDescriptorBox)((Object)box);
            object = (ESDescriptorBox)((Object)object);
            ((AbstractDescriptorBox)((Object)object2)).setDescriptor((BaseDescriptor)this.mergeDescriptors((BaseDescriptor)((ESDescriptorBox)((Object)object2)).getEsDescriptor(), (BaseDescriptor)((ESDescriptorBox)((Object)object)).getEsDescriptor()));
            audioSampleEntry.addBox(box);
        }
        return audioSampleEntry;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ESDescriptor mergeDescriptors(BaseDescriptor baseDescriptor, BaseDescriptor baseDescriptor2) {
        if (baseDescriptor instanceof ESDescriptor && baseDescriptor2 instanceof ESDescriptor) {
            ESDescriptor eSDescriptor = (ESDescriptor)baseDescriptor;
            baseDescriptor2 = (ESDescriptor)baseDescriptor2;
            if (eSDescriptor.getURLFlag() != baseDescriptor2.getURLFlag()) {
                return null;
            }
            eSDescriptor.getURLLength();
            baseDescriptor2.getURLLength();
            if (eSDescriptor.getDependsOnEsId() != baseDescriptor2.getDependsOnEsId()) {
                return null;
            }
            if (eSDescriptor.getEsId() != baseDescriptor2.getEsId()) {
                return null;
            }
            if (eSDescriptor.getoCREsId() != baseDescriptor2.getoCREsId()) {
                return null;
            }
            if (eSDescriptor.getoCRstreamFlag() != baseDescriptor2.getoCRstreamFlag()) {
                return null;
            }
            if (eSDescriptor.getRemoteODFlag() != baseDescriptor2.getRemoteODFlag()) {
                return null;
            }
            if (eSDescriptor.getStreamDependenceFlag() != baseDescriptor2.getStreamDependenceFlag()) {
                return null;
            }
            eSDescriptor.getStreamPriority();
            baseDescriptor2.getStreamPriority();
            if (eSDescriptor.getURLString() != null) {
                eSDescriptor.getURLString().equals(baseDescriptor2.getURLString());
            } else {
                baseDescriptor2.getURLString();
            }
            if (eSDescriptor.getDecoderConfigDescriptor() != null ? !eSDescriptor.getDecoderConfigDescriptor().equals(baseDescriptor2.getDecoderConfigDescriptor()) : baseDescriptor2.getDecoderConfigDescriptor() != null) {
                baseDescriptor = eSDescriptor.getDecoderConfigDescriptor();
                DecoderConfigDescriptor decoderConfigDescriptor = baseDescriptor2.getDecoderConfigDescriptor();
                if (baseDescriptor.getAudioSpecificInfo() != null && decoderConfigDescriptor.getAudioSpecificInfo() != null && !baseDescriptor.getAudioSpecificInfo().equals((Object)decoderConfigDescriptor.getAudioSpecificInfo())) {
                    return null;
                }
                if (baseDescriptor.getAvgBitRate() != decoderConfigDescriptor.getAvgBitRate()) {
                    baseDescriptor.setAvgBitRate((baseDescriptor.getAvgBitRate() + decoderConfigDescriptor.getAvgBitRate()) / 2L);
                }
                baseDescriptor.getBufferSizeDB();
                decoderConfigDescriptor.getBufferSizeDB();
                if (baseDescriptor.getDecoderSpecificInfo() != null ? !baseDescriptor.getDecoderSpecificInfo().equals((Object)decoderConfigDescriptor.getDecoderSpecificInfo()) : decoderConfigDescriptor.getDecoderSpecificInfo() != null) {
                    return null;
                }
                if (baseDescriptor.getMaxBitRate() != decoderConfigDescriptor.getMaxBitRate()) {
                    baseDescriptor.setMaxBitRate(Math.max(baseDescriptor.getMaxBitRate(), decoderConfigDescriptor.getMaxBitRate()));
                }
                if (!baseDescriptor.getProfileLevelIndicationDescriptors().equals(decoderConfigDescriptor.getProfileLevelIndicationDescriptors())) {
                    return null;
                }
                if (baseDescriptor.getObjectTypeIndication() != decoderConfigDescriptor.getObjectTypeIndication()) {
                    return null;
                }
                if (baseDescriptor.getStreamType() != decoderConfigDescriptor.getStreamType()) {
                    return null;
                }
                if (baseDescriptor.getUpStream() != decoderConfigDescriptor.getUpStream()) {
                    return null;
                }
            }
            if (eSDescriptor.getOtherDescriptors() != null ? !eSDescriptor.getOtherDescriptors().equals(baseDescriptor2.getOtherDescriptors()) : baseDescriptor2.getOtherDescriptors() != null) {
                return null;
            }
            if (eSDescriptor.getSlConfigDescriptor() != null) {
                baseDescriptor = eSDescriptor;
                if (eSDescriptor.getSlConfigDescriptor().equals((Object)baseDescriptor2.getSlConfigDescriptor())) return baseDescriptor;
                return null;
            } else {
                baseDescriptor = eSDescriptor;
                if (baseDescriptor2.getSlConfigDescriptor() == null) return baseDescriptor;
            }
            return null;
        }
        LOG.logError("I can only merge ESDescriptors");
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private SampleEntry mergeSampleEntry(SampleEntry sampleEntry, SampleEntry sampleEntry2) {
        void var4_5;
        Object var3_3 = null;
        if (!sampleEntry.getType().equals(sampleEntry2.getType())) {
            Object var4_4 = var3_3;
            return var4_5;
        }
        if (sampleEntry instanceof VisualSampleEntry && sampleEntry2 instanceof VisualSampleEntry) {
            VisualSampleEntry visualSampleEntry = this.mergeVisualSampleEntry((VisualSampleEntry)sampleEntry, (VisualSampleEntry)sampleEntry2);
            return var4_5;
        }
        Object var4_7 = var3_3;
        if (!(sampleEntry instanceof AudioSampleEntry)) return var4_5;
        Object var4_8 = var3_3;
        if (!(sampleEntry2 instanceof AudioSampleEntry)) return var4_5;
        AudioSampleEntry audioSampleEntry = this.mergeAudioSampleEntries((AudioSampleEntry)sampleEntry, (AudioSampleEntry)sampleEntry2);
        return var4_5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SampleDescriptionBox mergeStsds(SampleDescriptionBox sampleDescriptionBox, SampleDescriptionBox sampleDescriptionBox2) throws IOException {
        byte[] byArray;
        Object object = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            sampleDescriptionBox.getBox(Channels.newChannel((OutputStream)object));
            sampleDescriptionBox2.getBox(Channels.newChannel(byteArrayOutputStream));
            byArray = ((ByteArrayOutputStream)object).toByteArray();
            object = sampleDescriptionBox;
        }
        catch (IOException iOException) {
            LOG.logError(iOException.getMessage());
            return null;
        }
        if (Arrays.equals(byteArrayOutputStream.toByteArray(), byArray)) return object;
        object = this.mergeSampleEntry(sampleDescriptionBox.getBoxes(SampleEntry.class).get(0), sampleDescriptionBox2.getBoxes(SampleEntry.class).get(0));
        if (object == null) throw new IOException("Cannot merge " + sampleDescriptionBox.getBoxes(SampleEntry.class).get(0) + " and " + sampleDescriptionBox2.getBoxes(SampleEntry.class).get(0));
        sampleDescriptionBox.setBoxes(Collections.singletonList(object));
        return sampleDescriptionBox;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VisualSampleEntry mergeVisualSampleEntry(VisualSampleEntry iterator, VisualSampleEntry box) {
        VisualSampleEntry visualSampleEntry = new VisualSampleEntry();
        if (((VisualSampleEntry)iterator).getHorizresolution() != ((VisualSampleEntry)box).getHorizresolution()) {
            LOG.logError("Horizontal Resolution differs");
            return null;
        }
        visualSampleEntry.setHorizresolution(((VisualSampleEntry)iterator).getHorizresolution());
        visualSampleEntry.setCompressorname(((VisualSampleEntry)iterator).getCompressorname());
        if (((VisualSampleEntry)iterator).getDepth() != ((VisualSampleEntry)box).getDepth()) {
            LOG.logError("Depth differs");
            return null;
        }
        visualSampleEntry.setDepth(((VisualSampleEntry)iterator).getDepth());
        if (((VisualSampleEntry)iterator).getFrameCount() != ((VisualSampleEntry)box).getFrameCount()) {
            LOG.logError("frame count differs");
            return null;
        }
        visualSampleEntry.setFrameCount(((VisualSampleEntry)iterator).getFrameCount());
        if (((VisualSampleEntry)iterator).getHeight() != ((VisualSampleEntry)box).getHeight()) {
            LOG.logError("height differs");
            return null;
        }
        visualSampleEntry.setHeight(((VisualSampleEntry)iterator).getHeight());
        if (((VisualSampleEntry)iterator).getWidth() != ((VisualSampleEntry)box).getWidth()) {
            LOG.logError("width differs");
            return null;
        }
        visualSampleEntry.setWidth(((VisualSampleEntry)iterator).getWidth());
        if (((VisualSampleEntry)iterator).getVertresolution() != ((VisualSampleEntry)box).getVertresolution()) {
            LOG.logError("vert resolution differs");
            return null;
        }
        visualSampleEntry.setVertresolution(((VisualSampleEntry)iterator).getVertresolution());
        if (((VisualSampleEntry)iterator).getHorizresolution() != ((VisualSampleEntry)box).getHorizresolution()) {
            LOG.logError("horizontal resolution differs");
            return null;
        }
        visualSampleEntry.setHorizresolution(((VisualSampleEntry)iterator).getHorizresolution());
        if (((BasicContainer)iterator).getBoxes().size() != ((BasicContainer)((Object)box)).getBoxes().size()) return visualSampleEntry;
        iterator = ((BasicContainer)iterator).getBoxes().iterator();
        Iterator<Box> iterator2 = ((BasicContainer)((Object)box)).getBoxes().iterator();
        while (iterator.hasNext()) {
            box = iterator.next();
            Box box2 = iterator2.next();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            try {
                box.getBox(Channels.newChannel(byteArrayOutputStream));
                box2.getBox(Channels.newChannel(byteArrayOutputStream2));
            }
            catch (IOException iOException) {
                LOG.logWarn(iOException.getMessage());
                return null;
            }
            if (Arrays.equals(byteArrayOutputStream.toByteArray(), byteArrayOutputStream2.toByteArray())) {
                visualSampleEntry.addBox(box);
                continue;
            }
            if (!(box instanceof AbstractDescriptorBox) || !(box2 instanceof AbstractDescriptorBox)) continue;
            box2 = this.mergeDescriptors(((AbstractDescriptorBox)((Object)box)).getDescriptor(), ((AbstractDescriptorBox)((Object)box2)).getDescriptor());
            ((AbstractDescriptorBox)((Object)box)).setDescriptor((BaseDescriptor)box2);
            visualSampleEntry.addBox(box);
        }
        return visualSampleEntry;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        if (this.tracks[0].getCompositionTimeEntries() == null) return null;
        if (this.tracks[0].getCompositionTimeEntries().isEmpty()) return null;
        Object object = new LinkedList<int[]>();
        Object object2 = this.tracks;
        int n2 = ((Track[])object2).length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) break;
            object.add(CompositionTimeToSample.blowupCompositionTimes(object2[n3].getCompositionTimeEntries()));
            ++n3;
        }
        object2 = new LinkedList();
        Iterator iterator = object.iterator();
        block1: while (iterator.hasNext()) {
            int[] nArray = (int[])iterator.next();
            n2 = nArray.length;
            n3 = 0;
            while (true) {
                if (n3 >= n2) continue block1;
                int n4 = nArray[n3];
                if (((AbstractCollection)object2).isEmpty() || ((CompositionTimeToSample.Entry)((LinkedList)object2).getLast()).getOffset() != n4) {
                    ((LinkedList)object2).add(new CompositionTimeToSample.Entry(1, n4));
                } else {
                    object = (CompositionTimeToSample.Entry)((LinkedList)object2).getLast();
                    ((CompositionTimeToSample.Entry)object).setCount(((CompositionTimeToSample.Entry)object).getCount() + 1);
                }
                ++n3;
            }
            break;
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        if (this.tracks[0].getDecodingTimeEntries() == null) return null;
        if (this.tracks[0].getDecodingTimeEntries().isEmpty()) return null;
        Object object = new LinkedList<long[]>();
        Object object2 = this.tracks;
        int n2 = ((Track[])object2).length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) break;
            object.add(TimeToSampleBox.blowupTimeToSamples(object2[n3].getDecodingTimeEntries()));
            ++n3;
        }
        object2 = new LinkedList();
        Iterator iterator = object.iterator();
        block1: while (iterator.hasNext()) {
            long[] lArray = (long[])iterator.next();
            n2 = lArray.length;
            n3 = 0;
            while (true) {
                if (n3 >= n2) continue block1;
                long l2 = lArray[n3];
                if (((AbstractCollection)object2).isEmpty() || ((TimeToSampleBox.Entry)((LinkedList)object2).getLast()).getDelta() != l2) {
                    ((LinkedList)object2).add(new TimeToSampleBox.Entry(1L, l2));
                } else {
                    object = (TimeToSampleBox.Entry)((LinkedList)object2).getLast();
                    ((TimeToSampleBox.Entry)object).setCount(((TimeToSampleBox.Entry)object).getCount() + 1L);
                }
                ++n3;
            }
            break;
        }
        return object2;
    }

    @Override
    public String getHandler() {
        return this.tracks[0].getHandler();
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.tracks[0].getMediaHeaderBox();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        int n2 = 0;
        if (this.tracks[0].getSampleDependencies() == null) return null;
        if (this.tracks[0].getSampleDependencies().isEmpty()) return null;
        LinkedList<SampleDependencyTypeBox.Entry> linkedList = new LinkedList<SampleDependencyTypeBox.Entry>();
        Track[] trackArray = this.tracks;
        int n3 = trackArray.length;
        while (n2 < n3) {
            linkedList.addAll(trackArray[n2].getSampleDependencies());
            ++n2;
        }
        return linkedList;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.stsd;
    }

    @Override
    public List<Sample> getSamples() {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        Track[] trackArray = this.tracks;
        int n2 = trackArray.length;
        int n3 = 0;
        while (n3 < n2) {
            arrayList.addAll(trackArray[n3].getSamples());
            ++n3;
        }
        return arrayList;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.tracks[0].getSubsampleInformationBox();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public long[] getSyncSamples() {
        void var2_4;
        if (this.tracks[0].getSyncSamples() == null || this.tracks[0].getSyncSamples().length <= 0) {
            Object var2_5 = null;
            return var2_4;
        }
        int n2 = 0;
        Track[] trackArray = this.tracks;
        int n3 = trackArray.length;
        int n4 = 0;
        while (true) {
            if (n4 >= n3) break;
            n2 += trackArray[n4].getSyncSamples().length;
            ++n4;
        }
        long[] lArray = new long[n2];
        Track[] trackArray2 = this.tracks;
        int n5 = trackArray2.length;
        long l2 = 0L;
        n2 = 0;
        n4 = 0;
        block1: while (n4 < n5) {
            Track track = trackArray2[n4];
            long[] lArray2 = track.getSyncSamples();
            int n6 = lArray2.length;
            n3 = 0;
            while (true) {
                if (n3 >= n6) {
                    l2 += (long)track.getSamples().size();
                    ++n4;
                    continue block1;
                }
                lArray[n2] = lArray2[n3] + l2;
                ++n3;
                ++n2;
            }
            break;
        }
        return var2_4;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.tracks[0].getTrackMetaData();
    }
}

