/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.coremedia.iso.boxes.h264.AvcConfigurationBox;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.h264.model.PictureParameterSet;
import com.googlecode.mp4parser.h264.model.SeqParameterSet;
import com.googlecode.mp4parser.h264.read.CAVLCReader;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class H264TrackImpl
extends AbstractTrack {
    private static final Logger LOG = Logger.getLogger(H264TrackImpl.class.getName());
    List<CompositionTimeToSample.Entry> ctts;
    private int currentScSize;
    private boolean determineFrameRate = true;
    int frameNrInGop = 0;
    private int frametick;
    private int height;
    private String lang = "eng";
    PictureParameterSet pictureParameterSet = null;
    LinkedList<byte[]> pictureParameterSetList;
    private int prevScSize;
    boolean readSamples = false;
    private ReaderWrapper reader;
    SampleDescriptionBox sampleDescriptionBox;
    private List<Sample> samples;
    List<SampleDependencyTypeBox.Entry> sdtp;
    private SEIMessage seiMessage;
    SeqParameterSet seqParameterSet = null;
    LinkedList<byte[]> seqParameterSetList;
    List<Integer> stss;
    List<TimeToSampleBox.Entry> stts;
    private long timescale;
    TrackMetaData trackMetaData = new TrackMetaData();
    private int width;

    public H264TrackImpl(DataSource dataSource) throws IOException {
        this.seqParameterSetList = new LinkedList();
        this.pictureParameterSetList = new LinkedList();
        this.parse(dataSource);
    }

    public H264TrackImpl(DataSource dataSource, String string2) throws IOException {
        this.seqParameterSetList = new LinkedList();
        this.pictureParameterSetList = new LinkedList();
        this.lang = string2;
        this.parse(dataSource);
    }

    public H264TrackImpl(DataSource dataSource, String string2, long l2, int n2) throws IOException {
        this.seqParameterSetList = new LinkedList();
        this.pictureParameterSetList = new LinkedList();
        this.lang = string2;
        this.timescale = l2;
        this.frametick = n2;
        if (l2 > 0L && n2 > 0) {
            this.determineFrameRate = false;
        }
        this.parse(dataSource);
    }

    static /* synthetic */ Logger access$1() {
        return LOG;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureFramerate() {
        block6: {
            block5: {
                if (!this.determineFrameRate) break block5;
                if (this.seqParameterSet.vuiParams == null) break block6;
                this.timescale = this.seqParameterSet.vuiParams.time_scale >> 1;
                this.frametick = this.seqParameterSet.vuiParams.num_units_in_tick;
                if (this.timescale == 0L || this.frametick == 0) {
                    System.err.println("Warning: vuiParams contain invalid values: time_scale: " + this.timescale + " and frame_tick: " + this.frametick + ". Setting frame rate to 25fps");
                    this.timescale = 90000L;
                    this.frametick = 3600;
                }
            }
            return;
        }
        System.err.println("Warning: Can't determine frame rate. Guessing 25 fps");
        this.timescale = 90000L;
        this.frametick = 3600;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean findNextStartcode() throws IOException {
        boolean bl;
        block4: {
            byte[] byArray;
            bl = true;
            byte[] byArray2 = byArray = new byte[4];
            byArray[0] = -1;
            byArray2[1] = -1;
            byArray2[2] = -1;
            byArray2[3] = -1;
            do {
                if (!this.reader.hasRemaining()) {
                    if (byArray[0] == -1 && byArray[1] == -1 && byArray[2] == -1 && byArray[3] == -1) {
                        return false;
                    }
                    break block4;
                }
                byArray[0] = byArray[1];
                byArray[1] = byArray[2];
                byArray[2] = byArray[3];
                byArray[3] = (byte)this.reader.get();
                if (byArray[0] != 0 || byArray[1] != 0 || byArray[2] != 0 || byArray[3] != 1) continue;
                this.prevScSize = this.currentScSize;
                this.currentScSize = 4;
                return bl;
            } while (byArray[0] != 0 || byArray[1] != 0 || byArray[2] != 1);
            this.prevScSize = this.currentScSize;
            this.currentScSize = 3;
            return bl;
        }
        this.prevScSize = 0;
        this.currentScSize = 0;
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NALActions handleNALUnit(int n2, int n3, ByteBuffer object) throws IOException {
        void var3_5;
        switch (n3) {
            default: {
                System.err.println("Unknown NAL unit type: " + n3);
                NALActions nALActions = NALActions.IGNORE;
                return var3_5;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                NALActions nALActions = NALActions.STORE;
                return var3_5;
            }
            case 6: {
                this.seiMessage = new SEIMessage(this, this.cleanBuffer(new ByteBufferBackedInputStream((ByteBuffer)object)), this.seqParameterSet);
                NALActions nALActions = NALActions.BUFFER;
                return var3_5;
            }
            case 9: {
                n2 = ((ByteBuffer)object).get(((Buffer)object).position() + 1);
                LOG.fine("Access unit delimiter type: " + (n2 >> 5));
                NALActions nALActions = NALActions.BUFFER;
                return var3_5;
            }
            case 7: {
                if (this.seqParameterSet == null) {
                    InputStream inputStream = this.cleanBuffer(new ByteBufferBackedInputStream((ByteBuffer)object));
                    inputStream.read();
                    this.seqParameterSet = SeqParameterSet.read(inputStream);
                    this.seqParameterSetList.add(H264TrackImpl.toArray((ByteBuffer)object));
                    this.configureFramerate();
                }
                NALActions nALActions = NALActions.IGNORE;
                return var3_5;
            }
            case 8: {
                if (this.pictureParameterSet == null) {
                    ByteBufferBackedInputStream byteBufferBackedInputStream = new ByteBufferBackedInputStream((ByteBuffer)object);
                    ((InputStream)byteBufferBackedInputStream).read();
                    this.pictureParameterSet = PictureParameterSet.read(byteBufferBackedInputStream);
                    this.pictureParameterSetList.add(H264TrackImpl.toArray((ByteBuffer)object));
                }
                NALActions nALActions = NALActions.IGNORE;
                return var3_5;
            }
            case 10: 
            case 11: 
        }
        NALActions nALActions = NALActions.END;
        return var3_5;
    }

    private void parse(DataSource object) throws IOException {
        this.reader = new ReaderWrapper((DataSource)object);
        this.stts = new LinkedList<TimeToSampleBox.Entry>();
        this.ctts = new LinkedList<CompositionTimeToSample.Entry>();
        this.sdtp = new LinkedList<SampleDependencyTypeBox.Entry>();
        this.stss = new LinkedList<Integer>();
        this.samples = new LinkedList<Sample>();
        if (!this.readSamples()) {
            throw new IOException();
        }
        if (!this.readVariables()) {
            throw new IOException();
        }
        this.sampleDescriptionBox = new SampleDescriptionBox();
        object = new VisualSampleEntry("avc1");
        ((AbstractSampleEntry)object).setDataReferenceIndex(1);
        ((VisualSampleEntry)object).setDepth(24);
        ((VisualSampleEntry)object).setFrameCount(1);
        ((VisualSampleEntry)object).setHorizresolution(72.0);
        ((VisualSampleEntry)object).setVertresolution(72.0);
        ((VisualSampleEntry)object).setWidth(this.width);
        ((VisualSampleEntry)object).setHeight(this.height);
        ((VisualSampleEntry)object).setCompressorname("AVC Coding");
        AvcConfigurationBox avcConfigurationBox = new AvcConfigurationBox();
        avcConfigurationBox.setSequenceParameterSets(this.seqParameterSetList);
        avcConfigurationBox.setPictureParameterSets(this.pictureParameterSetList);
        avcConfigurationBox.setAvcLevelIndication(this.seqParameterSet.level_idc);
        avcConfigurationBox.setAvcProfileIndication(this.seqParameterSet.profile_idc);
        avcConfigurationBox.setBitDepthLumaMinus8(this.seqParameterSet.bit_depth_luma_minus8);
        avcConfigurationBox.setBitDepthChromaMinus8(this.seqParameterSet.bit_depth_chroma_minus8);
        avcConfigurationBox.setChromaFormat(this.seqParameterSet.chroma_format_idc.getId());
        avcConfigurationBox.setConfigurationVersion(1);
        avcConfigurationBox.setLengthSizeMinusOne(3);
        avcConfigurationBox.setProfileCompatibility(this.seqParameterSetList.get(0)[1]);
        ((BasicContainer)object).addBox((Box)((Object)avcConfigurationBox));
        this.sampleDescriptionBox.addBox((Box)object);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage(this.lang);
        this.trackMetaData.setTimescale(this.timescale);
        this.trackMetaData.setWidth(this.width);
        this.trackMetaData.setHeight(this.height);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readSamples() throws IOException {
        if (this.readSamples) {
            return true;
        }
        this.readSamples = true;
        this.findNextStartcode();
        this.reader.mark();
        long l2 = this.reader.getPos();
        Object object = new ArrayList<ByteBuffer>();
        int n2 = 0;
        while (this.findNextStartcode()) {
            long l3 = this.reader.getPos();
            int n3 = (int)(l3 - l2 - (long)this.prevScSize);
            this.reader.reset();
            ByteBuffer byteBuffer = this.reader.map(n3);
            n3 = byteBuffer.get(byteBuffer.position());
            int n4 = n3 & 0x1F;
            NALActions nALActions = this.handleNALUnit(n3 >> 5 & 3, n4, byteBuffer);
            n3 = n2;
            ArrayList<ByteBuffer> arrayList = object;
            switch (nALActions) {
                case END: {
                    return true;
                }
                default: {
                    arrayList = object;
                    n3 = n2;
                    break;
                }
                case BUFFER: {
                    object.add(byteBuffer);
                    n3 = n2;
                    arrayList = object;
                }
                case IGNORE: {
                    break;
                }
                case STORE: {
                    boolean bl;
                    int n5 = n2 + 1;
                    object.add(byteBuffer);
                    if (n4 == 5) {
                        bl = true;
                        n2 = 38;
                    } else {
                        n2 = 22;
                        bl = false;
                    }
                    n3 = n2;
                    if (new SliceHeader((InputStream)this.cleanBuffer((InputStream)(H264TrackImpl)this.new ByteBufferBackedInputStream((ByteBuffer)((ByteBuffer)object.get((int)(object.size() - 1))))), (SeqParameterSet)this.seqParameterSet, (PictureParameterSet)this.pictureParameterSet, (boolean)bl).slice_type == SliceHeader.SliceType.B) {
                        n3 = n2 + 4;
                    }
                    object = this.createSample((List<? extends ByteBuffer>)object);
                    arrayList = new ArrayList();
                    this.samples.add((Sample)object);
                    this.stts.add(new TimeToSampleBox.Entry(1L, this.frametick));
                    if (n4 == 5) {
                        this.stss.add(n5);
                    }
                    if (this.seiMessage == null || this.seiMessage.n_frames == 0) {
                        this.frameNrInGop = 0;
                    }
                    n2 = this.seiMessage != null && this.seiMessage.clock_timestamp_flag ? this.seiMessage.n_frames - this.frameNrInGop : (this.seiMessage != null && this.seiMessage.removal_delay_flag ? this.seiMessage.dpb_removal_delay / 2 : 0);
                    this.ctts.add(new CompositionTimeToSample.Entry(1, n2 * this.frametick));
                    this.sdtp.add(new SampleDependencyTypeBox.Entry(n3));
                    ++this.frameNrInGop;
                    n3 = n5;
                }
            }
            this.reader.seek(this.currentScSize);
            this.reader.mark();
            l2 = l3;
            n2 = n3;
            object = arrayList;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readVariables() {
        this.width = (this.seqParameterSet.pic_width_in_mbs_minus1 + 1) * 16;
        int n2 = 2;
        if (this.seqParameterSet.frame_mbs_only_flag) {
            n2 = 1;
        }
        this.height = (this.seqParameterSet.pic_height_in_map_units_minus1 + 1) * 16 * n2;
        if (this.seqParameterSet.frame_cropping_flag) {
            int n3 = 0;
            if (!this.seqParameterSet.residual_color_transform_flag) {
                n3 = this.seqParameterSet.chroma_format_idc.getId();
            }
            if (n3 != 0) {
                n3 = this.seqParameterSet.chroma_format_idc.getSubWidth();
                n2 *= this.seqParameterSet.chroma_format_idc.getSubHeight();
            } else {
                n3 = 1;
            }
            this.width -= n3 * (this.seqParameterSet.frame_crop_left_offset + this.seqParameterSet.frame_crop_right_offset);
            this.height -= n2 * (this.seqParameterSet.frame_crop_top_offset + this.seqParameterSet.frame_crop_bottom_offset);
        }
        return true;
    }

    static byte[] toArray(ByteBuffer object) {
        ByteBuffer byteBuffer = ((ByteBuffer)object).duplicate();
        object = new byte[byteBuffer.remaining()];
        byteBuffer.get((byte[])object, 0, ((Object)object).length);
        return object;
    }

    protected InputStream cleanBuffer(InputStream inputStream) {
        return new CleanInputStream(inputStream);
    }

    protected InputStream cleanBuffer(byte[] byArray) {
        return this.cleanBuffer(new ByteArrayInputStream(byArray));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Sample createSample(List<? extends ByteBuffer> list) {
        byte[] byArray = new byte[list.size() * 4];
        ByteBuffer[] byteBufferArray = ByteBuffer.wrap(byArray);
        Iterator<? extends ByteBuffer> iterator = list.iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            byteBufferArray.putInt(iterator.next().remaining());
        }
        byteBufferArray = new ByteBuffer[list.size() * 2];
        int n2 = 0;
        while (n2 < list.size()) {
            byteBufferArray[n2 * 2] = ByteBuffer.wrap(byArray, n2 * 4, 4);
            byteBufferArray[n2 * 2 + 1] = list.get(n2);
            ++n2;
        }
        return new SampleImpl(byteBufferArray);
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.ctts;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.stts;
    }

    @Override
    public String getHandler() {
        return "vide";
    }

    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return new VideoMediaHeaderBox();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.sdtp;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        long[] lArray = new long[this.stss.size()];
        int n2 = 0;
        while (n2 < this.stss.size()) {
            lArray[n2] = this.stss.get(n2).intValue();
            ++n2;
        }
        return lArray;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    public void printAccessUnitDelimiter(byte[] byArray) {
        LOG.fine("Access unit delimiter: " + (byArray[1] >> 5));
    }

    public class ByteBufferBackedInputStream
    extends InputStream {
        private final ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer byteBuffer) {
            this.buf = byteBuffer.duplicate();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read() throws IOException {
            if (this.buf.hasRemaining()) return this.buf.get() & 0xFF;
            return -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            n3 = Math.min(n3, this.buf.remaining());
            this.buf.get(byArray, n2, n3);
            return n3;
        }
    }

    protected class CleanInputStream
    extends FilterInputStream {
        int prev;
        int prevprev;

        CleanInputStream(InputStream inputStream) {
            super(inputStream);
            this.prevprev = -1;
            this.prev = -1;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            int n2;
            int n3 = n2 = super.read();
            if (n2 == 3) {
                n3 = n2;
                if (this.prevprev == 0) {
                    n3 = n2;
                    if (this.prev == 0) {
                        this.prevprev = -1;
                        this.prev = -1;
                        n3 = super.read();
                    }
                }
            }
            this.prevprev = this.prev;
            this.prev = n3;
            return n3;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = -1;
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n2 < 0) throw new IndexOutOfBoundsException();
            if (n3 < 0) throw new IndexOutOfBoundsException();
            if (n3 > byArray.length - n2) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return 0;
            }
            int n5 = this.read();
            if (n5 == -1) return n4;
            byArray[n2] = (byte)n5;
            n4 = 1;
            while (n4 < n3) {
                try {
                    n5 = this.read();
                    if (n5 == -1) return n4;
                }
                catch (IOException iOException) {
                    return n4;
                }
                byArray[n2 + n4] = (byte)n5;
                ++n4;
            }
            return n4;
        }
    }

    private static enum NALActions {
        IGNORE,
        BUFFER,
        STORE,
        END;

    }

    private class ReaderWrapper {
        final ByteBuffer buffer;

        private ReaderWrapper(DataSource dataSource) throws IOException {
            this.buffer = dataSource.map(dataSource.position(), dataSource.size() - dataSource.position());
        }

        int get() throws IOException {
            return this.buffer.get();
        }

        public long getPos() throws IOException {
            return this.buffer.position();
        }

        boolean hasRemaining() {
            return this.buffer.hasRemaining();
        }

        ByteBuffer map(int n2) throws IOException {
            ByteBuffer byteBuffer = this.buffer.duplicate();
            byteBuffer.position(this.buffer.position());
            byteBuffer.limit(byteBuffer.position() + n2);
            this.buffer.position(this.buffer.position() + n2);
            return byteBuffer;
        }

        public void mark() throws IOException {
            this.buffer.mark();
        }

        public void reset() throws IOException {
            this.buffer.reset();
        }

        void seek(int n2) throws IOException {
            this.buffer.position(this.buffer.position() + n2);
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    public class SEIMessage {
        boolean clock_timestamp_flag;
        int cnt_dropped_flag;
        int counting_type;
        int cpb_removal_delay;
        int ct_type;
        int discontinuity_flag;
        int dpb_removal_delay;
        int full_timestamp_flag;
        int hours_value;
        int minutes_value;
        int n_frames;
        int nuit_field_based_flag;
        int payloadSize;
        int payloadType;
        int pic_struct;
        boolean removal_delay_flag;
        int seconds_value;
        SeqParameterSet sps;
        final /* synthetic */ H264TrackImpl this$0;
        int time_offset;
        int time_offset_length;

        /*
         * Unable to fully structure code
         */
        public SEIMessage(H264TrackImpl var1_1, InputStream var2_2, SeqParameterSet var3_3) throws IOException {
            block16: {
                block17: {
                    block18: {
                        block21: {
                            block20: {
                                block19: {
                                    this.this$0 = var1_1;
                                    super();
                                    this.payloadType = 0;
                                    this.payloadSize = 0;
                                    this.sps = var3_3;
                                    var2_2.read();
                                    var4_4 = var2_2.available();
                                    var5_5 = 0;
                                    block4: while (true) {
                                        if (var5_5 >= var4_4) {
                                            return;
                                        }
                                        this.payloadType = 0;
                                        this.payloadSize = 0;
                                        var6_6 = var2_2.read();
                                        ++var5_5;
                                        block5: while (true) {
                                            if (var6_6 == 255) ** GOTO lbl52
                                            this.payloadType = var6_6 + this.payloadType;
                                            var6_6 = var2_2.read();
                                            ++var5_5;
                                            block6: while (true) {
                                                if (var6_6 == 255) ** GOTO lbl56
                                                this.payloadSize = var6_6 + this.payloadSize;
                                                if (var4_4 - var5_5 < this.payloadSize) break block16;
                                                if (this.payloadType != 1) break block17;
                                                if (var3_3.vuiParams == null || var3_3.vuiParams.nalHRDParams == null && var3_3.vuiParams.vclHRDParams == null && !var3_3.vuiParams.pic_struct_present_flag) break block18;
                                                var1_1 = new byte[this.payloadSize];
                                                var2_2.read((byte[])var1_1);
                                                var7_7 = var5_5 + this.payloadSize;
                                                var1_1 = new CAVLCReader(new ByteArrayInputStream((byte[])var1_1));
                                                if (var3_3.vuiParams.nalHRDParams == null && var3_3.vuiParams.vclHRDParams == null) ** GOTO lbl60
                                                this.removal_delay_flag = true;
                                                this.cpb_removal_delay = var1_1.readU(var3_3.vuiParams.nalHRDParams.cpb_removal_delay_length_minus1 + 1, "SEI: cpb_removal_delay");
                                                this.dpb_removal_delay = var1_1.readU(var3_3.vuiParams.nalHRDParams.dpb_output_delay_length_minus1 + 1, "SEI: dpb_removal_delay");
                                                block7: while (true) {
                                                    var5_5 = var7_7;
                                                    if (!var3_3.vuiParams.pic_struct_present_flag) ** GOTO lbl49
                                                    this.pic_struct = var1_1.readU(4, "SEI: pic_struct");
                                                    switch (this.pic_struct) {
                                                        default: {
                                                            var5_5 = 1;
lbl44:
                                                            // 3 sources

                                                            while (true) {
                                                                var6_6 = 0;
lbl46:
                                                                // 2 sources

                                                                while (true) {
                                                                    if (var6_6 < var5_5) break block4;
                                                                    var5_5 = var7_7;
lbl49:
                                                                    // 5 sources

                                                                    while (true) {
                                                                        H264TrackImpl.access$1().fine(this.toString());
                                                                        continue block4;
                                                                        break;
                                                                    }
                                                                    break;
                                                                }
                                                                break;
                                                            }
                                                        }
lbl52:
                                                        // 1 sources

                                                        this.payloadType = var6_6 + this.payloadType;
                                                        var6_6 = var2_2.read();
                                                        ++var5_5;
                                                        continue block5;
lbl56:
                                                        // 1 sources

                                                        this.payloadSize = var6_6 + this.payloadSize;
                                                        var6_6 = var2_2.read();
                                                        ++var5_5;
                                                        continue block6;
lbl60:
                                                        // 1 sources

                                                        this.removal_delay_flag = false;
                                                        continue block7;
                                                        case 3: 
                                                        case 4: 
                                                        case 7: {
                                                            var5_5 = 2;
                                                            ** GOTO lbl44
                                                        }
                                                        case 5: 
                                                        case 6: 
                                                        case 8: {
                                                            var5_5 = 3;
                                                            ** continue;
                                                        }
                                                    }
                                                    break;
                                                }
                                                break;
                                            }
                                            break;
                                        }
                                        break;
                                    }
                                    this.clock_timestamp_flag = var1_1.readBool("pic_timing SEI: clock_timestamp_flag[" + var6_6 + "]");
                                    if (!this.clock_timestamp_flag) ** GOTO lbl85
                                    this.ct_type = var1_1.readU(2, "pic_timing SEI: ct_type");
                                    this.nuit_field_based_flag = var1_1.readU(1, "pic_timing SEI: nuit_field_based_flag");
                                    this.counting_type = var1_1.readU(5, "pic_timing SEI: counting_type");
                                    this.full_timestamp_flag = var1_1.readU(1, "pic_timing SEI: full_timestamp_flag");
                                    this.discontinuity_flag = var1_1.readU(1, "pic_timing SEI: discontinuity_flag");
                                    this.cnt_dropped_flag = var1_1.readU(1, "pic_timing SEI: cnt_dropped_flag");
                                    this.n_frames = var1_1.readU(8, "pic_timing SEI: n_frames");
                                    if (this.full_timestamp_flag != 1) break block19;
                                    this.seconds_value = var1_1.readU(6, "pic_timing SEI: seconds_value");
                                    this.minutes_value = var1_1.readU(6, "pic_timing SEI: minutes_value");
                                    this.hours_value = var1_1.readU(5, "pic_timing SEI: hours_value");
lbl81:
                                    // 5 sources

                                    while (var3_3.vuiParams.nalHRDParams != null) {
                                        this.time_offset_length = var3_3.vuiParams.nalHRDParams.time_offset_length;
lbl83:
                                        // 3 sources

                                        while (true) {
                                            this.time_offset = var1_1.readU(24, "pic_timing SEI: time_offset");
lbl85:
                                            // 2 sources

                                            ++var6_6;
                                            ** continue;
                                            break;
                                        }
lbl87:
                                        // 1 sources

                                        ** GOTO lbl46
                                    }
                                    break block20;
                                }
                                if (!var1_1.readBool("pic_timing SEI: seconds_flag")) ** GOTO lbl81
                                this.seconds_value = var1_1.readU(6, "pic_timing SEI: seconds_value");
                                if (!var1_1.readBool("pic_timing SEI: minutes_flag")) ** GOTO lbl81
                                this.minutes_value = var1_1.readU(6, "pic_timing SEI: minutes_value");
                                if (!var1_1.readBool("pic_timing SEI: hours_flag")) ** GOTO lbl81
                                this.hours_value = var1_1.readU(5, "pic_timing SEI: hours_value");
                                ** GOTO lbl81
                            }
                            if (var3_3.vuiParams.vclHRDParams == null) break block21;
                            this.time_offset_length = var3_3.vuiParams.vclHRDParams.time_offset_length;
                            ** GOTO lbl83
                        }
                        this.time_offset_length = 24;
                        ** while (true)
                    }
                    var7_7 = 0;
                    var6_6 = var5_5;
                    while (true) {
                        var5_5 = var6_6++;
                        if (var7_7 >= this.payloadSize) ** GOTO lbl49
                        var2_2.read();
                        ++var7_7;
                    }
                }
                var7_7 = 0;
                var6_6 = var5_5;
                while (true) {
                    var5_5 = var6_6++;
                    if (var7_7 >= this.payloadSize) ** GOTO lbl49
                    var2_2.read();
                    ++var7_7;
                }
            }
            var5_5 = var4_4;
            ** while (true)
        }

        public String toString() {
            String string2;
            block5: {
                String string3;
                block7: {
                    String string4;
                    block6: {
                        string2 = string4 = "SEIMessage{payloadType=" + this.payloadType + ", payloadSize=" + this.payloadSize;
                        if (this.payloadType != 1) break block5;
                        if (this.sps.vuiParams.nalHRDParams != null) break block6;
                        string3 = string4;
                        if (this.sps.vuiParams.vclHRDParams == null) break block7;
                    }
                    string3 = String.valueOf(string4) + ", cpb_removal_delay=" + this.cpb_removal_delay + ", dpb_removal_delay=" + this.dpb_removal_delay;
                }
                string2 = string3;
                if (this.sps.vuiParams.pic_struct_present_flag) {
                    string2 = string3 = String.valueOf(string3) + ", pic_struct=" + this.pic_struct;
                    if (this.clock_timestamp_flag) {
                        string2 = String.valueOf(string3) + ", ct_type=" + this.ct_type + ", nuit_field_based_flag=" + this.nuit_field_based_flag + ", counting_type=" + this.counting_type + ", full_timestamp_flag=" + this.full_timestamp_flag + ", discontinuity_flag=" + this.discontinuity_flag + ", cnt_dropped_flag=" + this.cnt_dropped_flag + ", n_frames=" + this.n_frames + ", seconds_value=" + this.seconds_value + ", minutes_value=" + this.minutes_value + ", hours_value=" + this.hours_value + ", time_offset_length=" + this.time_offset_length + ", time_offset=" + this.time_offset;
                    }
                }
            }
            return String.valueOf(string2) + '}';
        }
    }

    public static class SliceHeader {
        public boolean bottom_field_flag = false;
        public int colour_plane_id;
        public int delta_pic_order_cnt_bottom;
        public boolean field_pic_flag = false;
        public int first_mb_in_slice;
        public int frame_num;
        public int idr_pic_id;
        public int pic_order_cnt_lsb;
        public int pic_parameter_set_id;
        public SliceType slice_type;

        /*
         * Enabled aggressive block sorting
         */
        public SliceHeader(InputStream object, SeqParameterSet seqParameterSet, PictureParameterSet pictureParameterSet, boolean bl) throws IOException {
            ((InputStream)object).read();
            object = new CAVLCReader((InputStream)object);
            this.first_mb_in_slice = ((CAVLCReader)object).readUE("SliceHeader: first_mb_in_slice");
            switch (((CAVLCReader)object).readUE("SliceHeader: slice_type")) {
                case 0: 
                case 5: {
                    this.slice_type = SliceType.P;
                    break;
                }
                case 1: 
                case 6: {
                    this.slice_type = SliceType.B;
                    break;
                }
                case 2: 
                case 7: {
                    this.slice_type = SliceType.I;
                    break;
                }
                case 3: 
                case 8: {
                    this.slice_type = SliceType.SP;
                    break;
                }
                case 4: 
                case 9: {
                    this.slice_type = SliceType.SI;
                    break;
                }
            }
            this.pic_parameter_set_id = ((CAVLCReader)object).readUE("SliceHeader: pic_parameter_set_id");
            if (seqParameterSet.residual_color_transform_flag) {
                this.colour_plane_id = ((CAVLCReader)object).readU(2, "SliceHeader: colour_plane_id");
            }
            this.frame_num = ((CAVLCReader)object).readU(seqParameterSet.log2_max_frame_num_minus4 + 4, "SliceHeader: frame_num");
            if (!seqParameterSet.frame_mbs_only_flag) {
                this.field_pic_flag = ((CAVLCReader)object).readBool("SliceHeader: field_pic_flag");
                if (this.field_pic_flag) {
                    this.bottom_field_flag = ((CAVLCReader)object).readBool("SliceHeader: bottom_field_flag");
                }
            }
            if (bl) {
                this.idr_pic_id = ((CAVLCReader)object).readUE("SliceHeader: idr_pic_id");
                if (seqParameterSet.pic_order_cnt_type == 0) {
                    this.pic_order_cnt_lsb = ((CAVLCReader)object).readU(seqParameterSet.log2_max_pic_order_cnt_lsb_minus4 + 4, "SliceHeader: pic_order_cnt_lsb");
                    if (pictureParameterSet.pic_order_present_flag && !this.field_pic_flag) {
                        this.delta_pic_order_cnt_bottom = ((CAVLCReader)object).readSE("SliceHeader: delta_pic_order_cnt_bottom");
                    }
                }
            }
        }

        public String toString() {
            return "SliceHeader{first_mb_in_slice=" + this.first_mb_in_slice + ", slice_type=" + (Object)((Object)this.slice_type) + ", pic_parameter_set_id=" + this.pic_parameter_set_id + ", colour_plane_id=" + this.colour_plane_id + ", frame_num=" + this.frame_num + ", field_pic_flag=" + this.field_pic_flag + ", bottom_field_flag=" + this.bottom_field_flag + ", idr_pic_id=" + this.idr_pic_id + ", pic_order_cnt_lsb=" + this.pic_order_cnt_lsb + ", delta_pic_order_cnt_bottom=" + this.delta_pic_order_cnt_bottom + '}';
        }

        public static enum SliceType {
            P,
            B,
            I,
            SP,
            SI;

        }
    }
}

