/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.apple;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;

public class QuicktimeTextSampleEntry
extends AbstractSampleEntry {
    public static final String TYPE = "text";
    int backgroundB;
    int backgroundG;
    int backgroundR;
    int dataReferenceIndex;
    long defaultTextBox;
    int displayFlags;
    short fontFace;
    String fontName = "";
    short fontNumber;
    int foregroundB = 65535;
    int foregroundG = 65535;
    int foregroundR = 65535;
    long reserved1;
    byte reserved2;
    short reserved3;
    int textJustification;

    public QuicktimeTextSampleEntry() {
        super(TYPE);
    }

    @Override
    public void addBox(Box box) {
        throw new RuntimeException("QuicktimeTextSampleEntries may not have child boxes");
    }

    public int getBackgroundB() {
        return this.backgroundB;
    }

    public int getBackgroundG() {
        return this.backgroundG;
    }

    public int getBackgroundR() {
        return this.backgroundR;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        int n2 = this.fontName != null ? this.fontName.length() : 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2 + 52);
        byteBuffer.position(6);
        IsoTypeWriter.writeUInt16(byteBuffer, this.dataReferenceIndex);
        byteBuffer.putInt(this.displayFlags);
        byteBuffer.putInt(this.textJustification);
        IsoTypeWriter.writeUInt16(byteBuffer, this.backgroundR);
        IsoTypeWriter.writeUInt16(byteBuffer, this.backgroundG);
        IsoTypeWriter.writeUInt16(byteBuffer, this.backgroundB);
        IsoTypeWriter.writeUInt64(byteBuffer, this.defaultTextBox);
        IsoTypeWriter.writeUInt64(byteBuffer, this.reserved1);
        byteBuffer.putShort(this.fontNumber);
        byteBuffer.putShort(this.fontFace);
        byteBuffer.put(this.reserved2);
        byteBuffer.putShort(this.reserved3);
        IsoTypeWriter.writeUInt16(byteBuffer, this.foregroundR);
        IsoTypeWriter.writeUInt16(byteBuffer, this.foregroundG);
        IsoTypeWriter.writeUInt16(byteBuffer, this.foregroundB);
        if (this.fontName != null) {
            IsoTypeWriter.writeUInt8(byteBuffer, this.fontName.length());
            byteBuffer.put(this.fontName.getBytes());
        }
        writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
    }

    public long getDefaultTextBox() {
        return this.defaultTextBox;
    }

    public int getDisplayFlags() {
        return this.displayFlags;
    }

    public short getFontFace() {
        return this.fontFace;
    }

    public String getFontName() {
        return this.fontName;
    }

    public short getFontNumber() {
        return this.fontNumber;
    }

    public int getForegroundB() {
        return this.foregroundB;
    }

    public int getForegroundG() {
        return this.foregroundG;
    }

    public int getForegroundR() {
        return this.foregroundR;
    }

    public long getReserved1() {
        return this.reserved1;
    }

    public byte getReserved2() {
        return this.reserved2;
    }

    public short getReserved3() {
        return this.reserved3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getSize() {
        long l2 = this.getContainerSize();
        int n2 = this.fontName != null ? this.fontName.length() : 0;
        l2 = 52L + l2 + (long)n2;
        if (!this.largeBox && 8L + l2 < 0x100000000L) {
            n2 = 8;
            return (long)n2 + l2;
        }
        n2 = 16;
        return (long)n2 + l2;
    }

    public int getTextJustification() {
        return this.textJustification;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void parse(DataSource object, ByteBuffer byteBuffer, long l2, BoxParser boxParser) throws IOException {
        byteBuffer = ByteBuffer.allocate(CastUtils.l2i(l2));
        object.read(byteBuffer);
        byteBuffer.position(6);
        this.dataReferenceIndex = IsoTypeReader.readUInt16(byteBuffer);
        this.displayFlags = byteBuffer.getInt();
        this.textJustification = byteBuffer.getInt();
        this.backgroundR = IsoTypeReader.readUInt16(byteBuffer);
        this.backgroundG = IsoTypeReader.readUInt16(byteBuffer);
        this.backgroundB = IsoTypeReader.readUInt16(byteBuffer);
        this.defaultTextBox = IsoTypeReader.readUInt64(byteBuffer);
        this.reserved1 = IsoTypeReader.readUInt64(byteBuffer);
        this.fontNumber = byteBuffer.getShort();
        this.fontFace = byteBuffer.getShort();
        this.reserved2 = byteBuffer.get();
        this.reserved3 = byteBuffer.getShort();
        this.foregroundR = IsoTypeReader.readUInt16(byteBuffer);
        this.foregroundG = IsoTypeReader.readUInt16(byteBuffer);
        this.foregroundB = IsoTypeReader.readUInt16(byteBuffer);
        if (byteBuffer.remaining() > 0) {
            object = new byte[IsoTypeReader.readUInt8(byteBuffer)];
            byteBuffer.get((byte[])object);
            this.fontName = new String((byte[])object);
            return;
        }
        this.fontName = null;
    }

    public void setBackgroundB(int n2) {
        this.backgroundB = n2;
    }

    public void setBackgroundG(int n2) {
        this.backgroundG = n2;
    }

    public void setBackgroundR(int n2) {
        this.backgroundR = n2;
    }

    @Override
    public void setBoxes(List<Box> list) {
        throw new RuntimeException("QuicktimeTextSampleEntries may not have child boxes");
    }

    public void setDefaultTextBox(long l2) {
        this.defaultTextBox = l2;
    }

    public void setDisplayFlags(int n2) {
        this.displayFlags = n2;
    }

    public void setFontFace(short s2) {
        this.fontFace = s2;
    }

    public void setFontName(String string2) {
        this.fontName = string2;
    }

    public void setFontNumber(short s2) {
        this.fontNumber = s2;
    }

    public void setForegroundB(int n2) {
        this.foregroundB = n2;
    }

    public void setForegroundG(int n2) {
        this.foregroundG = n2;
    }

    public void setForegroundR(int n2) {
        this.foregroundR = n2;
    }

    public void setReserved1(long l2) {
        this.reserved1 = l2;
    }

    public void setReserved2(byte by) {
        this.reserved2 = by;
    }

    public void setReserved3(short s2) {
        this.reserved3 = s2;
    }

    public void setTextJustification(int n2) {
        this.textJustification = n2;
    }
}

