/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.IsoTypeReader;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderSpecificInfo;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.Descriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ExtensionDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ExtensionProfileLevelDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorBase;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ProfileLevelIndicationDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.SLConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.UnknownDescriptor;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectDescriptorFactory {
    protected static Map<Integer, Map<Integer, Class<? extends BaseDescriptor>>> descriptorRegistry;
    protected static Logger log;

    static {
        log = Logger.getLogger(ObjectDescriptorFactory.class.getName());
        descriptorRegistry = new HashMap<Integer, Map<Integer, Class<? extends BaseDescriptor>>>();
        Object object = new HashSet();
        object.add(DecoderSpecificInfo.class);
        object.add(SLConfigDescriptor.class);
        object.add(BaseDescriptor.class);
        object.add(ExtensionDescriptor.class);
        object.add(ObjectDescriptorBase.class);
        object.add(ProfileLevelIndicationDescriptor.class);
        object.add(AudioSpecificConfig.class);
        object.add(ExtensionProfileLevelDescriptor.class);
        object.add(ESDescriptor.class);
        object.add(DecoderConfigDescriptor.class);
        Iterator iterator = object.iterator();
        block0: while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            object = clazz.getAnnotation(Descriptor.class);
            int[] nArray = object.tags();
            int n2 = object.objectTypeIndication();
            Map<Integer, Class<? extends BaseDescriptor>> map = descriptorRegistry.get(n2);
            object = map;
            if (map == null) {
                object = new HashMap();
            }
            int n3 = nArray.length;
            int n4 = 0;
            while (true) {
                if (n4 >= n3) {
                    descriptorRegistry.put(n2, (Map<Integer, Class<? extends BaseDescriptor>>)object);
                    continue block0;
                }
                object.put(nArray[n4], clazz);
                ++n4;
            }
            break;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BaseDescriptor createFrom(int n2, ByteBuffer byteBuffer) throws IOException {
        int n3 = IsoTypeReader.readUInt8(byteBuffer);
        Object object = descriptorRegistry.get(n2);
        BaseDescriptor baseDescriptor = object;
        if (object == null) {
            baseDescriptor = descriptorRegistry.get(-1);
        }
        if ((object = baseDescriptor.get(n3)) == null || ((Class)object).isInterface() || Modifier.isAbstract(((Class)object).getModifiers())) {
            log.warning("No ObjectDescriptor found for objectTypeIndication " + Integer.toHexString(n2) + " and tag " + Integer.toHexString(n3) + " found: " + object);
            baseDescriptor = new UnknownDescriptor();
        } else {
            try {
                baseDescriptor = (BaseDescriptor)((Class)object).newInstance();
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Couldn't instantiate BaseDescriptor class " + object + " for objectTypeIndication " + n2 + " and tag " + n3, exception);
                throw new RuntimeException(exception);
            }
        }
        baseDescriptor.parse(n3, byteBuffer);
        return baseDescriptor;
    }
}

