/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.samplegrouping;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class RateShareEntry
extends GroupEntry {
    public static final String TYPE = "rash";
    private short discardPriority;
    private List<Entry> entries = new LinkedList<Entry>();
    private int maximumBitrate;
    private int minimumBitrate;
    private short operationPointCut;
    private short targetRateShare;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return bl;
        }
        if (object == null) return false;
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (RateShareEntry)object;
        if (this.discardPriority != ((RateShareEntry)object).discardPriority) {
            return false;
        }
        if (this.maximumBitrate != ((RateShareEntry)object).maximumBitrate) {
            return false;
        }
        if (this.minimumBitrate != ((RateShareEntry)object).minimumBitrate) {
            return false;
        }
        if (this.operationPointCut != ((RateShareEntry)object).operationPointCut) {
            return false;
        }
        if (this.targetRateShare != ((RateShareEntry)object).targetRateShare) {
            return false;
        }
        if (this.entries != null) {
            if (this.entries.equals(((RateShareEntry)object).entries)) return bl;
            return false;
        }
        if (((RateShareEntry)object).entries == null) return bl;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ByteBuffer get() {
        int n2 = this.operationPointCut == 1 ? 13 : this.operationPointCut * 6 + 11;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.putShort(this.operationPointCut);
        if (this.operationPointCut == 1) {
            byteBuffer.putShort(this.targetRateShare);
        } else {
            for (Entry entry : this.entries) {
                byteBuffer.putInt(entry.getAvailableBitrate());
                byteBuffer.putShort(entry.getTargetRateShare());
            }
        }
        byteBuffer.putInt(this.maximumBitrate);
        byteBuffer.putInt(this.minimumBitrate);
        IsoTypeWriter.writeUInt8(byteBuffer, this.discardPriority);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public short getDiscardPriority() {
        return this.discardPriority;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public int getMaximumBitrate() {
        return this.maximumBitrate;
    }

    public int getMinimumBitrate() {
        return this.minimumBitrate;
    }

    public short getOperationPointCut() {
        return this.operationPointCut;
    }

    public short getTargetRateShare() {
        return this.targetRateShare;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n2;
        short s2 = this.operationPointCut;
        short s3 = this.targetRateShare;
        if (this.entries != null) {
            n2 = this.entries.hashCode();
            return (((n2 + (s2 * 31 + s3) * 31) * 31 + this.maximumBitrate) * 31 + this.minimumBitrate) * 31 + this.discardPriority;
        }
        n2 = 0;
        return (((n2 + (s2 * 31 + s3) * 31) * 31 + this.maximumBitrate) * 31 + this.minimumBitrate) * 31 + this.discardPriority;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void parse(ByteBuffer byteBuffer) {
        this.operationPointCut = byteBuffer.getShort();
        if (this.operationPointCut == 1) {
            this.targetRateShare = byteBuffer.getShort();
        } else {
            for (int i2 = this.operationPointCut; i2 > 0; --i2) {
                this.entries.add(new Entry(CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer)), byteBuffer.getShort()));
            }
        }
        this.maximumBitrate = CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer));
        this.minimumBitrate = CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer));
        this.discardPriority = (short)IsoTypeReader.readUInt8(byteBuffer);
    }

    public void setDiscardPriority(short s2) {
        this.discardPriority = s2;
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public void setMaximumBitrate(int n2) {
        this.maximumBitrate = n2;
    }

    public void setMinimumBitrate(int n2) {
        this.minimumBitrate = n2;
    }

    public void setOperationPointCut(short s2) {
        this.operationPointCut = s2;
    }

    public void setTargetRateShare(short s2) {
        this.targetRateShare = s2;
    }

    public static class Entry {
        int availableBitrate;
        short targetRateShare;

        public Entry(int n2, short s2) {
            this.availableBitrate = n2;
            this.targetRateShare = s2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return bl;
            }
            if (object == null) return false;
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (Entry)object;
            if (this.availableBitrate != ((Entry)object).availableBitrate) {
                return false;
            }
            if (this.targetRateShare == ((Entry)object).targetRateShare) return bl;
            return false;
        }

        public int getAvailableBitrate() {
            return this.availableBitrate;
        }

        public short getTargetRateShare() {
            return this.targetRateShare;
        }

        public int hashCode() {
            return this.availableBitrate * 31 + this.targetRateShare;
        }

        public void setAvailableBitrate(int n2) {
            this.availableBitrate = n2;
        }

        public void setTargetRateShare(short s2) {
            this.targetRateShare = s2;
        }

        public String toString() {
            return "{availableBitrate=" + this.availableBitrate + ", targetRateShare=" + this.targetRateShare + '}';
        }
    }
}

