/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264.model;

public class ChromaFormat {
    public static ChromaFormat MONOCHROME = new ChromaFormat(0, 0, 0);
    public static ChromaFormat YUV_420 = new ChromaFormat(1, 2, 2);
    public static ChromaFormat YUV_422 = new ChromaFormat(2, 2, 1);
    public static ChromaFormat YUV_444 = new ChromaFormat(3, 1, 1);
    private int id;
    private int subHeight;
    private int subWidth;

    public ChromaFormat(int n2, int n3, int n4) {
        this.id = n2;
        this.subWidth = n3;
        this.subHeight = n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChromaFormat fromId(int n2) {
        if (n2 == ChromaFormat.MONOCHROME.id) {
            return MONOCHROME;
        }
        if (n2 == ChromaFormat.YUV_420.id) {
            return YUV_420;
        }
        if (n2 == ChromaFormat.YUV_422.id) {
            return YUV_422;
        }
        if (n2 != ChromaFormat.YUV_444.id) return null;
        return YUV_444;
    }

    public int getId() {
        return this.id;
    }

    public int getSubHeight() {
        return this.subHeight;
    }

    public int getSubWidth() {
        return this.subWidth;
    }

    public String toString() {
        return "ChromaFormat{\nid=" + this.id + ",\n" + " subWidth=" + this.subWidth + ",\n" + " subHeight=" + this.subHeight + '}';
    }
}

