/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264.model;

import com.googlecode.mp4parser.h264.read.CAVLCReader;
import com.googlecode.mp4parser.h264.write.CAVLCWriter;
import java.io.IOException;

public class ScalingList {
    public int[] scalingList;
    public boolean useDefaultScalingMatrixFlag;

    /*
     * Enabled aggressive block sorting
     */
    public static ScalingList read(CAVLCReader cAVLCReader, int n2) throws IOException {
        int n3 = 8;
        ScalingList scalingList = new ScalingList();
        scalingList.scalingList = new int[n2];
        int n4 = 0;
        int n5 = 8;
        while (n4 < n2) {
            int n6 = n3;
            if (n3 != 0) {
                n6 = (cAVLCReader.readSE("deltaScale") + n5 + 256) % 256;
                boolean bl = n4 == 0 && n6 == 0;
                scalingList.useDefaultScalingMatrixFlag = bl;
            }
            int[] nArray = scalingList.scalingList;
            if (n6 != 0) {
                n5 = n6;
            }
            nArray[n4] = n5;
            n5 = scalingList.scalingList[n4];
            ++n4;
            n3 = n6;
        }
        return scalingList;
    }

    public String toString() {
        return "ScalingList{scalingList=" + this.scalingList + ", useDefaultScalingMatrixFlag=" + this.useDefaultScalingMatrixFlag + '}';
    }

    /*
     * Enabled aggressive block sorting
     */
    public void write(CAVLCWriter cAVLCWriter) throws IOException {
        if (this.useDefaultScalingMatrixFlag) {
            cAVLCWriter.writeSE(0, "SPS: ");
            return;
        } else {
            int n2 = 8;
            for (int i2 = 0; i2 < this.scalingList.length; ++i2) {
                cAVLCWriter.writeSE(this.scalingList[i2] - n2 - 256, "SPS: ");
                n2 = this.scalingList[i2];
            }
        }
    }
}

