/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264.read;

import com.googlecode.mp4parser.h264.CharCache;
import java.io.IOException;
import java.io.InputStream;

public class BitstreamReader {
    protected static int bitsRead;
    private int curByte;
    protected CharCache debugBits = new CharCache(50);
    private InputStream is;
    int nBit;
    private int nextByte;

    public BitstreamReader(InputStream inputStream) throws IOException {
        this.is = inputStream;
        this.curByte = inputStream.read();
        this.nextByte = inputStream.read();
    }

    private void advance() throws IOException {
        this.curByte = this.nextByte;
        this.nextByte = this.is.read();
        this.nBit = 0;
    }

    public void close() throws IOException {
    }

    public long getBitPosition() {
        return bitsRead * 8 + this.nBit % 8;
    }

    public int getCurBit() {
        return this.nBit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isByteAligned() {
        if (this.nBit % 8 != 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean moreRBSPData() throws IOException {
        int n2;
        boolean bl = true;
        if (this.nBit == 8) {
            this.advance();
        }
        n2 = (((n2 = 1 << 8 - this.nBit - 1) << 1) - 1 & this.curByte) == n2 ? 1 : 0;
        if (this.curByte == -1) return false;
        boolean bl2 = bl;
        if (this.nextByte != -1) return bl2;
        bl2 = bl;
        if (n2 == 0) return bl2;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int peakNextBits(int n2) throws IOException {
        int n3 = -1;
        int n4 = 0;
        if (n2 > 8) {
            throw new IllegalArgumentException("N should be less then 8");
        }
        if (this.nBit == 8) {
            this.advance();
            if (this.curByte == -1) {
                return n3;
            }
        }
        int[] nArray = new int[16 - this.nBit];
        int n5 = this.nBit;
        n3 = 0;
        while (true) {
            if (n5 >= 8) break;
            nArray[n3] = this.curByte >> 7 - n5 & 1;
            ++n5;
            ++n3;
        }
        n5 = 0;
        while (true) {
            if (n5 >= 8) {
                n3 = 0;
                n5 = n4;
                while (true) {
                    n4 = n3;
                    if (n5 >= n2) return n4;
                    n4 = nArray[n5];
                    ++n5;
                    n3 = n4 | n3 << 1;
                }
            }
            nArray[n3] = this.nextByte >> 7 - n5 & 1;
            ++n5;
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int read1Bit() throws IOException {
        char c2;
        char c3;
        int n2 = -1;
        if (this.nBit == 8) {
            this.advance();
            if (this.curByte == -1) {
                return n2;
            }
        }
        n2 = this.curByte >> 7 - this.nBit & 1;
        ++this.nBit;
        CharCache charCache = this.debugBits;
        char c4 = n2 == 0 ? (c3 = '0') : (c2 = '1');
        charCache.append(c4);
        ++bitsRead;
        return n2;
    }

    public int readByte() throws IOException {
        if (this.nBit > 0) {
            this.advance();
        }
        int n2 = this.curByte;
        this.advance();
        return n2;
    }

    public long readNBit(int n2) throws IOException {
        if (n2 > 64) {
            throw new IllegalArgumentException("Can not readByte more then 64 bit");
        }
        long l2 = 0L;
        int n3 = 0;
        while (n3 < n2) {
            l2 = l2 << 1 | (long)this.read1Bit();
            ++n3;
        }
        return l2;
    }

    public long readRemainingByte() throws IOException {
        return this.readNBit(8 - this.nBit);
    }
}

