/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264.read;

import com.googlecode.mp4parser.h264.BTree;
import com.googlecode.mp4parser.h264.Debug;
import com.googlecode.mp4parser.h264.read.BitstreamReader;
import java.io.IOException;
import java.io.InputStream;

public class CAVLCReader
extends BitstreamReader {
    public CAVLCReader(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    private int readUE() throws IOException {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (this.read1Bit() != 0) {
                if (n3 > 0) {
                    long l2 = this.readNBit(n3);
                    n2 = (int)((long)((1 << n3) - 1) + l2);
                }
                return n2;
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void trace(String string2, String string3) {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = String.valueOf(BitstreamReader.bitsRead - this.debugBits.length());
        int n3 = string4.length();
        stringBuilder.append("@" + string4);
        int n4 = 0;
        while (true) {
            if (n4 >= 8 - n3) break;
            stringBuilder.append(' ');
            ++n4;
        }
        stringBuilder.append(string2);
        n3 = stringBuilder.length();
        int n5 = this.debugBits.length();
        n4 = n2;
        while (true) {
            if (n4 >= 100 - n3 - n5) {
                stringBuilder.append(this.debugBits);
                stringBuilder.append(" (" + string3 + ")");
                this.debugBits.clear();
                Debug.println(stringBuilder.toString());
                return;
            }
            stringBuilder.append(' ');
            ++n4;
        }
    }

    public byte[] read(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = (byte)this.readByte();
            ++n3;
        }
        return byArray;
    }

    public boolean readAE() {
        throw new UnsupportedOperationException("Stan");
    }

    public int readAEI() {
        throw new UnsupportedOperationException("Stan");
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean readBool(String string2) throws IOException {
        boolean bl = this.read1Bit() != 0;
        String string3 = bl ? "1" : "0";
        this.trace(string2, string3);
        return bl;
    }

    public Object readCE(BTree bTree, String string2) throws IOException {
        Object object;
        do {
            if ((bTree = bTree.down(this.read1Bit())) != null) continue;
            throw new RuntimeException("Illegal code");
        } while ((object = bTree.getValue()) == null);
        this.trace(string2, object.toString());
        return object;
    }

    public int readME(String string2) throws IOException {
        return this.readUE(string2);
    }

    public long readNBit(int n2, String string2) throws IOException {
        long l2 = this.readNBit(n2);
        this.trace(string2, String.valueOf(l2));
        return l2;
    }

    public int readSE(String string2) throws IOException {
        int n2 = this.readUE();
        n2 = ((n2 & 1) + (n2 >> 1)) * (((n2 & 1) << 1) - 1);
        this.trace(string2, String.valueOf(n2));
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readTE(int n2) throws IOException {
        if (n2 <= 1) return ~this.read1Bit() & 1;
        return this.readUE();
    }

    public void readTrailingBits() throws IOException {
        this.read1Bit();
        this.readRemainingByte();
    }

    public int readU(int n2, String string2) throws IOException {
        return (int)this.readNBit(n2, string2);
    }

    public int readUE(String string2) throws IOException {
        int n2 = this.readUE();
        this.trace(string2, String.valueOf(n2));
        return n2;
    }

    public int readZeroBitCount(String string2) throws IOException {
        int n2 = 0;
        while (true) {
            if (this.read1Bit() != 0) {
                this.trace(string2, String.valueOf(n2));
                return n2;
            }
            ++n2;
        }
    }
}

