/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264.write;

import com.googlecode.mp4parser.h264.Debug;
import java.io.IOException;
import java.io.OutputStream;

public class BitstreamWriter {
    private int curBit;
    private int[] curByte = new int[8];
    private final OutputStream os;

    public BitstreamWriter(OutputStream outputStream) {
        this.os = outputStream;
    }

    private void writeCurByte() throws IOException {
        int n2 = this.curByte[0];
        int n3 = this.curByte[1];
        int n4 = this.curByte[2];
        int n5 = this.curByte[3];
        int n6 = this.curByte[4];
        int n7 = this.curByte[5];
        int n8 = this.curByte[6];
        int n9 = this.curByte[7];
        this.os.write(n2 << 7 | n3 << 6 | n4 << 5 | n5 << 4 | n6 << 3 | n7 << 2 | n8 << 1 | n9);
    }

    public void flush() throws IOException {
        int n2 = this.curBit;
        while (true) {
            if (n2 >= 8) {
                this.curBit = 0;
                this.writeCurByte();
                return;
            }
            this.curByte[n2] = 0;
            ++n2;
        }
    }

    public void write1Bit(int n2) throws IOException {
        Debug.print(n2);
        if (this.curBit == 8) {
            this.curBit = 0;
            this.writeCurByte();
        }
        int[] nArray = this.curByte;
        int n3 = this.curBit;
        this.curBit = n3 + 1;
        nArray[n3] = n2;
    }

    public void writeByte(int n2) throws IOException {
        this.os.write(n2);
    }

    public void writeNBit(long l2, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.write1Bit((int)(l2 >> n2 - n3 - 1) & 1);
            ++n3;
        }
        return;
    }

    public void writeRemainingZero() throws IOException {
        this.writeNBit(0L, 8 - this.curBit);
    }
}

