/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.util;

import com.googlecode.mp4parser.util.Logger;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class LazyList<E>
extends AbstractList<E> {
    private static final Logger LOG = Logger.getLogger(LazyList.class);
    Iterator<E> elementSource;
    List<E> underlying;

    public LazyList(List<E> list, Iterator<E> iterator) {
        this.underlying = list;
        this.elementSource = iterator;
    }

    private void blowup() {
        LOG.logDebug("blowup running");
        while (this.elementSource.hasNext()) {
            this.underlying.add(this.elementSource.next());
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public E get(int n2) {
        E e2;
        if (this.underlying.size() > n2) {
            e2 = this.underlying.get(n2);
            return e2;
        }
        if (!this.elementSource.hasNext()) throw new NoSuchElementException();
        this.underlying.add(this.elementSource.next());
        e2 = this.get(n2);
        return e2;
    }

    public List<E> getUnderlying() {
        return this.underlying;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int pos = 0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean hasNext() {
                if (this.pos < LazyList.this.underlying.size()) return true;
                if (LazyList.this.elementSource.hasNext()) return true;
                return false;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public E next() {
                void var1_3;
                if (this.pos < LazyList.this.underlying.size()) {
                    List list = LazyList.this.underlying;
                    int n2 = this.pos;
                    this.pos = n2 + 1;
                    Object e2 = list.get(n2);
                    return var1_3;
                }
                LazyList.this.underlying.add(LazyList.this.elementSource.next());
                Object e3 = this.next();
                return var1_3;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        LOG.logDebug("potentially expensive size() call");
        this.blowup();
        return this.underlying.size();
    }
}

