/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Handshake;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.internal.DiskLruCache;
import com.squareup.okhttp.internal.InternalCache;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.CacheRequest;
import com.squareup.okhttp.internal.http.CacheStrategy;
import com.squareup.okhttp.internal.http.HttpMethod;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.StatusLine;
import com.squareup.okhttp.internal.io.FileSystem;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import s.c;
import s.d;
import s.e;
import s.f;
import s.h;
import s.i;
import s.m;
import s.s;
import s.t;

public final class Cache {
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    private static final int ENTRY_METADATA = 0;
    private static final int VERSION = 201105;
    private final DiskLruCache cache;
    private int hitCount;
    final InternalCache internalCache = new InternalCache(){

        @Override
        public Response get(Request request) throws IOException {
            return Cache.this.get(request);
        }

        @Override
        public CacheRequest put(Response response) throws IOException {
            return Cache.this.put(response);
        }

        @Override
        public void remove(Request request) throws IOException {
            Cache.this.remove(request);
        }

        @Override
        public void trackConditionalCacheHit() {
            Cache.this.trackConditionalCacheHit();
        }

        @Override
        public void trackResponse(CacheStrategy cacheStrategy) {
            Cache.this.trackResponse(cacheStrategy);
        }

        @Override
        public void update(Response response, Response response2) throws IOException {
            Cache.this.update(response, response2);
        }
    };
    private int networkCount;
    private int requestCount;
    private int writeAbortCount;
    private int writeSuccessCount;

    public Cache(File file, long l2) {
        this(file, l2, FileSystem.SYSTEM);
    }

    Cache(File file, long l2, FileSystem fileSystem) {
        this.cache = DiskLruCache.create(fileSystem, file, 201105, 2, l2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void abortQuietly(DiskLruCache.Editor editor) {
        if (editor == null) return;
        try {
            editor.abort();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    static /* synthetic */ int access$808(Cache cache) {
        int n2 = cache.writeSuccessCount;
        cache.writeSuccessCount = n2 + 1;
        return n2;
    }

    static /* synthetic */ int access$908(Cache cache) {
        int n2 = cache.writeAbortCount;
        cache.writeAbortCount = n2 + 1;
        return n2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CacheRequest put(Response object) throws IOException {
        CacheRequestImpl cacheRequestImpl = null;
        Object object2 = ((Response)object).request().method();
        if (HttpMethod.invalidatesCache(((Response)object).request().method())) {
            this.remove(((Response)object).request());
            return cacheRequestImpl;
        }
        CacheRequestImpl cacheRequestImpl2 = cacheRequestImpl;
        if (!((String)object2).equals("GET")) return cacheRequestImpl2;
        cacheRequestImpl2 = cacheRequestImpl;
        if (OkHeaders.hasVaryAll((Response)object)) return cacheRequestImpl2;
        object2 = new Entry((Response)object);
        try {
            object = this.cache.edit(Cache.urlToKey(((Response)object).request()));
            cacheRequestImpl2 = cacheRequestImpl;
            if (object == null) return cacheRequestImpl2;
        }
        catch (IOException iOException) {
            object = null;
            this.abortQuietly((DiskLruCache.Editor)object);
            return cacheRequestImpl;
        }
        ((Entry)object2).writeTo((DiskLruCache.Editor)object);
        return new CacheRequestImpl((DiskLruCache.Editor)object);
        {
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            return cacheRequestImpl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int readInt(e object) throws IOException {
        try {
            long l2 = object.m();
            String string2 = object.q();
            if (l2 >= 0L && l2 <= Integer.MAX_VALUE) {
                if (string2.isEmpty()) return (int)l2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            IOException iOException = new IOException(stringBuilder.append("expected an int but was \"").append(l2).append(string2).append("\"").toString());
            throw iOException;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
    }

    private void remove(Request request) throws IOException {
        this.cache.remove(Cache.urlToKey(request));
    }

    private void trackConditionalCacheHit() {
        synchronized (this) {
            ++this.hitCount;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void trackResponse(CacheStrategy cacheStrategy) {
        synchronized (this) {
            ++this.requestCount;
            if (cacheStrategy.networkRequest != null) {
                ++this.networkCount;
            } else if (cacheStrategy.cacheResponse != null) {
                ++this.hitCount;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void update(Response object, Response object2) {
        Entry entry = new Entry((Response)object2);
        object2 = ((CacheResponseBody)((Response)object).body()).snapshot;
        object = null;
        try {
            object2 = ((DiskLruCache.Snapshot)object2).edit();
            if (object2 == null) return;
            object = object2;
            entry.writeTo((DiskLruCache.Editor)object2);
            object = object2;
            ((DiskLruCache.Editor)object2).commit();
            return;
        }
        catch (IOException iOException) {
            this.abortQuietly((DiskLruCache.Editor)object);
            return;
        }
    }

    private static String urlToKey(Request request) {
        return Util.md5Hex(request.urlString());
    }

    public void close() throws IOException {
        this.cache.close();
    }

    public void delete() throws IOException {
        this.cache.delete();
    }

    public void evictAll() throws IOException {
        this.cache.evictAll();
    }

    public void flush() throws IOException {
        this.cache.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Response get(Request object) {
        Object object2;
        Object var2_4;
        block4: {
            var2_4 = null;
            object2 = Cache.urlToKey((Request)object);
            try {
                object2 = this.cache.get((String)object2);
                if (object2 != null) break block4;
                return var2_4;
            }
            catch (IOException iOException) {
                return var2_4;
            }
        }
        try {
            Entry entry = new Entry(((DiskLruCache.Snapshot)object2).getSource(0));
            object2 = entry.response((Request)object, (DiskLruCache.Snapshot)object2);
            if (entry.matches((Request)object, (Response)object2)) return object2;
        }
        catch (IOException iOException) {
            Util.closeQuietly((Closeable)object2);
            return var2_4;
        }
        Util.closeQuietly(((Response)object2).body());
        return var2_4;
    }

    public File getDirectory() {
        return this.cache.getDirectory();
    }

    public int getHitCount() {
        synchronized (this) {
            int n2 = this.hitCount;
            return n2;
        }
    }

    public long getMaxSize() {
        return this.cache.getMaxSize();
    }

    public int getNetworkCount() {
        synchronized (this) {
            int n2 = this.networkCount;
            return n2;
        }
    }

    public int getRequestCount() {
        synchronized (this) {
            int n2 = this.requestCount;
            return n2;
        }
    }

    public long getSize() throws IOException {
        return this.cache.size();
    }

    public int getWriteAbortCount() {
        synchronized (this) {
            int n2 = this.writeAbortCount;
            return n2;
        }
    }

    public int getWriteSuccessCount() {
        synchronized (this) {
            int n2 = this.writeSuccessCount;
            return n2;
        }
    }

    public void initialize() throws IOException {
        this.cache.initialize();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    public Iterator<String> urls() throws IOException {
        return new Iterator<String>(){
            boolean canRemove;
            final Iterator<DiskLruCache.Snapshot> delegate;
            String nextUrl;
            {
                this.delegate = Cache.this.cache.snapshots();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hasNext() {
                if (this.nextUrl != null) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    DiskLruCache.Snapshot snapshot = this.delegate.next();
                    try {
                        this.nextUrl = m.a((t)snapshot.getSource(0)).q();
                        boolean bl = true;
                        return bl;
                    }
                    catch (IOException iOException) {}
                    continue;
                    finally {
                        snapshot.close();
                        continue;
                    }
                    break;
                }
                return false;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String string2 = this.nextUrl;
                this.nextUrl = null;
                this.canRemove = true;
                return string2;
            }

            @Override
            public void remove() {
                if (!this.canRemove) {
                    throw new IllegalStateException("remove() before next()");
                }
                this.delegate.remove();
            }
        };
    }

    private final class CacheRequestImpl
    implements CacheRequest {
        private s body;
        private s cacheOut;
        private boolean done;
        private final DiskLruCache.Editor editor;

        public CacheRequestImpl(final DiskLruCache.Editor editor) throws IOException {
            this.editor = editor;
            this.cacheOut = editor.newSink(1);
            this.body = new h(this.cacheOut){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void close() throws IOException {
                    Cache cache = Cache.this;
                    synchronized (cache) {
                        if (CacheRequestImpl.this.done) {
                            return;
                        }
                        CacheRequestImpl.access$702(CacheRequestImpl.this, true);
                        Cache.access$808(Cache.this);
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        static /* synthetic */ boolean access$702(CacheRequestImpl cacheRequestImpl, boolean bl) {
            cacheRequestImpl.done = bl;
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void abort() {
            Cache cache = Cache.this;
            synchronized (cache) {
                if (this.done) {
                    return;
                }
                this.done = true;
                Cache.access$908(Cache.this);
            }
            Util.closeQuietly((Closeable)this.cacheOut);
            try {
                this.editor.abort();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        @Override
        public s body() {
            return this.body;
        }
    }

    private static class CacheResponseBody
    extends ResponseBody {
        private final e bodySource;
        private final String contentLength;
        private final String contentType;
        private final DiskLruCache.Snapshot snapshot;

        public CacheResponseBody(final DiskLruCache.Snapshot snapshot, String string2, String string3) {
            this.snapshot = snapshot;
            this.contentType = string2;
            this.contentLength = string3;
            this.bodySource = m.a((t)new i(snapshot.getSource(1)){

                public void close() throws IOException {
                    snapshot.close();
                    super.close();
                }
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long contentLength() {
            long l2;
            long l3 = l2 = -1L;
            try {
                if (this.contentLength == null) return l3;
                return Long.parseLong(this.contentLength);
            }
            catch (NumberFormatException numberFormatException) {
                return l2;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public MediaType contentType() {
            if (this.contentType == null) return null;
            return MediaType.parse(this.contentType);
        }

        @Override
        public e source() {
            return this.bodySource;
        }
    }

    private static final class Entry {
        private final int code;
        private final Handshake handshake;
        private final String message;
        private final Protocol protocol;
        private final String requestMethod;
        private final Headers responseHeaders;
        private final String url;
        private final Headers varyHeaders;

        public Entry(Response response) {
            this.url = response.request().urlString();
            this.varyHeaders = OkHeaders.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Entry(t t2) throws IOException {
            block10: {
                int n2;
                int n3 = 0;
                e e2 = m.a((t)t2);
                this.url = e2.q();
                this.requestMethod = e2.q();
                Object object = new Headers.Builder();
                int n4 = Cache.readInt(e2);
                for (n2 = 0; n2 < n4; ++n2) {
                    ((Headers.Builder)object).addLenient(e2.q());
                }
                this.varyHeaders = ((Headers.Builder)object).build();
                object = StatusLine.parse(e2.q());
                this.protocol = ((StatusLine)object).protocol;
                this.code = ((StatusLine)object).code;
                this.message = ((StatusLine)object).message;
                object = new Headers.Builder();
                n4 = Cache.readInt(e2);
                for (n2 = n3; n2 < n4; ++n2) {
                    ((Headers.Builder)object).addLenient(e2.q());
                }
                this.responseHeaders = ((Headers.Builder)object).build();
                if (!this.isHttps()) break block10;
                object = e2.q();
                if (((String)object).length() > 0) {
                    IOException iOException = new IOException(e2.append("expected \"\" but was \"").append((String)object).append("\"").toString());
                    throw iOException;
                }
                this.handshake = Handshake.get(e2.q(), this.readCertificateList(e2), this.readCertificateList(e2));
                return;
            }
            this.handshake = null;
        }

        private boolean isHttps() {
            return this.url.startsWith("https://");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private List<Certificate> readCertificateList(e e2) throws IOException {
            int n2;
            ArrayList<Certificate> arrayList;
            CertificateFactory certificateFactory;
            int n3 = Cache.readInt(e2);
            if (n3 == -1) {
                return Collections.emptyList();
            }
            try {
                certificateFactory = CertificateFactory.getInstance("X.509");
                arrayList = new ArrayList<Certificate>(n3);
                n2 = 0;
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
            while (true) {
                Object object = arrayList;
                if (n2 >= n3) return object;
                object = e2.q();
                c c2 = new c();
                c2.a(f.b((String)object));
                arrayList.add(certificateFactory.generateCertificate(c2.f()));
                ++n2;
                continue;
                break;
            }
        }

        private void writeCertList(d d2, List<Certificate> list) throws IOException {
            d2.k((long)list.size());
            d2.i(10);
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    d2.b(f.a((byte[])list.get(i2).getEncoded()).b());
                    d2.i(10);
                    continue;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException(certificateEncodingException.getMessage());
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matches(Request request, Response response) {
            if (!this.url.equals(request.urlString())) return false;
            if (!this.requestMethod.equals(request.method())) return false;
            if (!OkHeaders.varyMatches(response, this.varyHeaders, request)) return false;
            return true;
        }

        public Response response(Request request, DiskLruCache.Snapshot snapshot) {
            String string2 = this.responseHeaders.get("Content-Type");
            String string3 = this.responseHeaders.get("Content-Length");
            request = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(request).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, string2, string3)).handshake(this.handshake).build();
        }

        public void writeTo(DiskLruCache.Editor editor) throws IOException {
            int n2;
            int n3 = 0;
            editor = m.a((s)editor.newSink(0));
            editor.b(this.url);
            editor.i(10);
            editor.b(this.requestMethod);
            editor.i(10);
            editor.k(this.varyHeaders.size());
            editor.i(10);
            int n4 = this.varyHeaders.size();
            for (n2 = 0; n2 < n4; ++n2) {
                editor.b(this.varyHeaders.name(n2));
                editor.b(": ");
                editor.b(this.varyHeaders.value(n2));
                editor.i(10);
            }
            editor.b(new StatusLine(this.protocol, this.code, this.message).toString());
            editor.i(10);
            editor.k(this.responseHeaders.size());
            editor.i(10);
            n4 = this.responseHeaders.size();
            for (n2 = n3; n2 < n4; ++n2) {
                editor.b(this.responseHeaders.name(n2));
                editor.b(": ");
                editor.b(this.responseHeaders.value(n2));
                editor.i(10);
            }
            if (this.isHttps()) {
                editor.i(10);
                editor.b(this.handshake.cipherSuite());
                editor.i(10);
                this.writeCertList((d)editor, this.handshake.peerCertificates());
                this.writeCertList((d)editor, this.handshake.localCertificates());
            }
            editor.close();
        }
    }
}

