/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HttpEngine;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Dispatcher {
    private final Deque<Call> executedCalls;
    private ExecutorService executorService;
    private int maxRequests = 64;
    private int maxRequestsPerHost = 5;
    private final Deque<Call.AsyncCall> readyCalls = new ArrayDeque<Call.AsyncCall>();
    private final Deque<Call.AsyncCall> runningCalls = new ArrayDeque<Call.AsyncCall>();

    public Dispatcher() {
        this.executedCalls = new ArrayDeque<Call>();
    }

    public Dispatcher(ExecutorService executorService) {
        this.executedCalls = new ArrayDeque<Call>();
        this.executorService = executorService;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void promoteCalls() {
        if (this.runningCalls.size() >= this.maxRequests) {
            return;
        }
        if (this.readyCalls.isEmpty()) return;
        Iterator<Call.AsyncCall> iterator = this.readyCalls.iterator();
        do {
            if (!iterator.hasNext()) return;
            Call.AsyncCall asyncCall = iterator.next();
            if (this.runningCallsForHost(asyncCall) >= this.maxRequestsPerHost) continue;
            iterator.remove();
            this.runningCalls.add(asyncCall);
            this.getExecutorService().execute(asyncCall);
        } while (this.runningCalls.size() < this.maxRequests);
    }

    private int runningCallsForHost(Call.AsyncCall asyncCall) {
        Iterator<Call.AsyncCall> iterator = this.runningCalls.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            if (!iterator.next().host().equals(asyncCall.host())) continue;
            ++n2;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancel(Object object) {
        synchronized (this) {
            Object object22;
            for (Object object22 : this.readyCalls) {
                if (!Util.equal(object, ((Call.AsyncCall)object22).tag())) continue;
                ((Call.AsyncCall)object22).cancel();
            }
            for (Object object22 : this.runningCalls) {
                if (!Util.equal(object, ((Call.AsyncCall)object22).tag())) continue;
                ((Call.AsyncCall)object22).get().canceled = true;
                object22 = ((Call.AsyncCall)object22).get().engine;
                if (object22 == null) continue;
                ((HttpEngine)object22).cancel();
            }
            object22 = this.executedCalls.iterator();
            while (object22.hasNext()) {
                Call call = (Call)object22.next();
                if (!Util.equal(object, call.tag())) continue;
                call.cancel();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void enqueue(Call.AsyncCall asyncCall) {
        synchronized (this) {
            if (this.runningCalls.size() < this.maxRequests && this.runningCallsForHost(asyncCall) < this.maxRequestsPerHost) {
                this.runningCalls.add(asyncCall);
                this.getExecutorService().execute(asyncCall);
            } else {
                this.readyCalls.add(asyncCall);
            }
            return;
        }
    }

    void executed(Call call) {
        synchronized (this) {
            this.executedCalls.add(call);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void finished(Call.AsyncCall object) {
        synchronized (this) {
            if (!this.runningCalls.remove(object)) {
                object = new AssertionError((Object)"AsyncCall wasn't running!");
                throw object;
            }
            this.promoteCalls();
            return;
        }
    }

    void finished(Call object) {
        synchronized (this) {
            if (!this.executedCalls.remove(object)) {
                object = new AssertionError((Object)"Call wasn't in-flight!");
                throw object;
            }
            return;
        }
    }

    public ExecutorService getExecutorService() {
        synchronized (this) {
            SynchronousQueue<Runnable> synchronousQueue;
            if (this.executorService == null) {
                TimeUnit timeUnit = TimeUnit.SECONDS;
                synchronousQueue = new SynchronousQueue<Runnable>();
                ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, timeUnit, synchronousQueue, Util.threadFactory("OkHttp Dispatcher", false));
                this.executorService = threadPoolExecutor;
            }
            synchronousQueue = this.executorService;
            return synchronousQueue;
        }
    }

    public int getMaxRequests() {
        synchronized (this) {
            int n2 = this.maxRequests;
            return n2;
        }
    }

    public int getMaxRequestsPerHost() {
        synchronized (this) {
            int n2 = this.maxRequestsPerHost;
            return n2;
        }
    }

    public int getQueuedCallCount() {
        synchronized (this) {
            int n2 = this.readyCalls.size();
            return n2;
        }
    }

    public int getRunningCallCount() {
        synchronized (this) {
            int n2 = this.runningCalls.size();
            return n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaxRequests(int n2) {
        synchronized (this) {
            if (n2 < 1) {
                StringBuilder stringBuilder = new StringBuilder();
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("max < 1: ").append(n2).toString());
                throw illegalArgumentException;
            }
            this.maxRequests = n2;
            this.promoteCalls();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaxRequestsPerHost(int n2) {
        synchronized (this) {
            if (n2 < 1) {
                StringBuilder stringBuilder = new StringBuilder();
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("max < 1: ").append(n2).toString());
                throw illegalArgumentException;
            }
            this.maxRequestsPerHost = n2;
            this.promoteCalls();
            return;
        }
    }
}

