/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.internal.http.HttpDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class Headers {
    private final String[] namesAndValues;

    private Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] stringArray) {
        this.namesAndValues = stringArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String get(String[] object, String string2) {
        void var0_2;
        for (int i2 = ((String[])object).length - 2; i2 >= 0; i2 -= 2) {
            void var1_4;
            if (!var1_4.equalsIgnoreCase(object[i2])) continue;
            String string3 = object[i2 + 1];
            return var0_2;
        }
        return var0_2;
    }

    public static Headers of(Map<String, String> object) {
        if (object == null) {
            throw new IllegalArgumentException("Expected map with header names and values");
        }
        String[] stringArray = new String[object.size() * 2];
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            object = entry.getKey().trim();
            entry = entry.getValue().trim();
            if (((String)object).length() == 0 || ((String)object).indexOf(0) != -1 || ((String)((Object)entry)).indexOf(0) != -1) {
                throw new IllegalArgumentException("Unexpected header: " + (String)object + ": " + (String)((Object)entry));
            }
            stringArray[n2] = object;
            stringArray[n2 + 1] = entry;
            n2 += 2;
        }
        return new Headers(stringArray);
    }

    public static Headers of(String ... stringArray) {
        int n2;
        if (stringArray == null || stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("Expected alternating header names and values");
        }
        stringArray = (String[])stringArray.clone();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            stringArray[n2] = stringArray[n2].trim();
        }
        for (n2 = 0; n2 < stringArray.length; n2 += 2) {
            String string2 = stringArray[n2];
            String string3 = stringArray[n2 + 1];
            if (string2.length() != 0 && string2.indexOf(0) == -1 && string3.indexOf(0) == -1) continue;
            throw new IllegalArgumentException("Unexpected header: " + string2 + ": " + string3);
        }
        return new Headers(stringArray);
    }

    public String get(String string2) {
        return Headers.get(this.namesAndValues, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date getDate(String object) {
        if ((object = this.get((String)object)) == null) return null;
        return HttpDate.parse((String)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String name(int n2) {
        if ((n2 *= 2) < 0) return null;
        if (n2 < this.namesAndValues.length) return this.namesAndValues[n2];
        return null;
    }

    public Set<String> names() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            treeSet.add(this.name(i2));
        }
        return Collections.unmodifiableSet(treeSet);
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        Collections.addAll(builder.namesAndValues, this.namesAndValues);
        return builder;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public Map<String, List<String>> toMultimap() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ArrayList<String> arrayList;
            String string2 = this.name(i2);
            ArrayList<String> arrayList2 = arrayList = (ArrayList<String>)linkedHashMap.get(string2);
            if (arrayList == null) {
                arrayList2 = new ArrayList<String>(2);
                linkedHashMap.put(string2, arrayList2);
            }
            arrayList2.add(this.value(i2));
        }
        return linkedHashMap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(this.name(i2)).append(": ").append(this.value(i2)).append("\n");
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String value(int n2) {
        if ((n2 = n2 * 2 + 1) < 0) return null;
        if (n2 < this.namesAndValues.length) return this.namesAndValues[n2];
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> values(String list) {
        int n2 = this.size();
        ArrayList<String> arrayList = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            ArrayList<String> arrayList2 = arrayList;
            if (((String)((Object)list)).equalsIgnoreCase(this.name(i2))) {
                arrayList2 = arrayList;
                if (arrayList == null) {
                    arrayList2 = new ArrayList<String>(2);
                }
                arrayList2.add(this.value(i2));
            }
            arrayList = arrayList2;
        }
        if (arrayList == null) return Collections.emptyList();
        return Collections.unmodifiableList(arrayList);
    }

    public static final class Builder {
        private final List<String> namesAndValues = new ArrayList<String>(20);

        private void checkNameAndValue(String string2, String string3) {
            char c2;
            int n2;
            if (string2 == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (string2.isEmpty()) {
                throw new IllegalArgumentException("name is empty");
            }
            int n3 = string2.length();
            for (n2 = 0; n2 < n3; ++n2) {
                c2 = string2.charAt(n2);
                if (c2 > '\u001f' && c2 < '\u007f') continue;
                throw new IllegalArgumentException(String.format("Unexpected char %#04x at %d in header name: %s", c2, n2, string2));
            }
            if (string3 == null) {
                throw new IllegalArgumentException("value == null");
            }
            n3 = string3.length();
            for (n2 = 0; n2 < n3; ++n2) {
                c2 = string3.charAt(n2);
                if (c2 > '\u001f' && c2 < '\u007f') continue;
                throw new IllegalArgumentException(String.format("Unexpected char %#04x at %d in header value: %s", c2, n2, string3));
            }
        }

        public Builder add(String string2) {
            int n2 = string2.indexOf(":");
            if (n2 == -1) {
                throw new IllegalArgumentException("Unexpected header: " + string2);
            }
            return this.add(string2.substring(0, n2).trim(), string2.substring(n2 + 1));
        }

        public Builder add(String string2, String string3) {
            this.checkNameAndValue(string2, string3);
            return this.addLenient(string2, string3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Builder addLenient(String object) {
            int n2 = ((String)object).indexOf(":", 1);
            if (n2 != -1) {
                return this.addLenient(((String)object).substring(0, n2), ((String)object).substring(n2 + 1));
            }
            if (!((String)object).startsWith(":")) return this.addLenient("", (String)object);
            return this.addLenient("", ((String)object).substring(1));
        }

        Builder addLenient(String string2, String string3) {
            this.namesAndValues.add(string2);
            this.namesAndValues.add(string3.trim());
            return this;
        }

        public Headers build() {
            return new Headers(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String get(String string2) {
            int n2 = this.namesAndValues.size() - 2;
            while (n2 >= 0) {
                if (string2.equalsIgnoreCase(this.namesAndValues.get(n2))) {
                    return this.namesAndValues.get(n2 + 1);
                }
                n2 -= 2;
            }
            return null;
        }

        public Builder removeAll(String string2) {
            int n2 = 0;
            while (n2 < this.namesAndValues.size()) {
                int n3 = n2;
                if (string2.equalsIgnoreCase(this.namesAndValues.get(n2))) {
                    this.namesAndValues.remove(n2);
                    this.namesAndValues.remove(n2);
                    n3 = n2 - 2;
                }
                n2 = n3 + 2;
            }
            return this;
        }

        public Builder set(String string2, String string3) {
            this.checkNameAndValue(string2, string3);
            this.removeAll(string2);
            this.addLenient(string2, string3);
            return this;
        }
    }
}

