/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.internal.Util;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import s.d;
import s.f;
import s.m;
import s.t;

public abstract class RequestBody {
    public static RequestBody create(final MediaType mediaType, final File file) {
        if (file == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            @Override
            public long contentLength() {
                return file.length();
            }

            @Override
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public void writeTo(d d2) throws IOException {
                t t2;
                t t3 = null;
                try {
                    t3 = t2 = m.a((File)file);
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(t3);
                    throw throwable;
                }
                d2.a(t2);
                Util.closeQuietly((Closeable)t2);
            }
        };
    }

    public static RequestBody create(MediaType mediaType, String string2) {
        Charset charset = Util.UTF_8;
        MediaType mediaType2 = mediaType;
        if (mediaType != null) {
            Charset charset2;
            charset = charset2 = mediaType.charset();
            mediaType2 = mediaType;
            if (charset2 == null) {
                charset = Util.UTF_8;
                mediaType2 = MediaType.parse(mediaType + "; charset=utf-8");
            }
        }
        return RequestBody.create(mediaType2, string2.getBytes(charset));
    }

    public static RequestBody create(final MediaType mediaType, final f f2) {
        return new RequestBody(){

            @Override
            public long contentLength() throws IOException {
                return f2.h();
            }

            @Override
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public void writeTo(d d2) throws IOException {
                d2.b(f2);
            }
        };
    }

    public static RequestBody create(MediaType mediaType, byte[] byArray) {
        return RequestBody.create(mediaType, byArray, 0, byArray.length);
    }

    public static RequestBody create(final MediaType mediaType, final byte[] byArray, final int n2, final int n3) {
        if (byArray == null) {
            throw new NullPointerException("content == null");
        }
        Util.checkOffsetAndCount(byArray.length, n2, n3);
        return new RequestBody(){

            @Override
            public long contentLength() {
                return n3;
            }

            @Override
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public void writeTo(d d2) throws IOException {
                d2.c(byArray, n2, n3);
            }
        };
    }

    public long contentLength() throws IOException {
        return -1L;
    }

    public abstract MediaType contentType();

    public abstract void writeTo(d var1) throws IOException;
}

