/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.NamedRunnable;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.framed.ErrorCode;
import com.squareup.okhttp.internal.framed.FrameReader;
import com.squareup.okhttp.internal.framed.FrameWriter;
import com.squareup.okhttp.internal.framed.FramedStream;
import com.squareup.okhttp.internal.framed.Header;
import com.squareup.okhttp.internal.framed.HeadersMode;
import com.squareup.okhttp.internal.framed.Http2;
import com.squareup.okhttp.internal.framed.Ping;
import com.squareup.okhttp.internal.framed.PushObserver;
import com.squareup.okhttp.internal.framed.Settings;
import com.squareup.okhttp.internal.framed.Spdy3;
import com.squareup.okhttp.internal.framed.Variant;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import s.c;
import s.d;
import s.e;
import s.f;
import s.m;
import s.s;
import s.t;

public final class FramedConnection
implements Closeable {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    private static final ExecutorService executor;
    long bytesLeftInWriteWindow;
    final boolean client;
    private final Set<Integer> currentPushRequests;
    final FrameWriter frameWriter;
    private final String hostName;
    private long idleStartTimeNs;
    private int lastGoodStreamId;
    private final Listener listener;
    private int nextPingId;
    private int nextStreamId;
    Settings okHttpSettings;
    final Settings peerSettings;
    private Map<Integer, Ping> pings;
    final Protocol protocol;
    private final ExecutorService pushExecutor;
    private final PushObserver pushObserver;
    final Reader readerRunnable;
    private boolean receivedInitialPeerSettings;
    private boolean shutdown;
    final Socket socket;
    private final Map<Integer, FramedStream> streams;
    long unacknowledgedBytesRead;
    final Variant variant;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !FramedConnection.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
        executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp FramedConnection", true));
    }

    /*
     * Enabled aggressive block sorting
     */
    private FramedConnection(Builder builder) throws IOException {
        int n2 = 2;
        this.streams = new HashMap<Integer, FramedStream>();
        this.idleStartTimeNs = System.nanoTime();
        this.unacknowledgedBytesRead = 0L;
        this.okHttpSettings = new Settings();
        this.peerSettings = new Settings();
        this.receivedInitialPeerSettings = false;
        this.currentPushRequests = new LinkedHashSet<Integer>();
        this.protocol = builder.protocol;
        this.pushObserver = builder.pushObserver;
        this.client = builder.client;
        this.listener = builder.listener;
        int n3 = builder.client ? 1 : 2;
        this.nextStreamId = n3;
        if (builder.client && this.protocol == Protocol.HTTP_2) {
            this.nextStreamId += 2;
        }
        n3 = n2;
        if (builder.client) {
            n3 = 1;
        }
        this.nextPingId = n3;
        if (builder.client) {
            this.okHttpSettings.set(7, 0, 0x1000000);
        }
        this.hostName = builder.hostName;
        if (this.protocol == Protocol.HTTP_2) {
            this.variant = new Http2();
            this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(String.format("OkHttp %s Push Observer", this.hostName), true));
            this.peerSettings.set(7, 0, 65535);
            this.peerSettings.set(5, 0, 16384);
        } else {
            if (this.protocol != Protocol.SPDY_3) {
                throw new AssertionError((Object)this.protocol);
            }
            this.variant = new Spdy3();
            this.pushExecutor = null;
        }
        this.bytesLeftInWriteWindow = this.peerSettings.getInitialWindowSize(65536);
        this.socket = builder.socket;
        this.frameWriter = this.variant.newWriter(builder.sink, this.client);
        this.readerRunnable = new Reader(this.variant.newReader(builder.source, this.client));
        new Thread(this.readerRunnable).start();
    }

    static /* synthetic */ boolean access$1602(FramedConnection framedConnection, boolean bl) {
        framedConnection.shutdown = bl;
        return bl;
    }

    static /* synthetic */ int access$1702(FramedConnection framedConnection, int n2) {
        framedConnection.lastGoodStreamId = n2;
        return n2;
    }

    static /* synthetic */ boolean access$2302(FramedConnection framedConnection, boolean bl) {
        framedConnection.receivedInitialPeerSettings = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void close(ErrorCode errorCode, ErrorCode errorCode2) throws IOException {
        block22: {
            Ping[] pingArray;
            FramedStream[] framedStreamArray;
            if (!$assertionsDisabled && Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            try {
                this.shutdown(errorCode);
                errorCode = null;
            }
            catch (IOException iOException) {}
            synchronized (this) {
                if (!this.streams.isEmpty()) {
                    framedStreamArray = this.streams.values().toArray(new FramedStream[this.streams.size()]);
                    this.streams.clear();
                    this.setIdle(false);
                } else {
                    framedStreamArray = null;
                }
                if (this.pings != null) {
                    pingArray = this.pings.values().toArray(new Ping[this.pings.size()]);
                    this.pings = null;
                } else {
                    pingArray = null;
                }
            }
            Object object2 = errorCode;
            if (framedStreamArray != null) {
                for (Object object2 : framedStreamArray) {
                    block21: {
                        try {
                            ((FramedStream)object2).close(errorCode2);
                            object2 = errorCode;
                        }
                        catch (IOException iOException) {
                            object2 = errorCode;
                            if (errorCode == null) break block21;
                            object2 = iOException;
                        }
                    }
                    errorCode = object2;
                }
                object2 = errorCode;
            }
            if (pingArray != null) {
                int n2 = pingArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    pingArray[i2].cancel();
                }
            }
            try {
                this.frameWriter.close();
                errorCode = object2;
            }
            catch (IOException iOException) {
                if (object2 == null) break block22;
                errorCode = object2;
            }
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
        if (errorCode != null) {
            throw errorCode;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private FramedStream newStream(int n2, List<Header> object, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = true;
        boolean bl4 = !bl;
        bl2 = !bl2 ? bl3 : false;
        FrameWriter frameWriter = this.frameWriter;
        // MONITORENTER : frameWriter
        // MONITORENTER : this
        if (this.shutdown) {
            object = new IOException("shutdown");
            throw object;
        }
        int n3 = this.nextStreamId;
        this.nextStreamId += 2;
        FramedStream framedStream = new FramedStream(n3, this, bl4, bl2, (List<Header>)object);
        if (framedStream.isOpen()) {
            this.streams.put(n3, framedStream);
            this.setIdle(false);
        }
        // MONITOREXIT : this
        if (n2 == 0) {
            this.frameWriter.synStream(bl4, bl2, n3, n2, (List<Header>)object);
        } else {
            if (this.client) {
                object = new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                throw object;
            }
            this.frameWriter.pushPromise(n2, n3, (List<Header>)object);
        }
        // MONITOREXIT : frameWriter
        if (bl) return framedStream;
        this.frameWriter.flush();
        return framedStream;
    }

    private void pushDataLater(final int n2, e e2, final int n3, final boolean bl) throws IOException {
        final c c2 = new c();
        e2.a((long)n3);
        e2.read(c2, (long)n3);
        if (c2.a() != (long)n3) {
            throw new IOException(c2.a() + " != " + n3);
        }
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Data[%s]", new Object[]{this.hostName, n2}){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void execute() {
                try {
                    boolean bl2 = FramedConnection.this.pushObserver.onData(n2, (e)c2, n3, bl);
                    if (bl2) {
                        FramedConnection.this.frameWriter.rstStream(n2, ErrorCode.CANCEL);
                    }
                    if (!bl2) {
                        if (!bl) return;
                    }
                    FramedConnection framedConnection = FramedConnection.this;
                    synchronized (framedConnection) {
                        FramedConnection.this.currentPushRequests.remove(n2);
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        });
    }

    private void pushHeadersLater(final int n2, final List<Header> list, final boolean bl) {
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Headers[%s]", new Object[]{this.hostName, n2}){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void execute() {
                var1_1 = FramedConnection.access$2700(FramedConnection.this).onHeaders(n2, list, bl);
                if (!var1_1) ** GOTO lbl5
                try {
                    FramedConnection.this.frameWriter.rstStream(n2, ErrorCode.CANCEL);
lbl5:
                    // 2 sources

                    if (!var1_1) {
                        if (bl == false) return;
                    }
                    var2_2 = FramedConnection.this;
                    synchronized (var2_2) {
                        FramedConnection.access$2800(FramedConnection.this).remove(n2);
                    }
                }
                catch (IOException var3_3) {
                    return;
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pushRequestLater(final int n2, final List<Header> list) {
        synchronized (this) {
            if (this.currentPushRequests.contains(n2)) {
                this.writeSynResetLater(n2, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(n2);
        }
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Request[%s]", new Object[]{this.hostName, n2}){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void execute() {
                if (!FramedConnection.this.pushObserver.onRequest(n2, list)) return;
                try {
                    FramedConnection.this.frameWriter.rstStream(n2, ErrorCode.CANCEL);
                    FramedConnection framedConnection = FramedConnection.this;
                    synchronized (framedConnection) {
                        FramedConnection.this.currentPushRequests.remove(n2);
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        });
    }

    private void pushResetLater(final int n2, final ErrorCode errorCode) {
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Reset[%s]", new Object[]{this.hostName, n2}){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void execute() {
                FramedConnection.this.pushObserver.onReset(n2, errorCode);
                FramedConnection framedConnection = FramedConnection.this;
                synchronized (framedConnection) {
                    FramedConnection.this.currentPushRequests.remove(n2);
                    return;
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean pushedStream(int n2) {
        if (this.protocol != Protocol.HTTP_2) return false;
        if (n2 == 0) return false;
        if ((n2 & 1) != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Ping removePing(int n2) {
        synchronized (this) {
            if (this.pings == null) return null;
            return this.pings.remove(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setIdle(boolean bl) {
        synchronized (this) {
            long l2 = bl ? System.nanoTime() : Long.MAX_VALUE;
            this.idleStartTimeNs = l2;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writePing(boolean bl, int n2, int n3, Ping ping) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            if (ping != null) {
                ping.send();
            }
            this.frameWriter.ping(bl, n2, n3);
            return;
        }
    }

    private void writePingLater(final boolean bl, final int n2, final int n3, final Ping ping) {
        executor.execute(new NamedRunnable("OkHttp %s ping %08x%08x", new Object[]{this.hostName, n2, n3}){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void execute() {
                try {
                    FramedConnection.this.writePing(bl, n2, n3, ping);
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        });
    }

    void addBytesToWriteWindow(long l2) {
        this.bytesLeftInWriteWindow += l2;
        if (l2 > 0L) {
            this.notifyAll();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    public void flush() throws IOException {
        this.frameWriter.flush();
    }

    public long getIdleStartTimeNs() {
        synchronized (this) {
            long l2 = this.idleStartTimeNs;
            return l2;
        }
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    FramedStream getStream(int n2) {
        synchronized (this) {
            FramedStream framedStream = this.streams.get(n2);
            return framedStream;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIdle() {
        synchronized (this) {
            long l2 = this.idleStartTimeNs;
            if (l2 == Long.MAX_VALUE) return false;
            return true;
        }
    }

    public int maxConcurrentStreams() {
        synchronized (this) {
            int n2 = this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
            return n2;
        }
    }

    public FramedStream newStream(List<Header> list, boolean bl, boolean bl2) throws IOException {
        return this.newStream(0, list, bl, bl2);
    }

    public int openStreamCount() {
        synchronized (this) {
            int n2 = this.streams.size();
            return n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Ping ping() throws IOException {
        int n2;
        Ping ping = new Ping();
        synchronized (this) {
            if (this.shutdown) {
                IOException iOException = new IOException("shutdown");
                throw iOException;
            }
            n2 = this.nextPingId;
            this.nextPingId += 2;
            if (this.pings == null) {
                HashMap<Integer, Ping> hashMap = new HashMap<Integer, Ping>();
                this.pings = hashMap;
            }
            this.pings.put(n2, ping);
        }
        this.writePing(false, n2, 1330343787, ping);
        return ping;
    }

    public FramedStream pushStream(int n2, List<Header> list, boolean bl) throws IOException {
        if (this.client) {
            throw new IllegalStateException("Client cannot push requests.");
        }
        if (this.protocol != Protocol.HTTP_2) {
            throw new IllegalStateException("protocol != HTTP_2");
        }
        return this.newStream(n2, list, bl, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    FramedStream removeStream(int n2) {
        synchronized (this) {
            FramedStream framedStream = this.streams.remove(n2);
            if (framedStream != null && this.streams.isEmpty()) {
                this.setIdle(true);
            }
            this.notifyAll();
            return framedStream;
        }
    }

    public void sendConnectionPreface() throws IOException {
        this.frameWriter.connectionPreface();
        this.frameWriter.settings(this.okHttpSettings);
        int n2 = this.okHttpSettings.getInitialWindowSize(65536);
        if (n2 != 65536) {
            this.frameWriter.windowUpdate(0, n2 - 65536);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSettings(Settings object) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            synchronized (this) {
                if (this.shutdown) {
                    object = new IOException("shutdown");
                    throw object;
                }
                this.okHttpSettings.merge((Settings)object);
                this.frameWriter.settings((Settings)object);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown(ErrorCode errorCode) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int n2;
            synchronized (this) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                n2 = this.lastGoodStreamId;
            }
            this.frameWriter.goAway(n2, errorCode, Util.EMPTY_BYTE_ARRAY);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeData(int var1_1, boolean var2_2, c var3_3, long var4_6) throws IOException {
        var6_7 = var4_6;
        if (var4_6 == 0L) {
            this.frameWriter.data(var2_2, var1_1, var3_3 /* !! */ , 0);
            return;
        }
        while (true) lbl-1000:
        // 2 sources

        {
            if (var6_7 <= 0L) ** continue;
            synchronized (this) {
                while (true) {
                    try {
                        block11: {
                            if (this.bytesLeftInWriteWindow > 0L) break block11;
                            if (!this.streams.containsKey(var1_1)) {
                                var3_3 /* !! */  = new IOException("stream closed");
                                throw var3_3 /* !! */ ;
                            }
                            ** GOTO lbl-1000
                        }
                        var8_8 = Math.min((int)Math.min(var6_7, this.bytesLeftInWriteWindow), this.frameWriter.maxDataLength());
                        this.bytesLeftInWriteWindow -= (long)var8_8;
                        // MONITOREXIT @DISABLED, blocks:[2, 4, 7, 8] lbl18 : MonitorExitStatement: MONITOREXIT : this
                        var9_9 = this.frameWriter;
                        var10_10 = var2_2 != false && (var6_7 -= (long)var8_8) == 0L;
                        var9_9.data(var10_10, var1_1, var3_3 /* !! */ , var8_8);
                        ** continue;
                    }
                    catch (InterruptedException var3_4) {
                        var3_5 = new InterruptedIOException();
                        throw var3_5;
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.wait();
                        continue;
                    }
                    break;
                }
            }
            break;
        }
    }

    void writeSynReply(int n2, boolean bl, List<Header> list) throws IOException {
        this.frameWriter.synReply(bl, n2, list);
    }

    void writeSynReset(int n2, ErrorCode errorCode) throws IOException {
        this.frameWriter.rstStream(n2, errorCode);
    }

    void writeSynResetLater(final int n2, final ErrorCode errorCode) {
        executor.submit(new NamedRunnable("OkHttp %s stream %d", new Object[]{this.hostName, n2}){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void execute() {
                try {
                    FramedConnection.this.writeSynReset(n2, errorCode);
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        });
    }

    void writeWindowUpdateLater(final int n2, final long l2) {
        executor.execute(new NamedRunnable("OkHttp Window Update %s stream %d", new Object[]{this.hostName, n2}){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void execute() {
                try {
                    FramedConnection.this.frameWriter.windowUpdate(n2, l2);
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        });
    }

    public static class Builder {
        private boolean client;
        private String hostName;
        private Listener listener = Listener.REFUSE_INCOMING_STREAMS;
        private Protocol protocol = Protocol.SPDY_3;
        private PushObserver pushObserver = PushObserver.CANCEL;
        private d sink;
        private Socket socket;
        private e source;

        public Builder(boolean bl) throws IOException {
            this.client = bl;
        }

        public FramedConnection build() throws IOException {
            return new FramedConnection(this);
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public Builder socket(Socket socket) throws IOException {
            return this.socket(socket, ((InetSocketAddress)socket.getRemoteSocketAddress()).getHostName(), m.a((t)m.b((Socket)socket)), m.a((s)m.a((Socket)socket)));
        }

        public Builder socket(Socket socket, String string2, e e2, d d2) {
            this.socket = socket;
            this.hostName = string2;
            this.source = e2;
            this.sink = d2;
            return this;
        }
    }

    public static abstract class Listener {
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            @Override
            public void onStream(FramedStream framedStream) throws IOException {
                framedStream.close(ErrorCode.REFUSED_STREAM);
            }
        };

        public void onSettings(FramedConnection framedConnection) {
        }

        public abstract void onStream(FramedStream var1) throws IOException;
    }

    class Reader
    extends NamedRunnable
    implements FrameReader.Handler {
        final FrameReader frameReader;

        private Reader(FrameReader frameReader) {
            super("OkHttp %s", FramedConnection.this.hostName);
            this.frameReader = frameReader;
        }

        private void ackSettingsLater(final Settings settings) {
            executor.execute(new NamedRunnable("OkHttp %s ACK Settings", new Object[]{FramedConnection.this.hostName}){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void execute() {
                    try {
                        FramedConnection.this.frameWriter.ackSettings(settings);
                        return;
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            });
        }

        @Override
        public void ackSettings() {
        }

        @Override
        public void alternateService(int n2, String string2, f f2, String string3, int n3, long l2) {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void data(boolean bl, int n2, e e2, int n3) throws IOException {
            if (FramedConnection.this.pushedStream(n2)) {
                FramedConnection.this.pushDataLater(n2, e2, n3, bl);
                return;
            }
            FramedStream framedStream = FramedConnection.this.getStream(n2);
            if (framedStream == null) {
                FramedConnection.this.writeSynResetLater(n2, ErrorCode.INVALID_STREAM);
                e2.g((long)n3);
                return;
            }
            framedStream.receiveData(e2, n3);
            if (!bl) return;
            framedStream.receiveFin();
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void execute() {
            block14: {
                ErrorCode errorCode = ErrorCode.INTERNAL_ERROR;
                ErrorCode errorCode2 = ErrorCode.INTERNAL_ERROR;
                ErrorCode errorCode3 = errorCode;
                Object object = errorCode;
                if (!FramedConnection.this.client) {
                    errorCode3 = errorCode;
                    object = errorCode;
                    this.frameReader.readConnectionPreface();
                }
                do {
                    errorCode3 = errorCode;
                    object = errorCode;
                } while (this.frameReader.nextFrame(this));
                errorCode3 = errorCode;
                object = errorCode;
                errorCode3 = errorCode = ErrorCode.NO_ERROR;
                object = errorCode;
                ErrorCode errorCode4 = ErrorCode.CANCEL;
                FramedConnection.this.close(errorCode, errorCode4);
                break block14;
                catch (IOException iOException) {
                    object = errorCode3;
                    try {
                        errorCode3 = ErrorCode.PROTOCOL_ERROR;
                    }
                    catch (Throwable throwable) {
                        errorCode3 = object;
                        object = throwable;
                        try {
                            FramedConnection.this.close(errorCode3, errorCode2);
                        }
                        catch (IOException iOException2) {}
                        Util.closeQuietly(this.frameReader);
                        throw object;
                    }
                    object = ErrorCode.PROTOCOL_ERROR;
                    {
                        catch (Throwable throwable) {}
                    }
                    try {
                        FramedConnection.this.close(errorCode3, object);
                    }
                    catch (IOException iOException3) {}
                    Util.closeQuietly(this.frameReader);
                    return;
                }
                catch (IOException iOException) {}
            }
            Util.closeQuietly(this.frameReader);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void goAway(int n2, ErrorCode object, f framedStreamArray) {
            if (framedStreamArray.h() > 0) {
                // empty if block
            }
            object = FramedConnection.this;
            synchronized (object) {
                framedStreamArray = FramedConnection.this.streams.values().toArray(new FramedStream[FramedConnection.this.streams.size()]);
                FramedConnection.access$1602(FramedConnection.this, true);
            }
            int n3 = framedStreamArray.length;
            int n4 = 0;
            while (n4 < n3) {
                object = framedStreamArray[n4];
                if (((FramedStream)object).getId() > n2 && ((FramedStream)object).isLocallyInitiated()) {
                    ((FramedStream)object).receiveRstStream(ErrorCode.REFUSED_STREAM);
                    FramedConnection.this.removeStream(((FramedStream)object).getId());
                }
                ++n4;
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void headers(boolean bl, boolean bl2, int n2, int n3, List<Header> namedRunnable, HeadersMode object) {
            if (FramedConnection.this.pushedStream(n2)) {
                FramedConnection.this.pushHeadersLater(n2, (List)((Object)namedRunnable), bl2);
                return;
            }
            FramedConnection framedConnection = FramedConnection.this;
            // MONITORENTER : framedConnection
            if (FramedConnection.this.shutdown) {
                // MONITOREXIT : framedConnection
                return;
            }
            Object object2 = FramedConnection.this.getStream(n2);
            if (object2 == null) {
                if (((HeadersMode)((Object)object)).failIfStreamAbsent()) {
                    FramedConnection.this.writeSynResetLater(n2, ErrorCode.INVALID_STREAM);
                    // MONITOREXIT : framedConnection
                    return;
                }
                if (n2 <= FramedConnection.this.lastGoodStreamId) {
                    // MONITOREXIT : framedConnection
                    return;
                }
                if (n2 % 2 == FramedConnection.this.nextStreamId % 2) {
                    // MONITOREXIT : framedConnection
                    return;
                }
                object = new FramedStream(n2, FramedConnection.this, bl, bl2, (List<Header>)((Object)namedRunnable));
                FramedConnection.access$1702(FramedConnection.this, n2);
                FramedConnection.this.streams.put(n2, object);
                object2 = executor;
                namedRunnable = new NamedRunnable("OkHttp %s stream %d", new Object[]{FramedConnection.this.hostName, n2}, (FramedStream)object){
                    final /* synthetic */ FramedStream val$newStream;
                    {
                        this.val$newStream = framedStream;
                        super(string2, objectArray);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void execute() {
                        try {
                            FramedConnection.this.listener.onStream(this.val$newStream);
                            return;
                        }
                        catch (IOException iOException) {
                            Internal.logger.log(Level.INFO, "FramedConnection.Listener failure for " + FramedConnection.this.hostName, iOException);
                            try {
                                this.val$newStream.close(ErrorCode.PROTOCOL_ERROR);
                                return;
                            }
                            catch (IOException iOException2) {
                                return;
                            }
                        }
                    }
                };
                object2.execute(namedRunnable);
                // MONITOREXIT : framedConnection
                return;
            }
            // MONITOREXIT : framedConnection
            if (((HeadersMode)((Object)object)).failIfStreamPresent()) {
                ((FramedStream)object2).closeLater(ErrorCode.PROTOCOL_ERROR);
                FramedConnection.this.removeStream(n2);
                return;
            }
            ((FramedStream)object2).receiveHeaders((List<Header>)((Object)namedRunnable), (HeadersMode)((Object)object));
            if (!bl2) return;
            ((FramedStream)object2).receiveFin();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void ping(boolean bl, int n2, int n3) {
            if (bl) {
                Ping ping = FramedConnection.this.removePing(n2);
                if (ping != null) {
                    ping.receive();
                }
                return;
            }
            FramedConnection.this.writePingLater(true, n2, n3, null);
        }

        @Override
        public void priority(int n2, int n3, int n4, boolean bl) {
        }

        @Override
        public void pushPromise(int n2, int n3, List<Header> list) {
            FramedConnection.this.pushRequestLater(n3, list);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void rstStream(int n2, ErrorCode errorCode) {
            if (FramedConnection.this.pushedStream(n2)) {
                FramedConnection.this.pushResetLater(n2, errorCode);
                return;
            }
            FramedStream framedStream = FramedConnection.this.removeStream(n2);
            if (framedStream == null) return;
            framedStream.receiveRstStream(errorCode);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void settings(boolean bl, Settings object) {
            long l2;
            int n2;
            Object object2 = FramedConnection.this;
            // MONITORENTER : object2
            int n3 = FramedConnection.this.peerSettings.getInitialWindowSize(65536);
            if (bl) {
                FramedConnection.this.peerSettings.clear();
            }
            FramedConnection.this.peerSettings.merge((Settings)object);
            if (FramedConnection.this.getProtocol() == Protocol.HTTP_2) {
                this.ackSettingsLater((Settings)object);
            }
            if ((n2 = FramedConnection.this.peerSettings.getInitialWindowSize(65536)) != -1 && n2 != n3) {
                l2 = n2 - n3;
                if (!FramedConnection.this.receivedInitialPeerSettings) {
                    FramedConnection.this.addBytesToWriteWindow(l2);
                    FramedConnection.access$2302(FramedConnection.this, true);
                }
                object = !FramedConnection.this.streams.isEmpty() ? FramedConnection.this.streams.values().toArray(new FramedStream[FramedConnection.this.streams.size()]) : null;
            } else {
                object = null;
                l2 = 0L;
            }
            ExecutorService executorService = executor;
            NamedRunnable namedRunnable = new NamedRunnable("OkHttp %s settings", new Object[]{FramedConnection.this.hostName}){

                @Override
                public void execute() {
                    FramedConnection.this.listener.onSettings(FramedConnection.this);
                }
            };
            executorService.execute(namedRunnable);
            // MONITOREXIT : object2
            if (object == null) return;
            if (l2 == 0L) return;
            n3 = ((FramedStream[])object).length;
            n2 = 0;
            while (n2 < n3) {
                object2 = object[n2];
                // MONITORENTER : object2
                ((FramedStream)object2).addBytesToWriteWindow(l2);
                // MONITOREXIT : object2
                ++n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void windowUpdate(int n2, long l2) {
            if (n2 == 0) {
                FramedConnection framedConnection = FramedConnection.this;
                synchronized (framedConnection) {
                    FramedConnection framedConnection2 = FramedConnection.this;
                    framedConnection2.bytesLeftInWriteWindow += l2;
                    FramedConnection.this.notifyAll();
                    return;
                }
            }
            FramedStream framedStream = FramedConnection.this.getStream(n2);
            if (framedStream == null) return;
            synchronized (framedStream) {
                framedStream.addBytesToWriteWindow(l2);
                return;
            }
        }
    }
}

