/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class Ping {
    private final CountDownLatch latch = new CountDownLatch(1);
    private long received = -1L;
    private long sent = -1L;

    Ping() {
    }

    void cancel() {
        if (this.received != -1L || this.sent == -1L) {
            throw new IllegalStateException();
        }
        this.received = this.sent - 1L;
        this.latch.countDown();
    }

    void receive() {
        if (this.received != -1L || this.sent == -1L) {
            throw new IllegalStateException();
        }
        this.received = System.nanoTime();
        this.latch.countDown();
    }

    public long roundTripTime() throws InterruptedException {
        this.latch.await();
        return this.received - this.sent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long roundTripTime(long l2, TimeUnit timeUnit) throws InterruptedException {
        if (!this.latch.await(l2, timeUnit)) return -2L;
        return this.received - this.sent;
    }

    void send() {
        if (this.sent != -1L) {
            throw new IllegalStateException();
        }
        this.sent = System.nanoTime();
    }
}

