/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.CacheControl;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.http.HeaderParser;
import com.squareup.okhttp.internal.http.HttpDate;
import com.squareup.okhttp.internal.http.OkHeaders;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class CacheStrategy {
    public final Response cacheResponse;
    public final Request networkRequest;

    private CacheStrategy(Request request, Response response) {
        this.networkRequest = request;
        this.cacheResponse = response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCacheable(Response response, Request request) {
        boolean bl;
        boolean bl2 = false;
        switch (response.code()) {
            default: {
                return bl2;
            }
            case 302: 
            case 307: {
                if (response.header("Expires") != null || response.cacheControl().maxAgeSeconds() != -1 || response.cacheControl().isPublic()) break;
                bl = bl2;
                if (!response.cacheControl().isPrivate()) return bl;
            }
            case 200: 
            case 203: 
            case 204: 
            case 300: 
            case 301: 
            case 308: 
            case 404: 
            case 405: 
            case 410: 
            case 414: 
            case 501: 
        }
        bl = bl2;
        if (response.cacheControl().noStore()) return bl;
        bl = bl2;
        if (request.cacheControl().noStore()) return bl;
        return true;
    }

    public static class Factory {
        private int ageSeconds = -1;
        final Response cacheResponse;
        private String etag;
        private Date expires;
        private Date lastModified;
        private String lastModifiedString;
        final long nowMillis;
        private long receivedResponseMillis;
        final Request request;
        private long sentRequestMillis;
        private Date servedDate;
        private String servedDateString;

        /*
         * Enabled aggressive block sorting
         */
        public Factory(long l2, Request object, Response object2) {
            this.nowMillis = l2;
            this.request = object;
            this.cacheResponse = object2;
            if (object2 != null) {
                Headers headers = ((Response)object2).headers();
                int n2 = headers.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    object = headers.name(i2);
                    object2 = headers.value(i2);
                    if ("Date".equalsIgnoreCase((String)object)) {
                        this.servedDate = HttpDate.parse((String)object2);
                        this.servedDateString = object2;
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase((String)object)) {
                        this.expires = HttpDate.parse((String)object2);
                        continue;
                    }
                    if ("Last-Modified".equalsIgnoreCase((String)object)) {
                        this.lastModified = HttpDate.parse((String)object2);
                        this.lastModifiedString = object2;
                        continue;
                    }
                    if ("ETag".equalsIgnoreCase((String)object)) {
                        this.etag = object2;
                        continue;
                    }
                    if ("Age".equalsIgnoreCase((String)object)) {
                        this.ageSeconds = HeaderParser.parseSeconds((String)object2, -1);
                        continue;
                    }
                    if (OkHeaders.SENT_MILLIS.equalsIgnoreCase((String)object)) {
                        this.sentRequestMillis = Long.parseLong((String)object2);
                        continue;
                    }
                    if (!OkHeaders.RECEIVED_MILLIS.equalsIgnoreCase((String)object)) continue;
                    this.receivedResponseMillis = Long.parseLong((String)object2);
                }
            }
        }

        private long cacheResponseAge() {
            long l2 = 0L;
            if (this.servedDate != null) {
                l2 = Math.max(0L, this.receivedResponseMillis - this.servedDate.getTime());
            }
            long l3 = l2;
            if (this.ageSeconds != -1) {
                l3 = Math.max(l2, TimeUnit.SECONDS.toMillis(this.ageSeconds));
            }
            return l3 + (this.receivedResponseMillis - this.sentRequestMillis) + (this.nowMillis - this.receivedResponseMillis);
        }

        /*
         * Enabled aggressive block sorting
         */
        private long computeFreshnessLifetime() {
            long l2;
            long l3 = 0L;
            CacheControl cacheControl = this.cacheResponse.cacheControl();
            if (cacheControl.maxAgeSeconds() != -1) {
                return TimeUnit.SECONDS.toMillis(cacheControl.maxAgeSeconds());
            }
            if (this.expires != null) {
                l2 = this.servedDate != null ? this.servedDate.getTime() : this.receivedResponseMillis;
                l2 = this.expires.getTime() - l2;
                if (l2 <= 0L) return 0L;
                return l2;
            }
            l2 = l3;
            if (this.lastModified == null) return l2;
            l2 = l3;
            if (this.cacheResponse.request().httpUrl().query() != null) return l2;
            l2 = this.servedDate != null ? this.servedDate.getTime() : this.sentRequestMillis;
            long l4 = l2 - this.lastModified.getTime();
            l2 = l3;
            if (l4 <= 0L) return l2;
            return l4 / 10L;
        }

        /*
         * Enabled aggressive block sorting
         */
        private CacheStrategy getCandidate() {
            long l2;
            long l3 = 0L;
            if (this.cacheResponse == null) {
                return new CacheStrategy(this.request, null);
            }
            if (this.request.isHttps() && this.cacheResponse.handshake() == null) {
                return new CacheStrategy(this.request, null);
            }
            if (!CacheStrategy.isCacheable(this.cacheResponse, this.request)) {
                return new CacheStrategy(this.request, null);
            }
            Object object = this.request.cacheControl();
            if (((CacheControl)object).noCache()) return new CacheStrategy(this.request, null);
            if (Factory.hasConditions(this.request)) {
                return new CacheStrategy(this.request, null);
            }
            long l4 = this.cacheResponseAge();
            long l5 = l2 = this.computeFreshnessLifetime();
            if (((CacheControl)object).maxAgeSeconds() != -1) {
                l5 = Math.min(l2, TimeUnit.SECONDS.toMillis(((CacheControl)object).maxAgeSeconds()));
            }
            l2 = ((CacheControl)object).minFreshSeconds() != -1 ? TimeUnit.SECONDS.toMillis(((CacheControl)object).minFreshSeconds()) : 0L;
            CacheControl cacheControl = this.cacheResponse.cacheControl();
            long l6 = l3;
            if (!cacheControl.mustRevalidate()) {
                l6 = l3;
                if (((CacheControl)object).maxStaleSeconds() != -1) {
                    l6 = TimeUnit.SECONDS.toMillis(((CacheControl)object).maxStaleSeconds());
                }
            }
            if (!cacheControl.noCache() && l4 + l2 < l6 + l5) {
                object = this.cacheResponse.newBuilder();
                if (l2 + l4 >= l5) {
                    ((Response.Builder)object).addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                }
                if (l4 <= 86400000L) return new CacheStrategy(null, ((Response.Builder)object).build());
                if (!this.isFreshnessLifetimeHeuristic()) return new CacheStrategy(null, ((Response.Builder)object).build());
                ((Response.Builder)object).addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                return new CacheStrategy(null, ((Response.Builder)object).build());
            }
            object = this.request.newBuilder();
            if (this.etag != null) {
                ((Request.Builder)object).header("If-None-Match", this.etag);
            } else if (this.lastModified != null) {
                ((Request.Builder)object).header("If-Modified-Since", this.lastModifiedString);
            } else if (this.servedDate != null) {
                ((Request.Builder)object).header("If-Modified-Since", this.servedDateString);
            }
            if (!Factory.hasConditions((Request)(object = ((Request.Builder)object).build()))) return new CacheStrategy((Request)object, null);
            return new CacheStrategy((Request)object, this.cacheResponse);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean hasConditions(Request request) {
            if (request.header("If-Modified-Since") != null) return true;
            if (request.header("If-None-Match") == null) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isFreshnessLifetimeHeuristic() {
            if (this.cacheResponse.cacheControl().maxAgeSeconds() != -1) return false;
            if (this.expires != null) return false;
            return true;
        }

        public CacheStrategy get() {
            CacheStrategy cacheStrategy;
            CacheStrategy cacheStrategy2 = cacheStrategy = this.getCandidate();
            if (cacheStrategy.networkRequest != null) {
                cacheStrategy2 = cacheStrategy;
                if (this.request.cacheControl().onlyIfCached()) {
                    cacheStrategy2 = new CacheStrategy(null, null);
                }
            }
            return cacheStrategy2;
        }
    }
}

