/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.framed.ErrorCode;
import com.squareup.okhttp.internal.framed.FramedConnection;
import com.squareup.okhttp.internal.framed.FramedStream;
import com.squareup.okhttp.internal.framed.Header;
import com.squareup.okhttp.internal.http.HttpEngine;
import com.squareup.okhttp.internal.http.HttpStream;
import com.squareup.okhttp.internal.http.RealResponseBody;
import com.squareup.okhttp.internal.http.RequestLine;
import com.squareup.okhttp.internal.http.RetryableSink;
import com.squareup.okhttp.internal.http.StatusLine;
import com.squareup.okhttp.internal.http.StreamAllocation;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import s.f;
import s.i;
import s.m;
import s.s;
import s.t;

public final class Http2xStream
implements HttpStream {
    private static final f CONNECTION = f.a((String)"connection");
    private static final f ENCODING;
    private static final f HOST;
    private static final List<f> HTTP_2_SKIPPED_REQUEST_HEADERS;
    private static final List<f> HTTP_2_SKIPPED_RESPONSE_HEADERS;
    private static final f KEEP_ALIVE;
    private static final f PROXY_CONNECTION;
    private static final List<f> SPDY_3_SKIPPED_REQUEST_HEADERS;
    private static final List<f> SPDY_3_SKIPPED_RESPONSE_HEADERS;
    private static final f TE;
    private static final f TRANSFER_ENCODING;
    private static final f UPGRADE;
    private final FramedConnection framedConnection;
    private HttpEngine httpEngine;
    private FramedStream stream;
    private final StreamAllocation streamAllocation;

    static {
        HOST = f.a((String)"host");
        KEEP_ALIVE = f.a((String)"keep-alive");
        PROXY_CONNECTION = f.a((String)"proxy-connection");
        TRANSFER_ENCODING = f.a((String)"transfer-encoding");
        TE = f.a((String)"te");
        ENCODING = f.a((String)"encoding");
        UPGRADE = f.a((String)"upgrade");
        SPDY_3_SKIPPED_REQUEST_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TRANSFER_ENCODING, Header.TARGET_METHOD, Header.TARGET_PATH, Header.TARGET_SCHEME, Header.TARGET_AUTHORITY, Header.TARGET_HOST, Header.VERSION);
        SPDY_3_SKIPPED_RESPONSE_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TRANSFER_ENCODING);
        HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE, Header.TARGET_METHOD, Header.TARGET_PATH, Header.TARGET_SCHEME, Header.TARGET_AUTHORITY, Header.TARGET_HOST, Header.VERSION);
        HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE);
    }

    public Http2xStream(StreamAllocation streamAllocation, FramedConnection framedConnection) {
        this.streamAllocation = streamAllocation;
        this.framedConnection = framedConnection;
    }

    public static List<Header> http2HeadersList(Request request) {
        Headers headers = request.headers();
        ArrayList<Header> arrayList = new ArrayList<Header>(headers.size() + 4);
        arrayList.add(new Header(Header.TARGET_METHOD, request.method()));
        arrayList.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request.httpUrl())));
        arrayList.add(new Header(Header.TARGET_AUTHORITY, Util.hostHeader(request.httpUrl())));
        arrayList.add(new Header(Header.TARGET_SCHEME, request.httpUrl().scheme()));
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            request = f.a((String)headers.name(i2).toLowerCase(Locale.US));
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(request)) continue;
            arrayList.add(new Header((f)request, headers.value(i2)));
        }
        return arrayList;
    }

    private static String joinOnNull(String string2, String string3) {
        return string2 + '\u0000' + string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Response.Builder readHttp2HeadersList(List<Header> object) throws IOException {
        String string2 = null;
        Headers.Builder builder = new Headers.Builder();
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            f f2 = ((Header)object.get((int)i2)).name;
            String string3 = ((Header)object.get((int)i2)).value.a();
            if (f2.equals((Object)Header.RESPONSE_STATUS)) {
                string2 = string3;
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(f2)) continue;
            builder.add(f2.a(), string3);
        }
        if (string2 == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        object = StatusLine.parse("HTTP/1.1 " + string2);
        return new Response.Builder().protocol(Protocol.HTTP_2).code(((StatusLine)object).code).message(((StatusLine)object).message).headers(builder.build());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Response.Builder readSpdy3HeadersList(List<Header> object) throws IOException {
        String string2 = null;
        String string3 = "HTTP/1.1";
        Headers.Builder builder = new Headers.Builder();
        int n2 = object.size();
        int n3 = 0;
        while (true) {
            int n4;
            String string4;
            f f2;
            if (n3 < n2) {
                f2 = ((Header)object.get((int)n3)).name;
                string4 = ((Header)object.get((int)n3)).value.a();
                n4 = 0;
            } else {
                if (string2 == null) {
                    throw new ProtocolException("Expected ':status' header not present");
                }
                object = StatusLine.parse(string3 + " " + string2);
                return new Response.Builder().protocol(Protocol.SPDY_3).code(((StatusLine)object).code).message(((StatusLine)object).message).headers(builder.build());
            }
            while (n4 < string4.length()) {
                int n5;
                int n6 = n5 = string4.indexOf(0, n4);
                if (n5 == -1) {
                    n6 = string4.length();
                }
                String string5 = string4.substring(n4, n6);
                if (f2.equals((Object)Header.RESPONSE_STATUS)) {
                    string2 = string5;
                } else if (f2.equals((Object)Header.VERSION)) {
                    string3 = string5;
                } else if (!SPDY_3_SKIPPED_RESPONSE_HEADERS.contains(f2)) {
                    builder.add(f2.a(), string5);
                }
                n4 = n6 + 1;
            }
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static List<Header> spdy3HeadersList(Request var0) {
        var1_1 = var0.headers();
        var2_2 = new ArrayList<Header>(var1_1.size() + 5);
        var2_2.add(new Header(Header.TARGET_METHOD, var0.method()));
        var2_2.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(var0.httpUrl())));
        var2_2.add(new Header(Header.VERSION, "HTTP/1.1"));
        var2_2.add(new Header(Header.TARGET_HOST, Util.hostHeader(var0.httpUrl())));
        var2_2.add(new Header(Header.TARGET_SCHEME, var0.httpUrl().scheme()));
        var3_3 = new LinkedHashSet<f>();
        var4_4 = var1_1.size();
        block0: for (var5_5 = 0; var5_5 < var4_4; ++var5_5) {
            block5: {
                var6_6 = f.a((String)var1_1.name(var5_5).toLowerCase(Locale.US));
                if (Http2xStream.SPDY_3_SKIPPED_REQUEST_HEADERS.contains(var6_6)) lbl-1000:
                // 4 sources

                {
                    continue block0;
                }
                var0 = var1_1.value(var5_5);
                if (!var3_3.add(var6_6)) break block5;
                var2_2.add(new Header(var6_6, (String)var0));
                ** GOTO lbl-1000
            }
            var7_7 = 0;
            while (true) {
                if (var7_7 >= var2_2.size()) ** GOTO lbl-1000
                if (((Header)var2_2.get((int)var7_7)).name.equals((Object)var6_6)) {
                    var2_2.set(var7_7, new Header(var6_6, Http2xStream.joinOnNull(((Header)var2_2.get((int)var7_7)).value.a(), (String)var0)));
                    ** continue;
                }
                ++var7_7;
            }
        }
        return var2_2;
    }

    @Override
    public void cancel() {
        if (this.stream != null) {
            this.stream.closeLater(ErrorCode.CANCEL);
        }
    }

    @Override
    public s createRequestBody(Request request, long l2) throws IOException {
        return this.stream.getSink();
    }

    @Override
    public void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public ResponseBody openResponseBody(Response response) throws IOException {
        StreamFinishingSource streamFinishingSource = new StreamFinishingSource(this.stream.getSource());
        return new RealResponseBody(response.headers(), m.a((t)streamFinishingSource));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Response.Builder readResponseHeaders() throws IOException {
        if (this.framedConnection.getProtocol() != Protocol.HTTP_2) return Http2xStream.readSpdy3HeadersList(this.stream.getResponseHeaders());
        return Http2xStream.readHttp2HeadersList(this.stream.getResponseHeaders());
    }

    @Override
    public void setHttpEngine(HttpEngine httpEngine) {
        this.httpEngine = httpEngine;
    }

    @Override
    public void writeRequestBody(RetryableSink retryableSink) throws IOException {
        retryableSink.writeToSocket(this.stream.getSink());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeRequestHeaders(Request list) throws IOException {
        if (this.stream != null) {
            return;
        }
        this.httpEngine.writingRequestHeaders();
        boolean bl = this.httpEngine.permitsRequestBody((Request)((Object)list));
        list = this.framedConnection.getProtocol() == Protocol.HTTP_2 ? Http2xStream.http2HeadersList(list) : Http2xStream.spdy3HeadersList(list);
        this.stream = this.framedConnection.newStream(list, bl, true);
        this.stream.readTimeout().timeout((long)this.httpEngine.client.getReadTimeout(), TimeUnit.MILLISECONDS);
        this.stream.writeTimeout().timeout((long)this.httpEngine.client.getWriteTimeout(), TimeUnit.MILLISECONDS);
    }

    class StreamFinishingSource
    extends i {
        public StreamFinishingSource(t t2) {
            super(t2);
        }

        public void close() throws IOException {
            Http2xStream.this.streamAllocation.streamFinished(Http2xStream.this);
            super.close();
        }
    }
}

