/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Challenge;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HeaderParser;
import java.io.IOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class OkHeaders {
    private static final Comparator<String> FIELD_NAME_COMPARATOR = new Comparator<String>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(String string2, String string3) {
            if (string2 == string3) {
                return 0;
            }
            if (string2 == null) {
                return -1;
            }
            if (string3 != null) return String.CASE_INSENSITIVE_ORDER.compare(string2, string3);
            return 1;
        }
    };
    static final String PREFIX = Platform.get().getPrefix();
    public static final String RECEIVED_MILLIS;
    public static final String RESPONSE_SOURCE;
    public static final String SELECTED_PROTOCOL;
    public static final String SENT_MILLIS;

    static {
        SENT_MILLIS = PREFIX + "-Sent-Millis";
        RECEIVED_MILLIS = PREFIX + "-Received-Millis";
        SELECTED_PROTOCOL = PREFIX + "-Selected-Protocol";
        RESPONSE_SOURCE = PREFIX + "-Response-Source";
    }

    private OkHeaders() {
    }

    public static void addCookies(Request.Builder builder, Map<String, List<String>> entry2) {
        for (Map.Entry<String, List<String>> entry2 : entry2.entrySet()) {
            String string2 = (String)entry2.getKey();
            if (!"Cookie".equalsIgnoreCase(string2) && !"Cookie2".equalsIgnoreCase(string2) || ((List)entry2.getValue()).isEmpty()) continue;
            builder.addHeader(string2, OkHeaders.buildCookieHeader((List)entry2.getValue()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildCookieHeader(List<String> object) {
        if (object.size() == 1) {
            return (String)object.get(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = object.size();
        int n3 = 0;
        while (n3 < n2) {
            if (n3 > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append((String)object.get(n3));
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static long contentLength(Headers headers) {
        return OkHeaders.stringToLong(headers.get("Content-Length"));
    }

    public static long contentLength(Request request) {
        return OkHeaders.contentLength(request.headers());
    }

    public static long contentLength(Response response) {
        return OkHeaders.contentLength(response.headers());
    }

    public static boolean hasVaryAll(Headers headers) {
        return OkHeaders.varyFields(headers).contains("*");
    }

    public static boolean hasVaryAll(Response response) {
        return OkHeaders.hasVaryAll(response.headers());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isEndToEnd(String string2) {
        if ("Connection".equalsIgnoreCase(string2)) return false;
        if ("Keep-Alive".equalsIgnoreCase(string2)) return false;
        if ("Proxy-Authenticate".equalsIgnoreCase(string2)) return false;
        if ("Proxy-Authorization".equalsIgnoreCase(string2)) return false;
        if ("TE".equalsIgnoreCase(string2)) return false;
        if ("Trailers".equalsIgnoreCase(string2)) return false;
        if ("Transfer-Encoding".equalsIgnoreCase(string2)) return false;
        if ("Upgrade".equalsIgnoreCase(string2)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<Challenge> parseChallenges(Headers headers, String string2) {
        ArrayList<Challenge> arrayList = new ArrayList<Challenge>();
        int n2 = headers.size();
        int n3 = 0;
        while (n3 < n2) {
            if (string2.equalsIgnoreCase(headers.name(n3))) {
                String string3 = headers.value(n3);
                int n4 = 0;
                while (n4 < string3.length()) {
                    int n5 = HeaderParser.skipUntil(string3, n4, " ");
                    String string4 = string3.substring(n4, n5).trim();
                    n4 = HeaderParser.skipWhitespace(string3, n5);
                    if (!string3.regionMatches(true, n4, "realm=\"", 0, "realm=\"".length())) break;
                    n4 = "realm=\"".length() + n4;
                    n5 = HeaderParser.skipUntil(string3, n4, "\"");
                    String string5 = string3.substring(n4, n5);
                    n4 = HeaderParser.skipWhitespace(string3, HeaderParser.skipUntil(string3, n5 + 1, ",") + 1);
                    arrayList.add(new Challenge(string4, string5));
                }
            }
            ++n3;
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Request processAuthHeader(Authenticator object, Response response, Proxy proxy) throws IOException {
        if (response.code() != 407) return object.authenticate(proxy, response);
        return object.authenticateProxy(proxy, response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long stringToLong(String string2) {
        long l2 = -1L;
        if (string2 == null) {
            return l2;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l2;
        }
    }

    public static Map<String, List<String>> toMultimap(Headers headers, String string2) {
        TreeMap treeMap = new TreeMap(FIELD_NAME_COMPARATOR);
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = headers.name(i2);
            String string4 = headers.value(i2);
            ArrayList<String> arrayList = new ArrayList<String>();
            List list = (List)treeMap.get(string3);
            if (list != null) {
                arrayList.addAll(list);
            }
            arrayList.add(string4);
            treeMap.put(string3, Collections.unmodifiableList(arrayList));
        }
        if (string2 != null) {
            treeMap.put(null, Collections.unmodifiableList(Collections.singletonList(string2)));
        }
        return Collections.unmodifiableMap(treeMap);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Set<String> varyFields(Headers headers) {
        Set<String> set = Collections.emptySet();
        int n2 = headers.size();
        int n3 = 0;
        while (n3 < n2) {
            if ("Vary".equalsIgnoreCase(headers.name(n3))) {
                String[] stringArray = headers.value(n3);
                Set<String> set2 = set;
                if (set.isEmpty()) {
                    set2 = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                }
                stringArray = stringArray.split(",");
                int n4 = stringArray.length;
                int n5 = 0;
                while (true) {
                    set = set2;
                    if (n5 >= n4) break;
                    set2.add(stringArray[n5].trim());
                    ++n5;
                }
            }
            ++n3;
        }
        return set;
    }

    private static Set<String> varyFields(Response response) {
        return OkHeaders.varyFields(response.headers());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Headers varyHeaders(Headers headers, Headers set) {
        if ((set = OkHeaders.varyFields(set)).isEmpty()) {
            return new Headers.Builder().build();
        }
        Headers.Builder builder = new Headers.Builder();
        int n2 = 0;
        int n3 = headers.size();
        while (n2 < n3) {
            String string2 = headers.name(n2);
            if (set.contains(string2)) {
                builder.add(string2, headers.value(n2));
            }
            ++n2;
        }
        return builder.build();
    }

    public static Headers varyHeaders(Response response) {
        return OkHeaders.varyHeaders(response.networkResponse().request().headers(), response.headers());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean varyMatches(Response object, Headers headers, Request request) {
        void var2_4;
        String string2;
        void var1_3;
        Iterator<String> iterator = OkHeaders.varyFields((Response)object).iterator();
        do {
            if (!iterator.hasNext()) return true;
        } while (Util.equal(var1_3.values(string2 = iterator.next()), var2_4.headers(string2)));
        return false;
    }
}

